/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.cli;

import com.forgerock.opendj.cli.Argument;
import com.forgerock.opendj.cli.ArgumentException;
import com.forgerock.opendj.cli.CliMessages;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizableMessageBuilder;

public final class IntegerArgument
extends Argument {
    private final boolean hasLowerBound;
    private final boolean hasUpperBound;
    private final int lowerBound;
    private final int upperBound;

    public IntegerArgument(String name, Character shortIdentifier, String longIdentifier, boolean isRequired, boolean isMultiValued, boolean needsValue, LocalizableMessage valuePlaceholder, int defaultValue, String propertyName, boolean hasLowerBound, int lowerBound, boolean hasUpperBound, int upperBound, LocalizableMessage description) throws ArgumentException {
        super(name, shortIdentifier, longIdentifier, isRequired, isMultiValued, needsValue, valuePlaceholder, String.valueOf(defaultValue), propertyName, description);
        this.hasLowerBound = hasLowerBound;
        this.hasUpperBound = hasUpperBound;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        if (hasLowerBound && hasUpperBound && lowerBound > upperBound) {
            LocalizableMessage message = CliMessages.ERR_INTARG_LOWER_BOUND_ABOVE_UPPER_BOUND.get((Object)name, (Object)lowerBound, (Object)upperBound);
            throw new ArgumentException(message);
        }
    }

    public IntegerArgument(String name, Character shortIdentifier, String longIdentifier, boolean isRequired, boolean isMultiValued, boolean needsValue, LocalizableMessage valuePlaceholder, int defaultValue, String propertyName, LocalizableMessage description) throws ArgumentException {
        super(name, shortIdentifier, longIdentifier, isRequired, isMultiValued, needsValue, valuePlaceholder, String.valueOf(defaultValue), propertyName, description);
        this.hasLowerBound = false;
        this.hasUpperBound = false;
        this.lowerBound = Integer.MIN_VALUE;
        this.upperBound = Integer.MAX_VALUE;
    }

    public IntegerArgument(String name, Character shortIdentifier, String longIdentifier, boolean isRequired, boolean needsValue, LocalizableMessage valuePlaceholder, boolean hasLowerBound, int lowerBound, boolean hasUpperBound, int upperBound, LocalizableMessage description) throws ArgumentException {
        super(name, shortIdentifier, longIdentifier, isRequired, false, needsValue, valuePlaceholder, null, null, description);
        this.hasLowerBound = hasLowerBound;
        this.hasUpperBound = hasUpperBound;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        if (hasLowerBound && hasUpperBound && lowerBound > upperBound) {
            LocalizableMessage message = CliMessages.ERR_INTARG_LOWER_BOUND_ABOVE_UPPER_BOUND.get((Object)name, (Object)lowerBound, (Object)upperBound);
            throw new ArgumentException(message);
        }
    }

    public IntegerArgument(String name, Character shortIdentifier, String longIdentifier, boolean isRequired, boolean needsValue, LocalizableMessage valuePlaceholder, LocalizableMessage description) throws ArgumentException {
        super(name, shortIdentifier, longIdentifier, isRequired, false, needsValue, valuePlaceholder, null, null, description);
        this.hasLowerBound = false;
        this.hasUpperBound = false;
        this.lowerBound = Integer.MIN_VALUE;
        this.upperBound = Integer.MAX_VALUE;
    }

    public int getLowerBound() {
        return this.lowerBound;
    }

    public int getUpperBound() {
        return this.upperBound;
    }

    public boolean hasLowerBound() {
        return this.hasLowerBound;
    }

    public boolean hasUpperBound() {
        return this.hasUpperBound;
    }

    @Override
    public boolean valueIsAcceptable(String valueString, LocalizableMessageBuilder invalidReason) {
        int intValue;
        try {
            intValue = Integer.parseInt(valueString);
        }
        catch (Exception e) {
            invalidReason.append(CliMessages.ERR_ARG_CANNOT_DECODE_AS_INT.get((Object)valueString, (Object)this.getPropertyName()));
            return false;
        }
        if (this.hasLowerBound && intValue < this.lowerBound) {
            invalidReason.append(CliMessages.ERR_INTARG_VALUE_BELOW_LOWER_BOUND.get((Object)this.getPropertyName(), (Object)intValue, (Object)this.lowerBound));
            return false;
        }
        if (this.hasUpperBound && intValue > this.upperBound) {
            invalidReason.append(CliMessages.ERR_INTARG_VALUE_ABOVE_UPPER_BOUND.get((Object)this.getPropertyName(), (Object)intValue, (Object)this.upperBound));
            return false;
        }
        return true;
    }
}

