/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.cli;

import com.forgerock.opendj.cli.ArgumentConstants;
import com.forgerock.opendj.cli.ArgumentException;
import com.forgerock.opendj.cli.BooleanArgument;
import com.forgerock.opendj.cli.CliMessages;
import com.forgerock.opendj.cli.FileBasedArgument;
import com.forgerock.opendj.cli.IntegerArgument;
import com.forgerock.opendj.cli.MultiChoiceArgument;
import com.forgerock.opendj.cli.StringArgument;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.SearchScope;

public final class CommonArguments {
    private CommonArguments() {
    }

    public static BooleanArgument getShowUsage() throws ArgumentException {
        return new BooleanArgument("help".toLowerCase(), Character.valueOf('H'), "help", CliMessages.INFO_DESCRIPTION_SHOWUSAGE.get());
    }

    public static BooleanArgument getVerbose() throws ArgumentException {
        BooleanArgument verbose = new BooleanArgument("verbose".toLowerCase(), ArgumentConstants.OPTION_SHORT_VERBOSE, "verbose", CliMessages.INFO_DESCRIPTION_VERBOSE.get());
        verbose.setPropertyName("verbose");
        return verbose;
    }

    public static IntegerArgument getPort(int defaultPort) throws ArgumentException {
        return CommonArguments.getPort(defaultPort, null);
    }

    public static IntegerArgument getPort(int defaultPort, LocalizableMessage description) throws ArgumentException {
        return new IntegerArgument("port".toLowerCase(), Character.valueOf('p'), "port", false, false, true, CliMessages.INFO_PORT_PLACEHOLDER.get(), defaultPort, "port", true, 1, true, 65535, description != null ? description : CliMessages.INFO_DESCRIPTION_ADMIN_PORT.get());
    }

    public static StringArgument getPostReadAttributes() throws ArgumentException {
        return new StringArgument("postreadattrs", null, "postReadAttributes", false, false, true, CliMessages.INFO_ATTRIBUTE_LIST_PLACEHOLDER.get(), null, "postReadAttributes", CliMessages.INFO_DESCRIPTION_POSTREAD_ATTRS.get());
    }

    public static StringArgument getPreReadAttributes() throws ArgumentException {
        return new StringArgument("prereadattrs", null, "preReadAttributes", false, false, true, CliMessages.INFO_ATTRIBUTE_LIST_PLACEHOLDER.get(), null, "preReadAttributes", CliMessages.INFO_DESCRIPTION_PREREAD_ATTRS.get());
    }

    public static StringArgument getPropertiesFile() throws ArgumentException {
        return new StringArgument("propertiesFilePath".toLowerCase(), null, "propertiesFilePath", false, false, true, CliMessages.INFO_PROP_FILE_PATH_PLACEHOLDER.get(), null, null, CliMessages.INFO_DESCRIPTION_PROP_FILE_PATH.get());
    }

    public static StringArgument getProxyAuthId() throws ArgumentException {
        return new StringArgument("proxyauthzid", Character.valueOf('Y'), "proxyAs", false, false, true, CliMessages.INFO_PROXYAUTHID_PLACEHOLDER.get(), null, "proxyAs", CliMessages.INFO_DESCRIPTION_PROXYAUTHZID.get());
    }

    public static BooleanArgument getNoPropertiesFile() throws ArgumentException {
        return new BooleanArgument("noPropertiesFile".toLowerCase(), null, "noPropertiesFile", CliMessages.INFO_DESCRIPTION_NO_PROP_FILE.get());
    }

    public static BooleanArgument getContinueOnError() throws ArgumentException {
        BooleanArgument continueOnError = new BooleanArgument("continueOnError", Character.valueOf('c'), "continueOnError", CliMessages.INFO_DESCRIPTION_CONTINUE_ON_ERROR.get());
        continueOnError.setPropertyName("continueOnError");
        return continueOnError;
    }

    public static StringArgument getControl() throws ArgumentException {
        StringArgument controlStr = new StringArgument("control".toLowerCase(), ArgumentConstants.OPTION_SHORT_CONTROL, "control", false, true, true, CliMessages.INFO_LDAP_CONTROL_PLACEHOLDER.get(), null, "control", CliMessages.INFO_DESCRIPTION_CONTROLS.get());
        controlStr.setDocDescriptionSupplement(CliMessages.SUPPLEMENT_DESCRIPTION_CONTROLS.get());
        return controlStr;
    }

    public static IntegerArgument getLdapVersion() throws ArgumentException {
        return new IntegerArgument("ldapVersion".toLowerCase(), Character.valueOf('V'), "ldapVersion", false, false, true, CliMessages.INFO_PROTOCOL_VERSION_PLACEHOLDER.get(), 3, "ldapVersion", CliMessages.INFO_DESCRIPTION_VERSION.get());
    }

    public static BooleanArgument getWindowsNetStop() throws ArgumentException {
        BooleanArgument netStop = new BooleanArgument("windowsnetstop", null, "windowsNetStop", CliMessages.INFO_DESCRIPTION_WINDOWS_NET_STOP.get());
        netStop.setHidden(true);
        return netStop;
    }

    public static BooleanArgument getQuiet() throws ArgumentException {
        BooleanArgument quiet = new BooleanArgument("quiet", ArgumentConstants.OPTION_SHORT_QUIET, "quiet", CliMessages.INFO_DESCRIPTION_QUIET.get());
        quiet.setPropertyName("quiet");
        return quiet;
    }

    public static BooleanArgument getNoOp() throws ArgumentException {
        return new BooleanArgument("no-op", Character.valueOf('n'), "dry-run", CliMessages.INFO_DESCRIPTION_NOOP.get());
    }

    public static BooleanArgument getNoPrompt() throws ArgumentException {
        return new BooleanArgument("no-prompt", ArgumentConstants.OPTION_SHORT_NO_PROMPT, "no-prompt", CliMessages.INFO_DESCRIPTION_NO_PROMPT.get());
    }

    public static BooleanArgument getAcceptLicense() throws ArgumentException {
        return new BooleanArgument("acceptLicense", null, "acceptLicense", CliMessages.INFO_OPTION_ACCEPT_LICENSE.get());
    }

    public static StringArgument getTargetLDIF(LocalizableMessage description) throws ArgumentException {
        return new StringArgument("targetldif", Character.valueOf('t'), "targetLDIF", true, false, true, CliMessages.INFO_LDIFFILE_PLACEHOLDER.get(), null, null, description);
    }

    public static IntegerArgument getTimeLimit() throws ArgumentException {
        return new IntegerArgument("timelimit", Character.valueOf('t'), "timeLimit", false, false, true, CliMessages.INFO_TIME_LIMIT_PLACEHOLDER.get(), 0, null, true, 0, false, 0, CliMessages.INFO_DESCRIPTION_TIME_LIMIT.get());
    }

    public static BooleanArgument getTrustAll() throws ArgumentException {
        BooleanArgument trustAll = new BooleanArgument("trustAll", Character.valueOf('X'), "trustAll", CliMessages.INFO_DESCRIPTION_TRUSTALL.get());
        trustAll.setPropertyName("trustAll");
        return trustAll;
    }

    public static StringArgument getTrustManagerProviderDN() throws ArgumentException {
        return new StringArgument("trustmanagerproviderdn", Character.valueOf('t'), "trustManagerProviderDN", false, false, true, CliMessages.INFO_TRUST_MANAGER_PROVIDER_DN_PLACEHOLDER.get(), null, null, CliMessages.INFO_DESCRIPTION_TRUSTMANAGER_PROVIDER_DN.get());
    }

    public static StringArgument getTrustStorePath() throws ArgumentException {
        return new StringArgument("trustStorePath", Character.valueOf('P'), "trustStorePath", false, false, true, CliMessages.INFO_TRUSTSTOREPATH_PLACEHOLDER.get(), null, "trustStorePath", CliMessages.INFO_DESCRIPTION_TRUSTSTOREPATH.get());
    }

    public static BooleanArgument getTypesOnly() throws ArgumentException {
        BooleanArgument typesOnly = new BooleanArgument("typesOnly", Character.valueOf('A'), "typesOnly", CliMessages.INFO_DESCRIPTION_TYPES_ONLY.get());
        typesOnly.setPropertyName("typesOnly");
        return typesOnly;
    }

    public static StringArgument getTrustStorePassword() throws ArgumentException {
        return new StringArgument("truststorepw", Character.valueOf('T'), "trustStorePassword", false, false, true, CliMessages.INFO_TRUSTSTORE_PWD_PLACEHOLDER.get(), null, "trustStorePassword", CliMessages.INFO_DESCRIPTION_TRUSTSTOREPASSWORD.get());
    }

    public static FileBasedArgument getTrustStorePasswordFile() throws ArgumentException {
        return new FileBasedArgument("trustStorePasswordFile", Character.valueOf('U'), "trustStorePasswordFile", false, false, CliMessages.INFO_TRUSTSTORE_PWD_FILE_PLACEHOLDER.get(), null, "trustStorePasswordFile", CliMessages.INFO_DESCRIPTION_TRUSTSTOREPASSWORD_FILE.get());
    }

    public static IntegerArgument getConnectTimeOut() throws ArgumentException {
        IntegerArgument connectTimeout = new IntegerArgument("connectTimeout", null, "connectTimeout", false, false, true, CliMessages.INFO_TIMEOUT_PLACEHOLDER.get(), 30000, null, true, 0, false, Integer.MAX_VALUE, CliMessages.INFO_DESCRIPTION_CONNECTION_TIMEOUT.get());
        connectTimeout.setPropertyName("connectTimeout");
        connectTimeout.setHidden(true);
        return connectTimeout;
    }

    public static StringArgument getCleanupService() throws ArgumentException {
        return new StringArgument("cleanupservice", Character.valueOf('c'), "cleanupService", false, false, true, CliMessages.INFO_SERVICE_NAME_PLACEHOLDER.get(), null, null, CliMessages.INFO_CONFIGURE_WINDOWS_SERVICE_DESCRIPTION_CLEANUP.get());
    }

    public static BooleanArgument getCLI() throws ArgumentException {
        BooleanArgument cli = new BooleanArgument("cli".toLowerCase(), Character.valueOf('i'), "cli", CliMessages.INFO_ARGUMENT_DESCRIPTION_CLI.get());
        cli.setPropertyName("cli");
        return cli;
    }

    public static BooleanArgument getCheckStoppability() throws ArgumentException {
        BooleanArgument cs = new BooleanArgument("checkstoppability", null, "checkStoppability", CliMessages.INFO_CHECK_STOPPABILITY.get());
        cs.setHidden(true);
        return cs;
    }

    public static StringArgument getConfigFile() throws ArgumentException {
        StringArgument configFile = new StringArgument("configfile", Character.valueOf('f'), "configFile", true, false, true, CliMessages.INFO_CONFIGFILE_PLACEHOLDER.get(), null, null, CliMessages.INFO_DESCRIPTION_CONFIG_FILE.get());
        configFile.setHidden(true);
        return configFile;
    }

    public static StringArgument getConfigClass(String configFileHandlerName) throws ArgumentException {
        StringArgument configClass = new StringArgument("configclass", Character.valueOf('C'), "configClass", true, false, true, CliMessages.INFO_CONFIGCLASS_PLACEHOLDER.get(), configFileHandlerName, null, CliMessages.INFO_DESCRIPTION_CONFIG_CLASS.get());
        configClass.setHidden(true);
        return configClass;
    }

    public static StringArgument getBackendId() throws ArgumentException {
        return new StringArgument("backendid", Character.valueOf('n'), "backendID", false, true, true, CliMessages.INFO_BACKENDNAME_PLACEHOLDER.get(), null, null, CliMessages.INFO_BACKUPDB_DESCRIPTION_BACKEND_ID.get());
    }

    public static StringArgument getBackupDirectory() throws ArgumentException {
        return new StringArgument("backupdirectory", Character.valueOf('d'), "backupDirectory", true, false, true, CliMessages.INFO_BACKUPDIR_PLACEHOLDER.get(), null, null, CliMessages.INFO_DESCRIPTION_BACKUP_DIR.get());
    }

    public static StringArgument getBackupId() throws ArgumentException {
        return new StringArgument("backupid", Character.valueOf('I'), "backupID", false, false, true, CliMessages.INFO_BACKUPID_PLACEHOLDER.get(), null, null, CliMessages.INFO_DESCRIPTION_BACKUP_ID.get());
    }

    public static BooleanArgument getBackupAll() throws ArgumentException {
        return new BooleanArgument("backupall", Character.valueOf('a'), "backUpAll", CliMessages.INFO_DESCRIPTION_BACKUP_ALL.get());
    }

    public static StringArgument getBaseDN() throws ArgumentException {
        return new StringArgument("baseDN".toLowerCase(), Character.valueOf('b'), "baseDN", false, true, true, CliMessages.INFO_BASEDN_PLACEHOLDER.get(), null, "baseDN", CliMessages.INFO_ARGUMENT_DESCRIPTION_BASEDN.get());
    }

    public static StringArgument getBatchFilePath() throws ArgumentException {
        return new StringArgument("batchFilePath", Character.valueOf('F'), "batchFilePath", false, false, true, CliMessages.INFO_BATCH_FILE_PATH_PLACEHOLDER.get(), null, null, CliMessages.INFO_DESCRIPTION_BATCH_FILE_PATH.get());
    }

    public static StringArgument getBindDN(String defaultBindDN) throws ArgumentException {
        return new StringArgument("bindDN", Character.valueOf('D'), "bindDN", false, false, true, CliMessages.INFO_BINDDN_PLACEHOLDER.get(), defaultBindDN, "bindDN", CliMessages.INFO_DESCRIPTION_BINDDN.get());
    }

    public static StringArgument getBindPassword() throws ArgumentException {
        return new StringArgument("bindPassword", Character.valueOf('w'), "bindPassword", false, false, true, CliMessages.INFO_BINDPWD_PLACEHOLDER.get(), null, "bindPassword", CliMessages.INFO_DESCRIPTION_BINDPASSWORD.get());
    }

    public static FileBasedArgument getBindPasswordFile() throws ArgumentException {
        return new FileBasedArgument("bindPasswordFile", Character.valueOf('j'), "bindPasswordFile", false, false, CliMessages.INFO_BINDPWD_FILE_PLACEHOLDER.get(), null, "bindPasswordFile", CliMessages.INFO_DESCRIPTION_BINDPASSWORDFILE.get());
    }

    public static BooleanArgument getAddBaseEntry() throws ArgumentException {
        BooleanArgument addBaseEntryArg = new BooleanArgument("addBaseEntry".toLowerCase(), Character.valueOf('a'), "addBaseEntry", CliMessages.INFO_ARGUMENT_DESCRIPTION_ADDBASE.get());
        addBaseEntryArg.setPropertyName("addBaseEntry");
        return addBaseEntryArg;
    }

    public static StringArgument getRejectedImportLdif() throws ArgumentException {
        return new StringArgument("rejectFile".toLowerCase(), Character.valueOf('R'), "rejectFile", false, false, true, CliMessages.INFO_REJECT_FILE_PLACEHOLDER.get(), null, "rejectFile", CliMessages.INFO_GENERAL_DESCRIPTION_REJECTED_FILE.get());
    }

    public static BooleanArgument getRemote() throws ArgumentException {
        BooleanArgument remote = new BooleanArgument("remote".toLowerCase(), Character.valueOf('r'), "remote", CliMessages.INFO_DESCRIPTION_REMOTE.get());
        remote.setPropertyName("remote");
        return remote;
    }

    public static BooleanArgument getReportAuthzId() throws ArgumentException {
        BooleanArgument report = new BooleanArgument("reportAuthzID".toLowerCase(), Character.valueOf('E'), "reportAuthzID", CliMessages.INFO_DESCRIPTION_REPORT_AUTHZID.get());
        report.setPropertyName("reportAuthzID");
        return report;
    }

    public static BooleanArgument getRestart() throws ArgumentException {
        BooleanArgument restart = new BooleanArgument("restart".toLowerCase(), Character.valueOf('R'), "restart", CliMessages.INFO_DESCRIPTION_RESTART.get());
        restart.setPropertyName("restart");
        return restart;
    }

    public static StringArgument getSkippedImportFile() throws ArgumentException {
        return new StringArgument("skipFile".toLowerCase(), null, "skipFile", false, false, true, CliMessages.INFO_SKIP_FILE_PLACEHOLDER.get(), null, "skipFile", CliMessages.INFO_GENERAL_DESCRIPTION_SKIPPED_FILE.get());
    }

    public static IntegerArgument getSampleData() throws ArgumentException {
        return new IntegerArgument("sampleData".toLowerCase(), Character.valueOf('d'), "sampleData", false, false, true, CliMessages.INFO_NUM_ENTRIES_PLACEHOLDER.get(), 0, "sampleData", true, 0, false, 0, CliMessages.INFO_SETUP_DESCRIPTION_SAMPLE_DATA.get());
    }

    public static StringArgument getSASL() throws ArgumentException {
        return new StringArgument("sasloption", Character.valueOf('o'), "saslOption", false, true, true, CliMessages.INFO_SASL_OPTION_PLACEHOLDER.get(), null, "saslOption", CliMessages.INFO_LDAP_CONN_DESCRIPTION_SASLOPTIONS.get());
    }

    public static MultiChoiceArgument<SearchScope> getSearchScope() throws ArgumentException {
        MultiChoiceArgument<SearchScope> searchScope = new MultiChoiceArgument<SearchScope>("searchScope", Character.valueOf('s'), "searchScope", false, true, CliMessages.INFO_SEARCH_SCOPE_PLACEHOLDER.get(), SearchScope.values(), false, CliMessages.INFO_SEARCH_DESCRIPTION_SEARCH_SCOPE.get());
        searchScope.setPropertyName("searchScope");
        searchScope.setDefaultValue(SearchScope.WHOLE_SUBTREE);
        return searchScope;
    }

    public static StringArgument getServerRoot() throws ArgumentException {
        StringArgument serverRoot = new StringArgument("serverRoot", ArgumentConstants.OPTION_SHORT_SERVER_ROOT, "serverRoot", false, false, true, CliMessages.INFO_SERVER_ROOT_DIR_PLACEHOLDER.get(), null, null, null);
        serverRoot.setHidden(true);
        return serverRoot;
    }

    public static BooleanArgument getServiceState() throws ArgumentException {
        return new BooleanArgument("servicestate", Character.valueOf('s'), "serviceState", CliMessages.INFO_CONFIGURE_WINDOWS_SERVICE_DESCRIPTION_STATE.get());
    }

    public static BooleanArgument getScriptFriendly() throws ArgumentException {
        BooleanArgument sf = new BooleanArgument("script-friendly", ArgumentConstants.OPTION_SHORT_SCRIPT_FRIENDLY, "script-friendly", CliMessages.INFO_DESCRIPTION_SCRIPT_FRIENDLY.get());
        sf.setPropertyName("script-friendly");
        return sf;
    }

    public static IntegerArgument getLDAPPort(int defaultLdapPort) throws ArgumentException {
        return new IntegerArgument("ldapPort".toLowerCase(), Character.valueOf('p'), "ldapPort", false, false, true, CliMessages.INFO_PORT_PLACEHOLDER.get(), defaultLdapPort, "ldapPort", true, 1, true, 65535, CliMessages.INFO_ARGUMENT_DESCRIPTION_LDAPPORT.get());
    }

    public static IntegerArgument getAdminLDAPPort(int defaultAdminPort) throws ArgumentException {
        return new IntegerArgument("adminConnectorPort".toLowerCase(), null, "adminConnectorPort", false, false, true, CliMessages.INFO_PORT_PLACEHOLDER.get(), defaultAdminPort, "adminConnectorPort", true, 1, true, 65535, CliMessages.INFO_ARGUMENT_DESCRIPTION_ADMINCONNECTORPORT.get());
    }

    public static BooleanArgument getAdvancedMode() throws ArgumentException {
        BooleanArgument advanced = new BooleanArgument("advanced", null, "advanced", CliMessages.INFO_DESCRIPTION_ADVANCED.get());
        advanced.setPropertyName("advanced");
        return advanced;
    }

    public static StringArgument getAssertionFilter() throws ArgumentException {
        return new StringArgument("assertionfilter", null, "assertionFilter", false, false, true, CliMessages.INFO_ASSERTION_FILTER_PLACEHOLDER.get(), null, "assertionFilter", CliMessages.INFO_DESCRIPTION_ASSERTION_FILTER.get());
    }

    public static IntegerArgument getJMXPort(int defaultJMXPort) throws ArgumentException {
        return new IntegerArgument("jmxPort".toLowerCase(), Character.valueOf('x'), "jmxPort", false, false, true, CliMessages.INFO_JMXPORT_PLACEHOLDER.get(), defaultJMXPort, "jmxPort", true, 1, true, 65535, CliMessages.INFO_ARGUMENT_DESCRIPTION_SKIPPORT.get());
    }

    public static BooleanArgument getSkipPortCheck() throws ArgumentException {
        BooleanArgument skipPortCheck = new BooleanArgument("skipPortCheck".toLowerCase(), Character.valueOf('S'), "skipPortCheck", CliMessages.INFO_ARGUMENT_DESCRIPTION_SKIPPORT.get());
        skipPortCheck.setPropertyName("skipPortCheck");
        return skipPortCheck;
    }

    public static StringArgument getSourceLDIF(LocalizableMessage description) throws ArgumentException {
        return new StringArgument("sourceldif", Character.valueOf('s'), "sourceLDIF", true, false, true, CliMessages.INFO_LDIFFILE_PLACEHOLDER.get(), null, null, description);
    }

    public static BooleanArgument getStartTLS() throws ArgumentException {
        BooleanArgument useStartTLS = new BooleanArgument("startTLS", Character.valueOf('q'), "useStartTLS", CliMessages.INFO_DESCRIPTION_START_TLS.get());
        useStartTLS.setPropertyName("useStartTLS");
        return useStartTLS;
    }

    public static StringArgument getStopReason() throws ArgumentException {
        return new StringArgument("stopreason", Character.valueOf('r'), "stopReason", false, false, true, CliMessages.INFO_STOP_REASON_PLACEHOLDER.get(), null, "stopReason", CliMessages.INFO_DESCRIPTION_STOP_REASON.get());
    }

    public static StringArgument getStopTime() throws ArgumentException {
        return new StringArgument("stoptime", Character.valueOf('t'), "stopTime", false, false, true, CliMessages.INFO_STOP_TIME_PLACEHOLDER.get(), null, "stopTime", CliMessages.INFO_DESCRIPTION_STOP_TIME.get());
    }

    public static StringArgument getRootDN() throws ArgumentException {
        return new StringArgument("rootUserDN".toLowerCase(), Character.valueOf('D'), "rootUserDN", false, false, true, CliMessages.INFO_ROOT_USER_DN_PLACEHOLDER.get(), "cn=Directory Manager", "rootUserDN", CliMessages.INFO_ARGUMENT_DESCRIPTION_ROOTDN.get());
    }

    public static StringArgument getRootDNPwd() throws ArgumentException {
        return new StringArgument("rootUserPassword".toLowerCase(), Character.valueOf('w'), "rootUserPassword", false, false, true, CliMessages.INFO_ROOT_USER_PWD_PLACEHOLDER.get(), null, "rootUserPassword", CliMessages.INFO_ROOT_USER_PWD_PLACEHOLDER.get());
    }

    public static FileBasedArgument getRootDNPwdFile() throws ArgumentException {
        return new FileBasedArgument("rootUserPasswordFile".toLowerCase(), Character.valueOf('j'), "rootUserPasswordFile", false, false, CliMessages.INFO_ROOT_USER_PWD_FILE_PLACEHOLDER.get(), null, "rootUserPasswordFile", CliMessages.INFO_ARGUMENT_DESCRIPTION_ROOTPWFILE.get());
    }

    public static BooleanArgument getEnableWindowsService() throws ArgumentException {
        BooleanArgument enableWindowsServiceArg = new BooleanArgument("enableWindowsService".toLowerCase(), Character.valueOf('e'), "enableWindowsService", CliMessages.INFO_ARGUMENT_DESCRIPTION_ENABLE_WINDOWS_SERVICE.get());
        enableWindowsServiceArg.setPropertyName("enableWindowsService");
        return enableWindowsServiceArg;
    }

    public static StringArgument getEncoding() throws ArgumentException {
        return new StringArgument("encoding", Character.valueOf('i'), "encoding", false, false, true, CliMessages.INFO_ENCODING_PLACEHOLDER.get(), null, "encoding", CliMessages.INFO_DESCRIPTION_ENCODING.get());
    }

    public static BooleanArgument getDoNotStart() throws ArgumentException {
        BooleanArgument doNotStartArg = new BooleanArgument("doNotStart".toLowerCase(), Character.valueOf('O'), "doNotStart", CliMessages.INFO_SETUP_DESCRIPTION_DO_NOT_START.get());
        doNotStartArg.setPropertyName("doNotStart");
        return doNotStartArg;
    }

    public static BooleanArgument getDefaultAdd() throws ArgumentException {
        return new BooleanArgument("defaultAdd", Character.valueOf('a'), "defaultAdd", CliMessages.INFO_MODIFY_DESCRIPTION_DEFAULT_ADD.get());
    }

    public static BooleanArgument getDisableService() throws ArgumentException {
        return new BooleanArgument("disableservice", Character.valueOf('d'), "disableService", CliMessages.INFO_CONFIGURE_WINDOWS_SERVICE_DESCRIPTION_DISABLE.get());
    }

    public static BooleanArgument getDisplayEquivalentCommand() throws ArgumentException {
        return new BooleanArgument("displayCommand", null, "displayCommand", CliMessages.INFO_DESCRIPTION_DISPLAY_EQUIVALENT.get());
    }

    public static StringArgument getEquivalentCommandFile(LocalizableMessage description) throws ArgumentException {
        return new StringArgument("commandFilePath", null, "commandFilePath", false, false, true, CliMessages.INFO_PATH_PLACEHOLDER.get(), null, null, description);
    }

    public static StringArgument getFilename(LocalizableMessage description) throws ArgumentException {
        return new StringArgument("filename", Character.valueOf('f'), "filename", false, false, true, CliMessages.INFO_FILE_PLACEHOLDER.get(), null, "filename", description);
    }

    public static BooleanArgument getEnableTLS() throws ArgumentException {
        BooleanArgument enableStartTLS = new BooleanArgument("enableStartTLS".toLowerCase(), Character.valueOf('q'), "enableStartTLS", CliMessages.INFO_SETUP_DESCRIPTION_ENABLE_STARTTLS.get());
        enableStartTLS.setPropertyName("enableStartTLS");
        return enableStartTLS;
    }

    public static IntegerArgument getLDAPSPort(int defaultSecurePort) throws ArgumentException {
        return new IntegerArgument("ldapsPort".toLowerCase(), Character.valueOf('Z'), "ldapsPort", false, false, true, CliMessages.INFO_PORT_PLACEHOLDER.get(), defaultSecurePort, "ldapsPort", true, 1, true, 65535, CliMessages.INFO_ARGUMENT_DESCRIPTION_LDAPSPORT.get());
    }

    public static StringArgument getLDIFFile(LocalizableMessage description) throws ArgumentException {
        return new StringArgument("ldifFile".toLowerCase(), Character.valueOf('l'), "ldifFile", false, true, true, CliMessages.INFO_LDIFFILE_PLACEHOLDER.get(), null, null, description);
    }

    public static BooleanArgument getGenerateSelfSigned() throws ArgumentException {
        BooleanArgument generateSelfSigned = new BooleanArgument("generateSelfSignedCertificate".toLowerCase(), null, "generateSelfSignedCertificate", CliMessages.INFO_ARGUMENT_DESCRIPTION_USE_SELF_SIGNED_CERTIFICATE.get());
        generateSelfSigned.setPropertyName("generateSelfSignedCertificate");
        return generateSelfSigned;
    }

    public static StringArgument getHostName(String defaultHostName) throws ArgumentException {
        return CommonArguments.getHostName(defaultHostName, null);
    }

    public static StringArgument getHostName(String defaultHostName, LocalizableMessage description) throws ArgumentException {
        return new StringArgument("hostname".toLowerCase(), Character.valueOf('h'), "hostname", false, false, true, CliMessages.INFO_HOST_PLACEHOLDER.get(), defaultHostName, "hostname", description != null ? description : CliMessages.INFO_ARGUMENT_DESCRIPTION_HOST_NAME.get());
    }

    public static BooleanArgument getUsePKCS11Keystore() throws ArgumentException {
        BooleanArgument usePkcs11 = new BooleanArgument("usePkcs11Keystore".toLowerCase(), null, "usePkcs11Keystore", CliMessages.INFO_ARGUMENT_DESCRIPTION_USE_PKCS11.get());
        usePkcs11.setPropertyName("usePkcs11Keystore");
        return usePkcs11;
    }

    public static StringArgument getUseJavaKeyStore() throws ArgumentException {
        return new StringArgument("useJavaKeystore".toLowerCase(), null, "useJavaKeystore", false, false, true, CliMessages.INFO_KEYSTOREPATH_PLACEHOLDER.get(), null, "useJavaKeystore", CliMessages.INFO_ARGUMENT_DESCRIPTION_USE_JAVAKEYSTORE.get());
    }

    public static StringArgument getUseJCEKS() throws ArgumentException {
        return new StringArgument("useJCEKS".toLowerCase(), null, "useJCEKS", false, false, true, CliMessages.INFO_KEYSTOREPATH_PLACEHOLDER.get(), null, "useJCEKS", CliMessages.INFO_ARGUMENT_DESCRIPTION_USE_JCEKS.get());
    }

    public static StringArgument getUsePKCS12KeyStore() throws ArgumentException {
        return new StringArgument("usePkcs12keyStore".toLowerCase(), null, "usePkcs12keyStore", false, false, true, CliMessages.INFO_KEYSTOREPATH_PLACEHOLDER.get(), null, "usePkcs12keyStore", CliMessages.INFO_ARGUMENT_DESCRIPTION_USE_PKCS12.get());
    }

    public static BooleanArgument getUseSASLExternal() throws ArgumentException {
        BooleanArgument useSASLExternal = new BooleanArgument("useSASLExternal", Character.valueOf('r'), "useSASLExternal", CliMessages.INFO_DESCRIPTION_USE_SASL_EXTERNAL.get());
        useSASLExternal.setPropertyName("useSASLExternal");
        return useSASLExternal;
    }

    public static BooleanArgument getUseSSL() throws ArgumentException {
        BooleanArgument useSSL = new BooleanArgument("useSSL", Character.valueOf('Z'), "useSSL", CliMessages.INFO_DESCRIPTION_USE_SSL.get());
        useSSL.setPropertyName("useSSL");
        return useSSL;
    }

    public static StringArgument getKeyManagerPath() throws ArgumentException {
        return new StringArgument("keymanagerpath", Character.valueOf('m'), "keyManagerPath", false, false, true, CliMessages.INFO_KEY_MANAGER_PATH_PLACEHOLDER.get(), null, null, CliMessages.INFO_DESCRIPTION_KEYMANAGER_PATH.get());
    }

    public static StringArgument getKeyManagerProviderDN() throws ArgumentException {
        return new StringArgument("keymanagerproviderdn", Character.valueOf('k'), "keyManagerProviderDN", false, false, true, CliMessages.INFO_KEY_MANAGER_PROVIDER_DN_PLACEHOLDER.get(), null, null, CliMessages.INFO_DESCRIPTION_KEYMANAGER_PROVIDER_DN.get());
    }

    public static StringArgument getKeyStorePassword() throws ArgumentException {
        return new StringArgument("keyStorePassword".toLowerCase(), Character.valueOf('W'), "keyStorePassword", false, false, true, CliMessages.INFO_KEYSTORE_PWD_PLACEHOLDER.get(), null, "keyStorePassword", CliMessages.INFO_ARGUMENT_DESCRIPTION_KEYSTOREPASSWORD.get());
    }

    public static FileBasedArgument getKeyStorePasswordFile() throws ArgumentException {
        return new FileBasedArgument("keyStorePasswordFile".toLowerCase(), Character.valueOf('u'), "keyStorePasswordFile", false, false, CliMessages.INFO_KEYSTORE_PWD_FILE_PLACEHOLDER.get(), null, "keyStorePasswordFile", CliMessages.INFO_ARGUMENT_DESCRIPTION_KEYSTOREPASSWORD_FILE.get());
    }

    public static StringArgument getKeyStorePath() throws ArgumentException {
        StringArgument ksPath = new StringArgument("keyStorePath", Character.valueOf('K'), "keyStorePath", false, false, true, CliMessages.INFO_KEYSTOREPATH_PLACEHOLDER.get(), null, null, CliMessages.INFO_DESCRIPTION_KEYSTOREPATH.get());
        ksPath.setPropertyName("keyStorePath");
        return ksPath;
    }

    public static StringArgument getCertNickName() throws ArgumentException {
        return new StringArgument("certNickname".toLowerCase(), Character.valueOf('N'), "certNickname", false, true, true, CliMessages.INFO_NICKNAME_PLACEHOLDER.get(), null, "certNickname", CliMessages.INFO_ARGUMENT_DESCRIPTION_CERT_NICKNAME.get());
    }
}

