/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.cli;

import com.forgerock.opendj.cli.Argument;
import com.forgerock.opendj.cli.ArgumentException;
import com.forgerock.opendj.cli.CliMessages;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizableMessageBuilder;

public final class BooleanArgument
extends Argument {
    public BooleanArgument(String name, Character shortIdentifier, String longIdentifier, LocalizableMessage description) throws ArgumentException {
        super(name, shortIdentifier, longIdentifier, false, false, false, null, String.valueOf(false), null, description);
    }

    @Override
    public final void addValue(String valueString) {
        if (valueString != null) {
            this.clearValues();
            super.addValue(valueString);
            super.setPresent(Boolean.valueOf(valueString));
        }
    }

    @Override
    public final void setPresent(boolean isPresent) {
        this.addValue(String.valueOf(isPresent));
    }

    @Override
    public boolean valueIsAcceptable(String valueString, LocalizableMessageBuilder invalidReason) {
        invalidReason.append(CliMessages.ERR_BOOLEANARG_NO_VALUE_ALLOWED.get((Object)this.getName()));
        return false;
    }
}

