/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.cli;

import com.forgerock.opendj.cli.Argument;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.forgerock.i18n.LocalizableMessage;

public final class ArgumentGroup
implements Comparable<ArgumentGroup> {
    private LocalizableMessage description;
    private final List<Argument> args = new LinkedList<Argument>();
    private final Integer priority;

    public ArgumentGroup(LocalizableMessage description, int priority) {
        this.description = description;
        this.priority = priority;
    }

    @Override
    public int compareTo(ArgumentGroup o) {
        return -1 * this.priority.compareTo(o.priority);
    }

    public boolean addArgument(Argument arg) {
        if (arg != null) {
            Character newShort = arg.getShortIdentifier();
            String newLong = arg.getLongIdentifier();
            Iterator<Argument> it = this.args.iterator();
            while (it.hasNext()) {
                Argument a = it.next();
                if ((newShort == null || !newShort.equals(a.getShortIdentifier())) && (newLong == null || !newLong.equals(a.getLongIdentifier()))) continue;
                it.remove();
                break;
            }
            return this.args.add(arg);
        }
        return false;
    }

    boolean containsArguments() {
        return this.args.size() > 0;
    }

    boolean containsNonHiddenArguments() {
        for (Argument arg : this.args) {
            if (arg.isHidden()) continue;
            return true;
        }
        return false;
    }

    List<Argument> getArguments() {
        return Collections.unmodifiableList(this.args);
    }

    LocalizableMessage getDescription() {
        return this.description;
    }

    boolean removeArgument(Argument arg) {
        return this.args.remove(arg);
    }

    void setDescription(LocalizableMessage description) {
        this.description = description;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(description=" + this.description + ")";
    }
}

