/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.oauth2.resolver;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.forgerock.http.Handler;
import org.forgerock.http.oauth2.AccessTokenException;
import org.forgerock.http.oauth2.AccessTokenInfo;
import org.forgerock.http.oauth2.AccessTokenResolver;
import org.forgerock.http.protocol.Entity;
import org.forgerock.http.protocol.Form;
import org.forgerock.http.protocol.Request;
import org.forgerock.http.protocol.Response;
import org.forgerock.http.protocol.Responses;
import org.forgerock.http.protocol.Status;
import org.forgerock.json.JsonValue;
import org.forgerock.json.JsonValueException;
import org.forgerock.services.context.Context;
import org.forgerock.util.Function;
import org.forgerock.util.Utils;
import org.forgerock.util.annotations.VisibleForTesting;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;
import org.forgerock.util.time.TimeService;

public class OpenAmAccessTokenResolver
implements AccessTokenResolver {
    private final Handler client;
    private final String tokenInfoEndpoint;
    private final Function<JsonValue, AccessTokenInfo, AccessTokenException> accessToken;

    public OpenAmAccessTokenResolver(Handler client, TimeService time, String tokenInfoEndpoint) {
        this(client, new TokenInfoParser(time), tokenInfoEndpoint);
    }

    private OpenAmAccessTokenResolver(Handler client, Function<JsonValue, AccessTokenInfo, AccessTokenException> accessToken, String tokenInfoEndpoint) {
        this.client = client;
        this.accessToken = accessToken;
        this.tokenInfoEndpoint = tokenInfoEndpoint;
    }

    @Override
    public Promise<AccessTokenInfo, AccessTokenException> resolve(Context context, String token) {
        try {
            Request request = new Request();
            request.setMethod("GET");
            request.setUri(new URI(this.tokenInfoEndpoint));
            Form form = new Form();
            form.add((Object)"access_token", (Object)token);
            form.toRequestQuery(request);
            return this.client.handle(context, request).then(this.onResult(), Responses.noopExceptionFunction());
        }
        catch (URISyntaxException e) {
            return Promises.newExceptionPromise((Exception)new AccessTokenException(String.format("The token_info endpoint %s could not be accessed because it is a malformed URI", this.tokenInfoEndpoint), e));
        }
    }

    private Function<Response, AccessTokenInfo, AccessTokenException> onResult() {
        return new Function<Response, AccessTokenInfo, AccessTokenException>(){

            public AccessTokenInfo apply(Response response) throws AccessTokenException {
                if (OpenAmAccessTokenResolver.this.isResponseEmpty(response)) {
                    throw new AccessTokenException("Authorization Server did not return any AccessToken");
                }
                JsonValue content = OpenAmAccessTokenResolver.this.asJson(response.getEntity());
                if (OpenAmAccessTokenResolver.this.isOk(response)) {
                    return (AccessTokenInfo)content.as(OpenAmAccessTokenResolver.this.accessToken);
                }
                if (content.isDefined("error")) {
                    String error = content.get("error").asString();
                    String description = content.get("error_description").asString();
                    throw new AccessTokenException(String.format("Authorization Server returned an error (error: %s, description: %s)", error, description));
                }
                throw new AccessTokenException("AccessToken returned by the AuthorizationServer has a problem");
            }
        };
    }

    private boolean isResponseEmpty(Response response) {
        return response == null || response.getEntity() == null;
    }

    private boolean isOk(Response response) {
        return Status.OK.equals(response.getStatus());
    }

    private JsonValue asJson(Entity entity) throws AccessTokenException {
        JsonValue jsonValue;
        try {
            jsonValue = new JsonValue(entity.getJson());
        }
        catch (IOException e) {
            try {
                throw new AccessTokenException("Cannot read response content as JSON", e);
            }
            catch (Throwable throwable) {
                Utils.closeSilently((Closeable[])new Closeable[]{entity});
                throw throwable;
            }
        }
        Utils.closeSilently((Closeable[])new Closeable[]{entity});
        return jsonValue;
    }

    @VisibleForTesting
    static class TokenInfoParser
    implements Function<JsonValue, AccessTokenInfo, AccessTokenException> {
        private final TimeService time;

        TokenInfoParser(TimeService time) {
            this.time = time;
        }

        public AccessTokenInfo apply(JsonValue raw) throws AccessTokenException {
            try {
                long expiresIn = raw.get("expires_in").required().asLong();
                Set scopes = raw.get("scope").required().asSet(String.class);
                String token = raw.get("access_token").required().asString();
                return new AccessTokenInfo(raw, token, scopes, this.getExpirationTime(expiresIn));
            }
            catch (JsonValueException e) {
                throw new AccessTokenException("Cannot build AccessToken from the given JSON: invalid format", (Exception)((Object)e));
            }
        }

        private long getExpirationTime(long delayInSeconds) {
            return this.time.now() + TimeUnit.MILLISECONDS.convert(delayInSeconds, TimeUnit.SECONDS);
        }
    }
}

