/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.oauth2.resolver;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.forgerock.http.oauth2.AccessTokenException;
import org.forgerock.http.oauth2.AccessTokenInfo;
import org.forgerock.http.oauth2.AccessTokenResolver;
import org.forgerock.services.context.Context;
import org.forgerock.util.AsyncFunction;
import org.forgerock.util.Function;
import org.forgerock.util.PerItemEvictionStrategyCache;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;
import org.forgerock.util.time.Duration;
import org.forgerock.util.time.TimeService;

public class CachingAccessTokenResolver
implements AccessTokenResolver {
    private final AccessTokenResolver resolver;
    private final PerItemEvictionStrategyCache<String, Promise<AccessTokenInfo, AccessTokenException>> cache;
    private final AsyncFunction<Promise<AccessTokenInfo, AccessTokenException>, Duration, Exception> expires;

    public CachingAccessTokenResolver(TimeService time, AccessTokenResolver resolver, PerItemEvictionStrategyCache<String, Promise<AccessTokenInfo, AccessTokenException>> cache) {
        this.resolver = resolver;
        this.cache = cache;
        this.expires = new AccessTokenExpirationFunction(time);
    }

    @Override
    public Promise<AccessTokenInfo, AccessTokenException> resolve(Context context, String token) {
        try {
            return (Promise)this.cache.getValue((Object)token, this.resolveToken(context, token), this.expires);
        }
        catch (InterruptedException e) {
            return Promises.newExceptionPromise((Exception)new AccessTokenException("Timed out retrieving OAuth2 access token information", e));
        }
        catch (ExecutionException e) {
            return Promises.newExceptionPromise((Exception)new AccessTokenException("Initial token resolution has failed", e));
        }
    }

    private Callable<Promise<AccessTokenInfo, AccessTokenException>> resolveToken(final Context context, final String token) {
        return new Callable<Promise<AccessTokenInfo, AccessTokenException>>(){

            @Override
            public Promise<AccessTokenInfo, AccessTokenException> call() throws Exception {
                return CachingAccessTokenResolver.this.resolver.resolve(context, token);
            }
        };
    }

    private static class AccessTokenExpirationFunction
    implements AsyncFunction<Promise<AccessTokenInfo, AccessTokenException>, Duration, Exception> {
        private static final Function<AccessTokenException, Duration, AccessTokenException> TIMEOUT_ZERO = new Function<AccessTokenException, Duration, AccessTokenException>(){

            public Duration apply(AccessTokenException e) {
                return Duration.ZERO;
            }
        };
        private final Function<AccessTokenInfo, Duration, AccessTokenException> computeTtl;

        public AccessTokenExpirationFunction(final TimeService time) {
            this.computeTtl = new Function<AccessTokenInfo, Duration, AccessTokenException>(){

                public Duration apply(AccessTokenInfo accessToken) {
                    if (accessToken.getExpiresAt() == Long.MAX_VALUE) {
                        return Duration.UNLIMITED;
                    }
                    long expires = accessToken.getExpiresAt() - time.now();
                    if (expires <= 0L) {
                        return Duration.ZERO;
                    }
                    return Duration.duration((long)expires, (TimeUnit)TimeUnit.MILLISECONDS);
                }
            };
        }

        public Promise<? extends Duration, ? extends Exception> apply(Promise<AccessTokenInfo, AccessTokenException> accessTokenPromise) throws Exception {
            return accessTokenPromise.then(this.computeTtl, TIMEOUT_ZERO);
        }
    }
}

