/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public final class Json {
    private static final ObjectMapper LENIENT_MAPPER = new ObjectMapper();
    private static final ObjectMapper STRICT_MAPPER;

    private Json() {
    }

    public static void checkJsonCompatibility(String trail, Object value) {
        if (value == null) {
            return;
        }
        Class<?> type = value.getClass();
        List<Object> object = value;
        if (object instanceof Boolean) {
            return;
        }
        if (object instanceof Character) {
            return;
        }
        if (object instanceof Number) {
            return;
        }
        if (object instanceof CharSequence) {
            return;
        }
        if (type.isArray()) {
            object = Arrays.asList((Object[])value);
        }
        if (object instanceof List) {
            List<Object> list = object;
            for (int i = 0; i < list.size(); ++i) {
                Json.checkJsonCompatibility(String.format("%s[%d]", trail, i), list.get(i));
            }
            return;
        }
        if (object instanceof Map) {
            Map map = (Map)((Object)object);
            for (Map.Entry entry : map.entrySet()) {
                Json.checkJsonCompatibility(String.format("%s/%s", trail, entry.getKey()), entry.getValue());
            }
            return;
        }
        throw new IllegalArgumentException(String.format("The object referenced through '%s' cannot be safely serialized as JSON", trail));
    }

    public static Object readJson(String rawData) throws IOException {
        if (rawData == null) {
            return null;
        }
        return Json.readJson(new StringReader(rawData));
    }

    public static Object readJson(Reader reader) throws IOException {
        return Json.parse(STRICT_MAPPER, reader);
    }

    public static Object readJsonLenient(Reader reader) throws IOException {
        return Json.parse(LENIENT_MAPPER, reader);
    }

    public static Object readJsonLenient(InputStream in) throws IOException {
        return Json.parse(LENIENT_MAPPER, new InputStreamReader(in));
    }

    private static Object parse(ObjectMapper mapper, Reader reader) throws IOException {
        if (reader == null) {
            return null;
        }
        return mapper.readValue(reader, Object.class);
    }

    public static byte[] writeJson(Object objectToWrite) throws IOException {
        return STRICT_MAPPER.writeValueAsBytes(objectToWrite);
    }

    static {
        LENIENT_MAPPER.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        LENIENT_MAPPER.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        LENIENT_MAPPER.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        STRICT_MAPPER = new ObjectMapper();
    }
}

