/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.routing;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forgerock.http.routing.RoutingMode;
import org.forgerock.http.routing.UriRouterContext;
import org.forgerock.http.util.Paths;
import org.forgerock.services.context.Context;
import org.forgerock.services.routing.IncomparableRouteMatchException;
import org.forgerock.services.routing.RouteMatch;
import org.forgerock.services.routing.RouteMatcher;

class UriRouteMatcher
extends RouteMatcher<List<String>> {
    private final RoutingMode mode;
    private final Pattern regex;
    private final String uriTemplate;
    private final List<String> variables = new LinkedList<String>();

    UriRouteMatcher(RoutingMode mode, String uriTemplate) {
        this.uriTemplate = uriTemplate;
        this.mode = mode;
        this.regex = UriTemplateParser.createRegex(mode, uriTemplate, this.variables);
    }

    @Override
    public final RouteMatch evaluate(Context context, List<String> pathElements) {
        Map<Object, Object> variableMap;
        String uri = Paths.joinPath(pathElements);
        Matcher matcher = this.regex.matcher(uri);
        if (!matcher.matches()) {
            return null;
        }
        switch (this.variables.size()) {
            case 0: {
                variableMap = Collections.emptyMap();
                break;
            }
            case 1: {
                variableMap = Collections.singletonMap(this.variables.get(0), Paths.urlDecode(matcher.group(2)));
                break;
            }
            default: {
                variableMap = new LinkedHashMap(this.variables.size());
                for (int i = 0; i < this.variables.size(); ++i) {
                    variableMap.put(this.variables.get(i), Paths.urlDecode(matcher.group(i + 2)));
                }
            }
        }
        String remaining = UriTemplateParser.removeLeadingSlash(uri.substring(matcher.end(1)));
        return new UriRouteMatch(matcher.group(1), remaining, variableMap, this.mode);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.mode == RoutingMode.EQUALS) {
            builder.append("equals(");
        } else {
            builder.append("startsWith(");
        }
        builder.append(this.uriTemplate);
        builder.append(')');
        return builder.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UriRouteMatcher)) {
            return false;
        }
        UriRouteMatcher that = (UriRouteMatcher)o;
        if (this.mode != that.mode) {
            return false;
        }
        if (!this.regex.toString().equals(that.regex.toString())) {
            return false;
        }
        if (!this.uriTemplate.equals(that.uriTemplate)) {
            return false;
        }
        return this.variables.equals(that.variables);
    }

    @Override
    public int hashCode() {
        int result = this.mode.hashCode();
        result = 31 * result + this.regex.toString().hashCode();
        result = 31 * result + this.uriTemplate.hashCode();
        result = 31 * result + this.variables.hashCode();
        return result;
    }

    private static final class UriRouteMatch
    implements RouteMatch {
        private final String matched;
        private final String remaining;
        private final Map<String, String> variableMap;
        private final RoutingMode mode;

        private UriRouteMatch(String matched, String remaining, Map<String, String> variableMap, RoutingMode mode) {
            this.matched = matched;
            this.remaining = remaining;
            this.variableMap = variableMap;
            this.mode = mode;
        }

        @Override
        public boolean isBetterMatchThan(RouteMatch routeMatch) throws IncomparableRouteMatchException {
            if (routeMatch == null) {
                return true;
            }
            if (!(routeMatch instanceof UriRouteMatch)) {
                throw new IncomparableRouteMatchException(this, routeMatch);
            }
            UriRouteMatch result = (UriRouteMatch)routeMatch;
            if (!this.matched.equals(result.matched)) {
                return this.matched.length() > result.matched.length();
            }
            if (this.mode != result.mode) {
                return this.mode == RoutingMode.EQUALS;
            }
            return this.variableMap.size() < result.variableMap.size();
        }

        @Override
        public Context decorateContext(Context context) {
            return new UriRouterContext(context, this.matched, this.remaining, this.variableMap);
        }
    }

    private static final class UriTemplateParser {
        private UriTemplateParser() {
        }

        static Pattern createRegex(RoutingMode mode, String uriTemplate, List<String> variables) {
            String t = UriTemplateParser.removeTrailingSlash(UriTemplateParser.removeLeadingSlash(uriTemplate));
            StringBuilder builder = new StringBuilder(t.length() + 8);
            boolean isInVariable = false;
            int elementStart = 0;
            builder.append('(');
            for (int i = 0; i < t.length(); ++i) {
                char c = t.charAt(i);
                if (isInVariable) {
                    if (c == '}') {
                        if (elementStart == i) {
                            throw new IllegalArgumentException("URI template " + t + " contains zero-length template variable");
                        }
                        variables.add(t.substring(elementStart, i));
                        builder.append("([^/]+)");
                        isInVariable = false;
                        elementStart = i + 1;
                        continue;
                    }
                    if (UriTemplateParser.isValidVariableCharacter(c)) continue;
                    throw new IllegalArgumentException("URI template " + t + " contains an illegal character " + c + " in a template variable");
                }
                if (c != '{') continue;
                builder.append(Pattern.quote(t.substring(elementStart, i)));
                isInVariable = true;
                elementStart = i + 1;
            }
            if (isInVariable) {
                throw new IllegalArgumentException("URI template " + t + " contains a trailing unclosed variable");
            }
            builder.append(Pattern.quote(t.substring(elementStart)));
            builder.append(')');
            if (mode == RoutingMode.STARTS_WITH) {
                if (uriTemplate.isEmpty()) {
                    builder.append("((.*))?");
                } else {
                    builder.append("(/(.*))?");
                }
            }
            return Pattern.compile(builder.toString());
        }

        static String removeLeadingSlash(String resourceName) {
            if (resourceName.startsWith("/")) {
                return resourceName.substring(1);
            }
            return resourceName;
        }

        private static String removeTrailingSlash(String resourceName) {
            if (resourceName.endsWith("/")) {
                return resourceName.substring(0, resourceName.length() - 1);
            }
            return resourceName;
        }

        private static boolean isValidVariableCharacter(char c) {
            return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_';
        }
    }
}

