/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.protocol;

import java.io.IOException;
import org.forgerock.http.io.BranchingInputStream;
import org.forgerock.http.protocol.Entity;
import org.forgerock.http.protocol.Headers;
import org.forgerock.http.protocol.Message;

public abstract class MessageImpl<T extends MessageImpl<T>>
implements Message {
    private final Entity entity;
    private final Headers headers;
    private String version = "HTTP/1.1";

    MessageImpl() {
        this.entity = new Entity(this);
        this.headers = new Headers();
    }

    MessageImpl(MessageImpl<T> message) throws IOException {
        this.headers = new Headers(message.headers);
        this.entity = new Entity(this, message.entity);
        this.setVersion0(message.version);
    }

    @Override
    public void close() {
        this.entity.close();
    }

    @Override
    public final Entity getEntity() {
        return this.entity;
    }

    @Override
    public final Headers getHeaders() {
        return this.headers;
    }

    @Override
    public final String getVersion() {
        return this.version;
    }

    final void setEntity0(Object o) {
        if (o instanceof BranchingInputStream) {
            this.entity.setRawContentInputStream((BranchingInputStream)o);
        } else if (o instanceof byte[]) {
            this.entity.setBytes((byte[])o);
        } else if (o instanceof String) {
            this.entity.setString((String)o);
        } else {
            this.entity.setJson(o);
        }
    }

    final void setVersion0(String version) {
        this.version = version;
    }
}

