/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.header;

import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forgerock.http.header.AbstractSingleValuedHeaderFactory;
import org.forgerock.http.header.HeaderUtil;
import org.forgerock.http.protocol.Header;
import org.forgerock.http.protocol.Message;
import org.forgerock.http.routing.Version;
import org.forgerock.util.Pair;

public final class AcceptApiVersionHeader
extends Header {
    public static final String NAME = "Accept-API-Version";
    private static final String PROTOCOL = "protocol";
    private static final String RESOURCE = "resource";
    private static final String EQUALS = "=";
    private static final String PROTOCOL_VERSION_REGEX = "protocol=(\\d+(\\.\\d+)?)";
    private static final String RESOURCE_VERSION_REGEX = "resource=(\\d+(\\.\\d+)?)";
    private static final Pattern EXPECTED_VERSION_FORMAT = Pattern.compile("^protocol=(\\d+(\\.\\d+)?)$|^resource=(\\d+(\\.\\d+)?)$|^protocol=(\\d+(\\.\\d+)?)\\s*,\\s*resource=(\\d+(\\.\\d+)?)$|^resource=(\\d+(\\.\\d+)?)\\s*,\\s*protocol=(\\d+(\\.\\d+)?)$");
    private Version protocolVersion;
    private Version resourceVersion;

    public static AcceptApiVersionHeader valueOf(Message message) {
        return AcceptApiVersionHeader.valueOf(HeaderUtil.parseSingleValuedHeader(message, NAME));
    }

    public static AcceptApiVersionHeader valueOf(String string) {
        Pair<Version, Version> parsedValue = AcceptApiVersionHeader.parse(string);
        return new AcceptApiVersionHeader((Version)parsedValue.getFirst(), (Version)parsedValue.getSecond());
    }

    static Pair<Version, Version> parse(String string) {
        if (string == null || string.isEmpty()) {
            return Pair.empty();
        }
        Matcher matcher = EXPECTED_VERSION_FORMAT.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Version string is in an invalid format: " + string);
        }
        Version protocolVersion = null;
        Version resourceVersion = null;
        if (matcher.group(1) != null) {
            protocolVersion = Version.version(matcher.group(1));
        } else if (matcher.group(3) != null) {
            resourceVersion = Version.version(matcher.group(3));
        } else if (matcher.group(5) != null) {
            protocolVersion = Version.version(matcher.group(5));
            resourceVersion = Version.version(matcher.group(7));
        } else {
            resourceVersion = Version.version(matcher.group(9));
            protocolVersion = Version.version(matcher.group(11));
        }
        return Pair.of((Object)protocolVersion, resourceVersion);
    }

    public AcceptApiVersionHeader(Version protocol, Version resource) {
        this.protocolVersion = protocol;
        this.resourceVersion = resource;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public Version getProtocolVersion() {
        return this.protocolVersion;
    }

    public Version getResourceVersion() {
        return this.resourceVersion;
    }

    public AcceptApiVersionHeader withDefaultProtocolVersion(Version version) {
        if (this.protocolVersion == null && version != null) {
            this.protocolVersion = version;
        }
        return this;
    }

    public AcceptApiVersionHeader withDefaultResourceVersion(Version version) {
        if (this.resourceVersion == null && version != null) {
            this.resourceVersion = version;
        }
        return this;
    }

    @Override
    public List<String> getValues() {
        StringBuilder sb = new StringBuilder();
        if (this.protocolVersion != null) {
            sb.append(PROTOCOL).append(EQUALS).append(this.protocolVersion.toString());
        }
        if (this.protocolVersion != null && this.resourceVersion != null) {
            sb.append(",");
        }
        if (this.resourceVersion != null) {
            sb.append(RESOURCE).append(EQUALS).append(this.resourceVersion.toString());
        }
        return Collections.singletonList(sb.toString());
    }

    static class Factory
    extends AbstractSingleValuedHeaderFactory<AcceptApiVersionHeader> {
        Factory() {
        }

        @Override
        public AcceptApiVersionHeader parse(String value) {
            return AcceptApiVersionHeader.valueOf(value);
        }
    }
}

