/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.handler;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import org.forgerock.http.Handler;
import org.forgerock.http.HttpApplicationException;
import org.forgerock.http.io.Buffer;
import org.forgerock.http.io.IO;
import org.forgerock.http.protocol.Request;
import org.forgerock.http.protocol.Response;
import org.forgerock.http.spi.HttpClient;
import org.forgerock.http.spi.HttpClientProvider;
import org.forgerock.http.spi.Loader;
import org.forgerock.services.context.Context;
import org.forgerock.util.Factory;
import org.forgerock.util.Option;
import org.forgerock.util.Options;
import org.forgerock.util.Reject;
import org.forgerock.util.promise.NeverThrowsException;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.time.Duration;

public final class HttpClientHandler
implements Handler,
Closeable {
    public static final Option<Duration> OPTION_CONNECT_TIMEOUT = Option.withDefault((Object)Duration.duration((String)"10 seconds"));
    public static final Option<Duration> OPTION_SO_TIMEOUT = Option.withDefault((Object)Duration.duration((String)"10 seconds"));
    public static final Option<Boolean> OPTION_REUSE_CONNECTIONS = Option.withDefault((Object)true);
    public static final Option<Boolean> OPTION_RETRY_REQUESTS = Option.withDefault((Object)true);
    public static final Option<KeyManager[]> OPTION_KEY_MANAGERS = Option.of(KeyManager[].class, null);
    public static final Option<Loader> OPTION_LOADER = Option.of(Loader.class, (Object)Loader.SERVICE_LOADER);
    public static final Option<Integer> OPTION_MAX_CONNECTIONS = Option.withDefault((Object)64);
    public static final Option<Factory<Buffer>> OPTION_TEMPORARY_STORAGE = Option.of(Factory.class, IO.newTemporaryStorage());
    public static final Option<TrustManager[]> OPTION_TRUST_MANAGERS = Option.of(TrustManager[].class, null);
    private final HttpClient httpClient;
    public static final Option<HostnameVerifier> OPTION_HOSTNAME_VERIFIER = Option.of(HostnameVerifier.class, (Object)((Object)HostnameVerifier.ALLOW_ALL));
    public static final Option<String> OPTION_SSLCONTEXT_ALGORITHM = Option.withDefault((Object)"TLS");
    public static final Option<List<String>> OPTION_SSL_ENABLED_PROTOCOLS = Option.of(List.class, Collections.emptyList());
    public static final Option<List<String>> OPTION_SSL_CIPHER_SUITES = Option.of(List.class, Collections.emptyList());

    public HttpClientHandler() throws HttpApplicationException {
        this(Options.unmodifiableDefaultOptions());
    }

    public HttpClientHandler(Options options) throws HttpApplicationException {
        Reject.ifNull((Object)options);
        Loader loader = (Loader)options.get(OPTION_LOADER);
        HttpClientProvider factory = loader.load(HttpClientProvider.class, options);
        if (factory == null) {
            throw new HttpApplicationException("No HTTP client provider found");
        }
        this.httpClient = factory.newHttpClient(options);
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }

    @Override
    public Promise<Response, NeverThrowsException> handle(Context context, Request request) {
        return this.httpClient.sendAsync(request);
    }

    public static enum HostnameVerifier {
        ALLOW_ALL,
        STRICT;

    }
}

