/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.crypto.simple;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.forgerock.json.JsonValue;
import org.forgerock.json.JsonValueException;
import org.forgerock.json.crypto.JsonCryptoException;
import org.forgerock.json.crypto.JsonDecryptor;
import org.forgerock.json.crypto.simple.HKDFKeyGenerator;
import org.forgerock.json.crypto.simple.SimpleEncryptor;
import org.forgerock.json.crypto.simple.SimpleKeySelector;
import org.forgerock.util.encode.Base64;

public class SimpleDecryptor
implements JsonDecryptor {
    private static final Logger logger = Logger.getLogger(SimpleDecryptor.class.getName());
    public static final String TYPE = "x-simple-encryption";
    private final ObjectMapper mapper = new ObjectMapper();
    private final SimpleKeySelector selector;

    public SimpleDecryptor(SimpleKeySelector selector) {
        this.selector = selector;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    private Key select(String alias) throws JsonCryptoException {
        Key result = this.selector.select(alias);
        if (result == null) {
            throw new JsonCryptoException("key not found: " + alias);
        }
        return result;
    }

    @Override
    public JsonValue decrypt(JsonValue value) throws JsonCryptoException {
        try {
            Key symmetricKey;
            JsonValue key = value.get("key").required();
            String cipher = value.get("cipher").required().asString();
            if (key.isString()) {
                symmetricKey = this.select(key.asString());
            } else {
                Key privateKey = this.select(key.get("key").required().asString());
                Cipher asymmetric = Cipher.getInstance(key.get("cipher").required().asString());
                asymmetric.init(2, privateKey);
                byte[] ciphertext = Base64.decode((String)key.get("data").required().asString());
                symmetricKey = new SecretKeySpec(asymmetric.doFinal(ciphertext), cipher.split("/", 2)[0]);
            }
            if (value.isDefined("salt")) {
                byte[] macTag = Base64.decode((String)value.get("mac").required().asString());
                HKDFKeyGenerator.HKDFMasterKey masterKey = HKDFKeyGenerator.extractMasterKey(symmetricKey.getEncoded(), Base64.decode((String)value.get("salt").required().asString()));
                Key macKey = HKDFKeyGenerator.expandKey(masterKey, "HmacSHA256", 32);
                TreeMap<String, Object> map = new TreeMap<String, Object>(value.asMap());
                map.remove("mac");
                byte[] computedMacTag = SimpleEncryptor.mac(map, macKey);
                if (!MessageDigest.isEqual(macTag, computedMacTag)) {
                    throw new GeneralSecurityException("Invalid tag");
                }
                symmetricKey = HKDFKeyGenerator.expandKey(masterKey, symmetricKey.getAlgorithm(), 16);
            }
            Cipher symmetric = Cipher.getInstance(cipher);
            String iv = value.get("iv").asString();
            IvParameterSpec ivps = iv == null ? null : new IvParameterSpec(Base64.decode((String)iv));
            symmetric.init(2, symmetricKey, ivps);
            byte[] plaintext = symmetric.doFinal(Base64.decode((String)value.get("data").required().asString()));
            return new JsonValue(this.mapper.readValue(plaintext, Object.class));
        }
        catch (IOException | GeneralSecurityException | JsonValueException e) {
            logger.log(Level.FINE, "SimpleDecryptor: decryption failure", e);
            throw new JsonCryptoException("Decryption failed");
        }
    }
}

