/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.crypto;

import org.forgerock.json.JsonValue;
import org.forgerock.json.JsonValueException;
import org.forgerock.json.JsonValueFunctions;
import org.forgerock.json.JsonValueTraverseFunction;
import org.forgerock.json.crypto.JsonCrypto;
import org.forgerock.json.crypto.JsonCryptoException;
import org.forgerock.json.crypto.JsonDecryptor;
import org.forgerock.util.Reject;

public class JsonDecryptFunction
extends JsonValueTraverseFunction {
    private final JsonDecryptor decryptor;

    public JsonDecryptFunction(JsonDecryptor decryptor) {
        super(JsonValueFunctions.identity());
        this.decryptor = (JsonDecryptor)Reject.checkNotNull((Object)decryptor);
    }

    protected Object traverseMap(JsonValue value) {
        JsonCrypto crypto;
        if (JsonCrypto.isJsonCrypto(value) && (crypto = new JsonCrypto(value)).getType().equals(this.decryptor.getType())) {
            try {
                JsonValue decrypted = this.decryptor.decrypt(crypto.getValue());
                return this.apply(decrypted);
            }
            catch (JsonCryptoException jce) {
                throw new JsonValueException(value, (Throwable)jce);
            }
        }
        return super.traverseMap(value);
    }
}

