/*
 * Decompiled with CFR 0.152.
 */
package org.eu.ingwar.tools.arquillian.extension.suite;

import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eu.ingwar.tools.arquillian.extension.suite.DeploymentClassFinder;
import org.eu.ingwar.tools.arquillian.extension.suite.ExtendedSuiteContext;
import org.eu.ingwar.tools.arquillian.extension.suite.annotations.ExtendedSuiteScoped;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.container.spi.client.deployment.DeploymentScenario;
import org.jboss.arquillian.container.spi.event.DeployManagedDeployments;
import org.jboss.arquillian.container.spi.event.UnDeployManagedDeployments;
import org.jboss.arquillian.container.spi.event.container.BeforeStop;
import org.jboss.arquillian.container.test.impl.client.deployment.event.GenerateDeployment;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.EventContext;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.arquillian.test.spi.annotation.ClassScoped;
import org.jboss.arquillian.test.spi.context.ClassContext;
import org.jboss.arquillian.test.spi.event.suite.BeforeSuite;

public class SuiteDeployer {
    private static final Logger log = Logger.getLogger(SuiteDeployer.class.getName());
    @Inject
    private Instance<ClassContext> classContext;
    @Inject
    @ClassScoped
    private InstanceProducer<DeploymentScenario> classDeploymentScenario;
    @Inject
    private Event<UnDeployManagedDeployments> undeployEvent;
    @Inject
    private Event<GenerateDeployment> generateDeploymentEvent;
    @Inject
    private Instance<ExtendedSuiteContext> extendedSuiteContext;
    private DeploymentScenario suiteDeploymentScenario;
    @ExtendedSuiteScoped
    @Inject
    private InstanceProducer<DeploymentScenario> suiteDeploymentScenarioInstanceProducer;
    private boolean suiteDeploymentGenerated;
    private boolean deployDeployments;
    private boolean undeployDeployments;
    static Class<?> deploymentClass;

    public static void configure(@Observes ArquillianDescriptor descriptor) {
        deploymentClass = DeploymentClassFinder.getDeploymentClass(descriptor);
    }

    public void blockDeployManagedDeploymentsWhenNeeded(@Observes EventContext<DeployManagedDeployments> eventContext) {
        if (!this.extensionEnabled()) {
            eventContext.proceed();
        } else if (this.deployDeployments) {
            this.deployDeployments = false;
            this.debug("NOT Blocking DeployManagedDeployments event {0}", ((DeployManagedDeployments)eventContext.getEvent()).toString());
            eventContext.proceed();
        } else {
            this.debug("Blocking DeployManagedDeployments event {0}", ((DeployManagedDeployments)eventContext.getEvent()).toString());
        }
    }

    public void blockGenerateDeploymentWhenNeeded(@Observes EventContext<GenerateDeployment> eventContext) {
        if (!this.extensionEnabled()) {
            eventContext.proceed();
        } else if (this.suiteDeploymentGenerated) {
            this.debug("Blocking GenerateDeployment event {0}", ((GenerateDeployment)eventContext.getEvent()).toString());
        } else {
            this.suiteDeploymentGenerated = true;
            this.debug("NOT Blocking GenerateDeployment event {0}", ((GenerateDeployment)eventContext.getEvent()).toString());
            eventContext.proceed();
        }
    }

    public void blockUnDeployManagedDeploymentsWhenNeeded(@Observes EventContext<UnDeployManagedDeployments> eventContext) {
        if (!this.extensionEnabled()) {
            eventContext.proceed();
        } else if (this.undeployDeployments) {
            this.undeployDeployments = false;
            this.debug("NOT Blocking UnDeployManagedDeployments event {0}", ((UnDeployManagedDeployments)eventContext.getEvent()).toString());
            eventContext.proceed();
        } else {
            this.debug("Blocking UnDeployManagedDeployments event {0}", ((UnDeployManagedDeployments)eventContext.getEvent()).toString());
        }
    }

    public void startup(@Observes(precedence=-100) BeforeSuite event) {
        if (this.extensionEnabled()) {
            this.debug("Catching BeforeSuite event {0}", event.toString());
            this.executeInClassScope(new Callable<Void>(){

                @Override
                public Void call() {
                    SuiteDeployer.this.generateDeploymentEvent.fire((Object)new GenerateDeployment(new TestClass(deploymentClass)));
                    SuiteDeployer.this.suiteDeploymentScenario = (DeploymentScenario)SuiteDeployer.this.classDeploymentScenario.get();
                    return null;
                }
            });
            this.deployDeployments = true;
            ((ExtendedSuiteContext)this.extendedSuiteContext.get()).activate();
            this.suiteDeploymentScenarioInstanceProducer.set((Object)this.suiteDeploymentScenario);
        }
    }

    public void undeploy(@Observes BeforeStop event) {
        if (this.extensionEnabled()) {
            this.debug("Catching BeforeStop event {0}", event.toString());
            this.undeployDeployments = true;
            this.undeployEvent.fire((Object)new UnDeployManagedDeployments());
        }
    }

    private void executeInClassScope(Callable<Void> call) {
        try {
            ((ClassContext)this.classContext.get()).activate(deploymentClass);
            call.call();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not invoke operation", e);
        }
        finally {
            ((ClassContext)this.classContext.get()).deactivate();
        }
    }

    private void debug(String format, Object ... message) {
        Boolean DEBUG = Boolean.valueOf(System.getProperty("arquillian.debug"));
        if (DEBUG.booleanValue()) {
            log.log(Level.WARNING, format, message);
        }
    }

    private boolean extensionEnabled() {
        return deploymentClass != null;
    }
}

