/*
 * Decompiled with CFR 0.152.
 */
package org.eu.ingwar.tools.arquillian.extension.suite;

import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.eu.ingwar.tools.arquillian.extension.suite.annotations.ArquillianSuiteDeployment;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.config.descriptor.api.ExtensionDef;
import org.reflections.Reflections;
import org.reflections.util.ClasspathHelper;

class DeploymentClassFinder {
    private static final Logger log = Logger.getLogger(DeploymentClassFinder.class.getName());

    DeploymentClassFinder() {
    }

    static Class<?> getDeploymentClass(ArquillianDescriptor descriptor) {
        Class<?> deploymentClass = DeploymentClassFinder.getDeploymentClassFromConfig(descriptor);
        if (deploymentClass == null) {
            deploymentClass = DeploymentClassFinder.getDeploymentClassFromAnnotation();
        }
        if (deploymentClass == null) {
            log.warning("arquillian-suite-deployment: Cannot find configuration in arquillian.xml, nor class annotated with @ArquillianSuiteDeployment, will try standard way..");
        }
        return deploymentClass;
    }

    private static Class<?> getDeploymentClassFromAnnotation() {
        Reflections reflections = new Reflections(new Object[]{ClasspathHelper.contextClassLoader().getResource("")});
        Set results = reflections.getTypesAnnotatedWith(ArquillianSuiteDeployment.class, true);
        if (results.isEmpty()) {
            return null;
        }
        if (results.size() > 1) {
            for (Class type : results) {
                log.log(Level.SEVERE, "arquillian-suite-deployment: Duplicated class annotated with @ArquillianSuiteDeployment: {0}", type.getName());
            }
            throw new IllegalStateException("Duplicated classes annotated with @ArquillianSuiteDeployment");
        }
        Class type = (Class)results.iterator().next();
        log.log(Level.INFO, "arquillian-suite-deployment: Found class annotated with @ArquillianSuiteDeployment: {0}", type.getName());
        return type;
    }

    private static Class<?> getDeploymentClassFromConfig(ArquillianDescriptor descriptor) {
        String deploymentClassName = DeploymentClassFinder.getDeploymentClassNameFromXml(descriptor);
        if (StringUtils.isNotEmpty((String)deploymentClassName)) {
            try {
                log.log(Level.INFO, "arquillian-suite-deployment: Using deployment class {0} from configuration.", deploymentClassName);
                return Class.forName(deploymentClassName);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Cannot load class " + deploymentClassName + " from configuration.");
            }
        }
        return null;
    }

    private static String getDeploymentClassNameFromXml(ArquillianDescriptor descriptor) {
        ExtensionDef extension = descriptor.extension("suite");
        if (extension != null) {
            return (String)extension.getExtensionProperties().get("deploymentClass");
        }
        return null;
    }
}

