/*
 * Decompiled with CFR 0.152.
 */
package org.eu.ingwar.tools.arquillian.extension.suite;

import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eu.ingwar.tools.arquillian.extension.suite.ExtendedSuiteContext;
import org.eu.ingwar.tools.arquillian.extension.suite.ExtendedSuiteContextImpl;
import org.eu.ingwar.tools.arquillian.extension.suite.annotations.ArquilianSuiteDeployment;
import org.eu.ingwar.tools.arquillian.extension.suite.annotations.ArquillianSuiteDeployment;
import org.eu.ingwar.tools.arquillian.extension.suite.annotations.ExtendedSuiteScoped;
import org.jboss.arquillian.container.spi.client.deployment.DeploymentScenario;
import org.jboss.arquillian.container.spi.event.DeployManagedDeployments;
import org.jboss.arquillian.container.spi.event.UnDeployManagedDeployments;
import org.jboss.arquillian.container.spi.event.container.AfterStart;
import org.jboss.arquillian.container.spi.event.container.BeforeStop;
import org.jboss.arquillian.container.test.impl.client.deployment.event.GenerateDeployment;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.impl.ManagerImpl;
import org.jboss.arquillian.core.spi.EventContext;
import org.jboss.arquillian.core.spi.LoadableExtension;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.arquillian.test.spi.annotation.ClassScoped;
import org.jboss.arquillian.test.spi.context.ClassContext;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class ArquillianSuiteExtension
implements LoadableExtension {
    private static final Logger log = Logger.getLogger(ArquillianSuiteExtension.class.getName());
    private static Class<?> deploymentClass;

    public void register(LoadableExtension.ExtensionBuilder builder) {
        deploymentClass = ArquillianSuiteExtension.getDeploymentClass();
        if (deploymentClass != null) {
            builder.observer(SuiteDeployer.class).context(ExtendedSuiteContextImpl.class);
        } else {
            log.log(Level.WARNING, "arquillian-suite-deployment: Cannot find class annotated with @ArquillianSuiteDeployment, will try normal way..");
        }
    }

    private static Class<?> getDeploymentClass() {
        Reflections reflections = new Reflections("", new Scanner[0]);
        Set results = reflections.getTypesAnnotatedWith(ArquillianSuiteDeployment.class, true);
        if (results.isEmpty() && (results = reflections.getTypesAnnotatedWith(ArquilianSuiteDeployment.class, true)).isEmpty()) {
            return null;
        }
        if (results.size() > 1) {
            for (Class type : results) {
                log.log(Level.SEVERE, "arquillian-suite-deployment: Duplicated class annotated with @ArquillianSuiteDeployment: {0}", type.getName());
            }
            throw new IllegalStateException("Duplicated classess annotated with @ArquillianSuiteDeployment");
        }
        return (Class)results.iterator().next();
    }

    public static class SuiteDeployer {
        @Inject
        private Instance<ClassContext> classContext;
        @Inject
        @ClassScoped
        private InstanceProducer<DeploymentScenario> classDeploymentScenario;
        @Inject
        private Event<UnDeployManagedDeployments> undeployEvent;
        @Inject
        private Event<GenerateDeployment> generateDeploymentEvent;
        @Inject
        private Instance<ExtendedSuiteContext> extendedSuiteContext;
        private DeploymentScenario suiteDeploymentScenario;
        @ExtendedSuiteScoped
        @Inject
        private InstanceProducer<DeploymentScenario> suiteDeploymentScenarioInstanceProducer;
        private boolean suiteDeploymentGenerated;
        private boolean deployDeployments;
        private boolean undeployDeployments;

        public void blockDeployManagedDeploymentsWhenNeeded(@Observes EventContext<DeployManagedDeployments> eventContext) {
            if (this.deployDeployments) {
                this.deployDeployments = false;
                this.debug("NOT Blocking DeployManagedDeployments event {}", ((DeployManagedDeployments)eventContext.getEvent()).toString());
                eventContext.proceed();
            } else {
                this.debug("Blocking DeployManagedDeployments event {}", ((DeployManagedDeployments)eventContext.getEvent()).toString());
            }
        }

        public void blockGenerateDeploymentWhenNeeded(@Observes EventContext<GenerateDeployment> eventContext) {
            if (this.suiteDeploymentGenerated) {
                this.debug("Blocking GenerateDeployment event {}", ((GenerateDeployment)eventContext.getEvent()).toString());
            } else {
                this.suiteDeploymentGenerated = true;
                this.debug("NOT Blocking GenerateDeployment event {}", ((GenerateDeployment)eventContext.getEvent()).toString());
                eventContext.proceed();
            }
        }

        public void blockUnDeployManagedDeploymentsWhenNeeded(@Observes EventContext<UnDeployManagedDeployments> eventContext) {
            if (this.undeployDeployments) {
                this.undeployDeployments = false;
                this.debug("NOT Blocking UnDeployManagedDeployments event {}", ((UnDeployManagedDeployments)eventContext.getEvent()).toString());
                eventContext.proceed();
            } else {
                this.debug("Blocking UnDeployManagedDeployments event {}", ((UnDeployManagedDeployments)eventContext.getEvent()).toString());
            }
        }

        public void startup(@Observes(precedence=-100) AfterStart event) {
            this.debug("Catching AfterStart event {0}", event.toString());
            this.executeInClassScope(new Callable<Void>(){

                @Override
                public Void call() {
                    SuiteDeployer.this.generateDeploymentEvent.fire((Object)new GenerateDeployment(new TestClass(deploymentClass)));
                    SuiteDeployer.this.suiteDeploymentScenario = (DeploymentScenario)SuiteDeployer.this.classDeploymentScenario.get();
                    return null;
                }
            });
            this.deployDeployments = true;
            ((ExtendedSuiteContext)this.extendedSuiteContext.get()).activate();
            this.suiteDeploymentScenarioInstanceProducer.set((Object)this.suiteDeploymentScenario);
        }

        public void undeploy(@Observes BeforeStop event) {
            this.debug("Catching BeforeStop event {0}", event.toString());
            this.undeployDeployments = true;
            this.undeployEvent.fire((Object)new UnDeployManagedDeployments());
        }

        private void executeInClassScope(Callable<Void> call) {
            try {
                ((ClassContext)this.classContext.get()).activate((Object)deploymentClass);
                call.call();
            }
            catch (Exception e) {
                throw new RuntimeException("Could not invoke operation", e);
            }
            finally {
                ((ClassContext)this.classContext.get()).deactivate();
            }
        }

        private void debug(String format, Object ... message) {
            if (ManagerImpl.DEBUG.booleanValue()) {
                log.log(Level.WARNING, format, message);
            }
        }
    }
}

