/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.error;

import org.fest.assertions.error.BasicErrorMessageFactory;
import org.fest.assertions.error.ErrorMessageFactory;
import org.fest.assertions.internal.ComparisonStrategy;
import org.fest.assertions.internal.StandardComparisonStrategy;

public class ShouldContainStringOnlyOnce
extends BasicErrorMessageFactory {
    public static ErrorMessageFactory shouldContainOnlyOnce(String actual, String sequence, int occurences, ComparisonStrategy comparisonStrategy) {
        if (occurences == 0) {
            return new ShouldContainStringOnlyOnce(actual, sequence, comparisonStrategy);
        }
        return new ShouldContainStringOnlyOnce(actual, sequence, occurences, comparisonStrategy);
    }

    public static ErrorMessageFactory shouldContainOnlyOnce(String actual, String sequence, int occurences) {
        if (occurences == 0) {
            return new ShouldContainStringOnlyOnce(actual, sequence, StandardComparisonStrategy.instance());
        }
        return new ShouldContainStringOnlyOnce(actual, sequence, occurences, StandardComparisonStrategy.instance());
    }

    private ShouldContainStringOnlyOnce(String actual, String expected, int occurences, ComparisonStrategy comparisonStrategy) {
        super("expecting:\n<%s>\n to appear only once in:\n<%s>\n but it appeared %s times%s.", expected, actual, occurences, comparisonStrategy);
    }

    private ShouldContainStringOnlyOnce(String actual, String expected, ComparisonStrategy comparisonStrategy) {
        super("expecting:\n<%s>\n to appear only once in:\n<%s>\n but it did not appear%s.", expected, actual, comparisonStrategy);
    }
}

