/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.internal;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.fest.assertions.core.AssertionInfo;
import org.fest.assertions.core.Condition;
import org.fest.assertions.data.Index;
import org.fest.assertions.error.ShouldBeAtIndex;
import org.fest.assertions.error.ShouldBeSorted;
import org.fest.assertions.error.ShouldContainAtIndex;
import org.fest.assertions.error.ShouldHaveAtIndex;
import org.fest.assertions.error.ShouldNotContainAtIndex;
import org.fest.assertions.internal.CommonValidations;
import org.fest.assertions.internal.ComparatorBasedComparisonStrategy;
import org.fest.assertions.internal.ComparisonStrategy;
import org.fest.assertions.internal.Conditions;
import org.fest.assertions.internal.Failures;
import org.fest.assertions.internal.Iterables;
import org.fest.assertions.internal.Objects;
import org.fest.assertions.internal.StandardComparisonStrategy;
import org.fest.util.VisibleForTesting;

public class Lists {
    private static final Lists INSTANCE = new Lists();
    private ComparisonStrategy comparisonStrategy;
    @VisibleForTesting
    Failures failures = Failures.instance();

    public static Lists instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    Lists() {
        this(StandardComparisonStrategy.instance());
    }

    public Lists(ComparisonStrategy comparisonStrategy) {
        this.comparisonStrategy = comparisonStrategy;
    }

    @VisibleForTesting
    public Comparator<?> getComparator() {
        if (this.comparisonStrategy instanceof ComparatorBasedComparisonStrategy) {
            return ((ComparatorBasedComparisonStrategy)this.comparisonStrategy).getComparator();
        }
        return null;
    }

    public void assertContains(AssertionInfo info, List<?> actual, Object value, Index index) {
        this.assertNotNull(info, actual);
        Iterables.instance().assertNotEmpty(info, actual);
        CommonValidations.checkIndexValueIsValid(index, actual.size() - 1);
        Object actualElement = actual.get(index.value);
        if (this.areEqual(actualElement, value)) {
            return;
        }
        throw this.failures.failure(info, ShouldContainAtIndex.shouldContainAtIndex(actual, value, index, actual.get(index.value), this.comparisonStrategy));
    }

    public void assertDoesNotContain(AssertionInfo info, List<?> actual, Object value, Index index) {
        this.assertNotNull(info, actual);
        CommonValidations.checkIndexValueIsValid(index, Integer.MAX_VALUE);
        int indexValue = index.value;
        if (indexValue >= actual.size()) {
            return;
        }
        Object actualElement = actual.get(index.value);
        if (!this.areEqual(actualElement, value)) {
            return;
        }
        throw this.failures.failure(info, ShouldNotContainAtIndex.shouldNotContainAtIndex(actual, value, index, this.comparisonStrategy));
    }

    public void assertIsSorted(AssertionInfo info, List<?> actual) {
        this.assertNotNull(info, actual);
        if (this.comparisonStrategy instanceof ComparatorBasedComparisonStrategy) {
            Comparator<?> comparator = ((ComparatorBasedComparisonStrategy)this.comparisonStrategy).getComparator();
            this.assertIsSortedAccordingToComparator(info, actual, comparator);
            return;
        }
        try {
            List<Comparable<Object>> comparableList = Lists.listOfComparableElements(actual);
            if (comparableList.size() <= 1) {
                return;
            }
            for (int i = 0; i < comparableList.size() - 1; ++i) {
                if (comparableList.get(i).compareTo(comparableList.get(i + 1)) <= 0) continue;
                throw this.failures.failure(info, ShouldBeSorted.shouldBeSorted(i, actual));
            }
        }
        catch (ClassCastException e) {
            throw this.failures.failure(info, ShouldBeSorted.shouldHaveMutuallyComparableElements(actual));
        }
    }

    public void assertIsSortedAccordingToComparator(AssertionInfo info, List<?> actual, Comparator<? extends Object> comparator) {
        this.assertNotNull(info, actual);
        if (comparator == null) {
            throw new NullPointerException("The given comparator should not be null");
        }
        try {
            if (actual.size() == 0) {
                return;
            }
            Comparator<? extends Object> rawComparator = comparator;
            if (actual.size() == 1) {
                rawComparator.compare(actual.get(0), actual.get(0));
                return;
            }
            for (int i = 0; i < actual.size() - 1; ++i) {
                if (rawComparator.compare(actual.get(i), actual.get(i + 1)) <= 0) continue;
                throw this.failures.failure(info, ShouldBeSorted.shouldBeSortedAccordingToGivenComparator(i, actual, comparator));
            }
        }
        catch (ClassCastException e) {
            throw this.failures.failure(info, ShouldBeSorted.shouldHaveComparableElementsAccordingToGivenComparator(actual, comparator));
        }
    }

    public <T> void assertHas(AssertionInfo info, List<T> actual, Condition<? super T> condition, Index index) {
        this.assertNotNull(info, actual);
        this.assertNotNull(condition);
        Iterables.instance().assertNotEmpty(info, actual);
        CommonValidations.checkIndexValueIsValid(index, actual.size() - 1);
        int indexValue = index.value;
        if (indexValue >= actual.size()) {
            return;
        }
        T actualElement = actual.get(index.value);
        if (condition.matches(actualElement)) {
            return;
        }
        throw this.failures.failure(info, ShouldHaveAtIndex.shouldHaveAtIndex(actual, condition, index, actualElement));
    }

    public <T> void assertIs(AssertionInfo info, List<T> actual, Condition<? super T> condition, Index index) {
        this.assertNotNull(info, actual);
        this.assertNotNull(condition);
        Iterables.instance().assertNotEmpty(info, actual);
        CommonValidations.checkIndexValueIsValid(index, actual.size() - 1);
        int indexValue = index.value;
        if (indexValue >= actual.size()) {
            return;
        }
        T actualElement = actual.get(index.value);
        if (condition.matches(actualElement)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeAtIndex.shouldBeAtIndex(actual, condition, index, actualElement));
    }

    private static List<Comparable<Object>> listOfComparableElements(List<?> collection) {
        ArrayList<Comparable<Object>> listOfComparableElements = new ArrayList<Comparable<Object>>();
        for (Object object : collection) {
            listOfComparableElements.add((Comparable)object);
        }
        return listOfComparableElements;
    }

    private void assertNotNull(AssertionInfo info, List<?> actual) {
        Objects.instance().assertNotNull(info, actual);
    }

    private void assertNotNull(Condition<?> condition) {
        Conditions.instance().assertIsNotNull(condition);
    }

    private boolean areEqual(Object actual, Object other) {
        return this.comparisonStrategy.areEqual(actual, other);
    }
}

