/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.spi.startup;

import java.net.URL;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.internal.util.HttpUtils;
import org.codehaus.cargo.container.spi.startup.AbstractContainerMonitor;

public abstract class AbstractPingContainerMonitor
extends AbstractContainerMonitor {
    private HttpUtils httpUtils = new HttpUtils();

    public AbstractPingContainerMonitor(Container container) {
        super(container);
        this.httpUtils.setLogger(container.getLogger());
    }

    @Override
    public boolean isRunning() {
        URL pingUrl = this.getPingUrl();
        return this.httpUtils.ping(pingUrl);
    }

    protected abstract URL getPingUrl();

    protected int getPortWithOffset(String portProperty) {
        String portOffset = this.getConfiguration().getPropertyValue("cargo.port.offset");
        boolean portOffsetApplicable = portOffset != null && !portOffset.equals("0");
        boolean portOffsetApplied = this.getConfiguration().isOffsetApplied();
        boolean applyPortOffset = portOffsetApplicable && !portOffsetApplied;
        int portValue = Integer.parseInt(this.getConfiguration().getPropertyValue(portProperty));
        if (applyPortOffset) {
            int portOffsetValue = Integer.parseInt(portOffset);
            portValue += portOffsetValue;
        }
        return portValue;
    }
}

