/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.property;

import java.util.Map;
import java.util.Properties;
import org.codehaus.cargo.container.configuration.entry.DataSource;
import org.codehaus.cargo.container.configuration.entry.Resource;
import org.codehaus.cargo.container.internal.util.PropertyUtils;
import org.codehaus.cargo.container.property.TransactionSupport;

public class DataSourceConverter {
    public DataSource fromPropertyString(String datasourceInformation) {
        return this.fromProperties(PropertyUtils.splitPropertiesOnPipe(PropertyUtils.escapeBackSlashesIfNotNull(datasourceInformation)));
    }

    public DataSource fromProperties(Properties properties) {
        String jndiLocation = properties.getProperty("cargo.datasource.jndi");
        String connectionType = properties.getProperty("cargo.datasource.type");
        TransactionSupport transactionSupport = TransactionSupport.valueOf(properties.getProperty("cargo.datasource.transactionsupport"));
        String driverClass = properties.getProperty("cargo.datasource.driver");
        String url = properties.getProperty("cargo.datasource.url");
        String username = properties.getProperty("cargo.datasource.username");
        String password = properties.getProperty("cargo.datasource.password");
        String id = properties.getProperty("cargo.datasource.id");
        String driverPropertiesAsASemicolonDelimitedString = properties.getProperty("cargo.datasource.properties");
        Properties connectionProperties = this.getDriverPropertiesFromString(driverPropertiesAsASemicolonDelimitedString);
        DataSource data = new DataSource(jndiLocation, connectionType, transactionSupport, driverClass, url, username, password, id, connectionProperties);
        return data;
    }

    private Properties getDriverPropertiesFromString(String property) {
        if (property != null && !property.trim().equals("")) {
            return PropertyUtils.splitPropertiesOnSemicolon(property);
        }
        return new Properties();
    }

    public String toPropertyString(DataSource data) {
        Properties properties = this.toProperties(data);
        return PropertyUtils.joinOnPipe(PropertyUtils.toMap(properties));
    }

    public Properties toProperties(DataSource data) {
        Properties properties = new Properties();
        PropertyUtils.setPropertyIfNotNull(properties, "cargo.datasource.jndi", data.getJndiLocation());
        PropertyUtils.setPropertyIfNotNull(properties, "cargo.datasource.type", data.getConnectionType());
        PropertyUtils.setPropertyIfNotNull(properties, "cargo.datasource.transactionsupport", data.getTransactionSupport());
        PropertyUtils.setPropertyIfNotNull(properties, "cargo.datasource.driver", data.getDriverClass());
        PropertyUtils.setPropertyIfNotNull(properties, "cargo.datasource.url", data.getUrl());
        PropertyUtils.setPropertyIfNotNull(properties, "cargo.datasource.username", data.getUsername());
        PropertyUtils.setPropertyIfNotNull(properties, "cargo.datasource.password", data.getPassword());
        PropertyUtils.setPropertyIfNotNull(properties, "cargo.datasource.id", data.getId());
        PropertyUtils.setPropertyIfNotNull(properties, "cargo.datasource.properties", this.getConnectionPropertiesAsASemicolonDelimitedString(data));
        return properties;
    }

    public String getConnectionPropertiesAsASemicolonDelimitedString(DataSource data) {
        if (data.getConnectionProperties() != null && data.getConnectionProperties().size() != 0) {
            return PropertyUtils.joinOnSemicolon(PropertyUtils.toMap(data.getConnectionProperties()));
        }
        return null;
    }

    public Resource convertToResource(DataSource ds, String resourceType, String driverParameter) {
        Properties parameters = new Properties();
        if (ds.getUrl() != null) {
            PropertyUtils.setPropertyIfNotNull(parameters, "url", ds.getUrl());
        }
        PropertyUtils.setPropertyIfNotNull(parameters, "user", ds.getUsername());
        PropertyUtils.setPropertyIfNotNull(parameters, "password", ds.getPassword());
        PropertyUtils.setPropertyIfNotNull(parameters, driverParameter, ds.getDriverClass());
        parameters.putAll((Map<?, ?>)ds.getConnectionProperties());
        Resource resource = new Resource(ds.getJndiLocation(), resourceType);
        resource.setParameters(PropertyUtils.toMap(parameters));
        return resource;
    }
}

