/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.deployer;

import java.net.MalformedURLException;
import java.net.URL;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.deployer.AbstractDeployableMonitor;
import org.codehaus.cargo.container.internal.util.HttpUtils;
import org.codehaus.cargo.util.CargoException;

public class UrlPathDeployableMonitor
extends AbstractDeployableMonitor {
    private Configuration configuration;
    private String pingUrlPath;
    private HttpUtils httpUtils = new HttpUtils();

    public UrlPathDeployableMonitor(Configuration configuration, String pingUrlPath) {
        this.configuration = configuration;
        this.pingUrlPath = pingUrlPath;
    }

    public UrlPathDeployableMonitor(Configuration configuration, String pingUrlPath, long timeout) {
        super(timeout);
        this.configuration = configuration;
        this.pingUrlPath = pingUrlPath;
    }

    @Override
    public String getDeployableName() {
        return this.pingUrlPath;
    }

    @Override
    public void monitor() {
        URL pingUrl = this.constructPingUrl();
        this.getLogger().debug("Checking URL [" + pingUrl + "] for status using a timeout of [" + this.getTimeout() + "] ms...", this.getClass().getName());
        HttpUtils.HttpResult results = new HttpUtils.HttpResult();
        boolean isDeployed = this.httpUtils.ping(pingUrl, results, this.getTimeout());
        String msg = "URL [" + pingUrl + "] is ";
        msg = isDeployed ? msg + "responding..." : msg + "not responding: " + results.responseCode + " " + results.responseMessage;
        this.getLogger().debug(msg, this.getClass().getName());
        this.notifyListeners(isDeployed);
    }

    private URL constructPingUrl() {
        URL deployableUrl = null;
        String protocolProperty = this.configuration.getPropertyValue("cargo.protocol");
        String hostnameProperty = this.configuration.getPropertyValue("cargo.hostname");
        String portProperty = this.configuration.getPropertyValue("cargo.servlet.port");
        String offsetProperty = this.configuration.getPropertyValue("cargo.port.offset");
        int port = Integer.parseInt(portProperty);
        if (offsetProperty != null) {
            int offset = Integer.parseInt(offsetProperty);
            port += offset;
        }
        try {
            deployableUrl = new URL(protocolProperty, hostnameProperty, port, this.pingUrlPath);
        }
        catch (MalformedURLException e) {
            throw new CargoException("Unable to construct deployable URL.", (Throwable)e);
        }
        return deployableUrl;
    }
}

