/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal.bytebuddy.implementation.bytecode.member;

import java.util.ArrayList;
import org.assertj.core.internal.bytebuddy.description.method.MethodDescription;
import org.assertj.core.internal.bytebuddy.description.method.ParameterDescription;
import org.assertj.core.internal.bytebuddy.description.type.TypeDefinition;
import org.assertj.core.internal.bytebuddy.description.type.TypeDescription;
import org.assertj.core.internal.bytebuddy.implementation.Implementation;
import org.assertj.core.internal.bytebuddy.implementation.bytecode.StackManipulation;
import org.assertj.core.internal.bytebuddy.implementation.bytecode.StackSize;
import org.assertj.core.internal.bytebuddy.implementation.bytecode.assign.TypeCasting;
import org.assertj.core.internal.bytebuddy.jar.asm.MethodVisitor;

public enum MethodVariableAccess {
    INTEGER(21, 54, StackSize.SINGLE),
    LONG(22, 55, StackSize.DOUBLE),
    FLOAT(23, 56, StackSize.SINGLE),
    DOUBLE(24, 57, StackSize.DOUBLE),
    REFERENCE(25, 58, StackSize.SINGLE);

    private final int loadOpcode;
    private final int storeOpcode;
    private final StackSize size;

    private MethodVariableAccess(int loadOpcode, int storeOpcode, StackSize stackSize) {
        this.loadOpcode = loadOpcode;
        this.size = stackSize;
        this.storeOpcode = storeOpcode;
    }

    public static MethodVariableAccess of(TypeDefinition typeDefinition) {
        if (typeDefinition.isPrimitive()) {
            if (typeDefinition.represents(Long.TYPE)) {
                return LONG;
            }
            if (typeDefinition.represents(Double.TYPE)) {
                return DOUBLE;
            }
            if (typeDefinition.represents(Float.TYPE)) {
                return FLOAT;
            }
            if (typeDefinition.represents(Void.TYPE)) {
                throw new IllegalArgumentException("Variable type cannot be void");
            }
            return INTEGER;
        }
        return REFERENCE;
    }

    public static MethodLoading allArgumentsOf(MethodDescription methodDescription) {
        return new MethodLoading(methodDescription, MethodLoading.TypeCastingHandler.NoOp.INSTANCE);
    }

    public static StackManipulation loadThis() {
        return REFERENCE.loadFrom(0);
    }

    public StackManipulation loadFrom(int offset) {
        return new OffsetLoading(offset);
    }

    public StackManipulation storeAt(int offset) {
        return new OffsetWriting(offset);
    }

    public StackManipulation increment(int offset, int value) {
        if (this != INTEGER) {
            throw new IllegalStateException("Cannot increment type: " + (Object)((Object)this));
        }
        return new OffsetIncrementing(offset, value);
    }

    public static StackManipulation load(ParameterDescription parameterDescription) {
        return MethodVariableAccess.of(parameterDescription.getType()).loadFrom(parameterDescription.getOffset());
    }

    public static StackManipulation store(ParameterDescription parameterDescription) {
        return MethodVariableAccess.of(parameterDescription.getType()).storeAt(parameterDescription.getOffset());
    }

    public static StackManipulation increment(ParameterDescription parameterDescription, int value) {
        return MethodVariableAccess.of(parameterDescription.getType()).increment(parameterDescription.getOffset(), value);
    }

    protected static class OffsetIncrementing
    implements StackManipulation {
        private final int offset;
        private final int value;

        protected OffsetIncrementing(int offset, int value) {
            this.offset = offset;
            this.value = value;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            methodVisitor.visitIincInsn(this.offset, this.value);
            return new StackManipulation.Size(0, 0);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OffsetIncrementing)) {
                return false;
            }
            OffsetIncrementing other = (OffsetIncrementing)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.offset != other.offset) {
                return false;
            }
            return this.value == other.value;
        }

        protected boolean canEqual(Object other) {
            return other instanceof OffsetIncrementing;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.offset;
            result = result * 59 + this.value;
            return result;
        }
    }

    protected class OffsetWriting
    implements StackManipulation {
        private final int offset;

        protected OffsetWriting(int offset) {
            this.offset = offset;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            methodVisitor.visitVarInsn(MethodVariableAccess.this.storeOpcode, this.offset);
            return MethodVariableAccess.this.size.toDecreasingSize();
        }

        private MethodVariableAccess getMethodVariableAccess() {
            return MethodVariableAccess.this;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && MethodVariableAccess.this == ((OffsetWriting)other).getMethodVariableAccess() && this.offset == ((OffsetWriting)other).offset;
        }

        public int hashCode() {
            return MethodVariableAccess.this.hashCode() + 31 * this.offset;
        }
    }

    protected class OffsetLoading
    implements StackManipulation {
        private final int offset;

        protected OffsetLoading(int offset) {
            this.offset = offset;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            methodVisitor.visitVarInsn(MethodVariableAccess.this.loadOpcode, this.offset);
            return MethodVariableAccess.this.size.toIncreasingSize();
        }

        private MethodVariableAccess getMethodVariableAccess() {
            return MethodVariableAccess.this;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && MethodVariableAccess.this == ((OffsetLoading)other).getMethodVariableAccess() && this.offset == ((OffsetLoading)other).offset;
        }

        public int hashCode() {
            return MethodVariableAccess.this.hashCode() + 31 * this.offset;
        }
    }

    public static class MethodLoading
    implements StackManipulation {
        private final MethodDescription methodDescription;
        private final TypeCastingHandler typeCastingHandler;

        protected MethodLoading(MethodDescription methodDescription, TypeCastingHandler typeCastingHandler) {
            this.methodDescription = methodDescription;
            this.typeCastingHandler = typeCastingHandler;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            ArrayList<StackManipulation> stackManipulations = new ArrayList<StackManipulation>();
            for (ParameterDescription parameterDescription : this.methodDescription.getParameters()) {
                TypeDescription parameterType = parameterDescription.getType().asErasure();
                stackManipulations.add(MethodVariableAccess.of(parameterType).loadFrom(parameterDescription.getOffset()));
                stackManipulations.add(this.typeCastingHandler.ofIndex(parameterType, parameterDescription.getIndex()));
            }
            return new StackManipulation.Compound(stackManipulations).apply(methodVisitor, implementationContext);
        }

        public StackManipulation prependThisReference() {
            return this.methodDescription.isStatic() ? this : new StackManipulation.Compound(MethodVariableAccess.loadThis(), this);
        }

        public MethodLoading asBridgeOf(MethodDescription bridgeTarget) {
            return new MethodLoading(this.methodDescription, new TypeCastingHandler.ForBridgeTarget(bridgeTarget));
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MethodLoading)) {
                return false;
            }
            MethodLoading other = (MethodLoading)o;
            if (!other.canEqual(this)) {
                return false;
            }
            MethodDescription this$methodDescription = this.methodDescription;
            MethodDescription other$methodDescription = other.methodDescription;
            if (this$methodDescription == null ? other$methodDescription != null : !this$methodDescription.equals(other$methodDescription)) {
                return false;
            }
            TypeCastingHandler this$typeCastingHandler = this.typeCastingHandler;
            TypeCastingHandler other$typeCastingHandler = other.typeCastingHandler;
            return !(this$typeCastingHandler == null ? other$typeCastingHandler != null : !this$typeCastingHandler.equals(other$typeCastingHandler));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MethodLoading;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            MethodDescription $methodDescription = this.methodDescription;
            result = result * 59 + ($methodDescription == null ? 43 : $methodDescription.hashCode());
            TypeCastingHandler $typeCastingHandler = this.typeCastingHandler;
            result = result * 59 + ($typeCastingHandler == null ? 43 : $typeCastingHandler.hashCode());
            return result;
        }

        protected static interface TypeCastingHandler {
            public StackManipulation ofIndex(TypeDescription var1, int var2);

            public static class ForBridgeTarget
            implements TypeCastingHandler {
                private final MethodDescription bridgeTarget;

                public ForBridgeTarget(MethodDescription bridgeTarget) {
                    this.bridgeTarget = bridgeTarget;
                }

                @Override
                public StackManipulation ofIndex(TypeDescription parameterType, int index) {
                    TypeDescription targetType = ((ParameterDescription)this.bridgeTarget.getParameters().get(index)).getType().asErasure();
                    return parameterType.equals(targetType) ? StackManipulation.Trivial.INSTANCE : TypeCasting.to(targetType);
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ForBridgeTarget)) {
                        return false;
                    }
                    ForBridgeTarget other = (ForBridgeTarget)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    MethodDescription this$bridgeTarget = this.bridgeTarget;
                    MethodDescription other$bridgeTarget = other.bridgeTarget;
                    return !(this$bridgeTarget == null ? other$bridgeTarget != null : !this$bridgeTarget.equals(other$bridgeTarget));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof ForBridgeTarget;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    MethodDescription $bridgeTarget = this.bridgeTarget;
                    result = result * 59 + ($bridgeTarget == null ? 43 : $bridgeTarget.hashCode());
                    return result;
                }
            }

            public static enum NoOp implements TypeCastingHandler
            {
                INSTANCE;


                @Override
                public StackManipulation ofIndex(TypeDescription parameterType, int index) {
                    return StackManipulation.Trivial.INSTANCE;
                }
            }
        }
    }
}

