/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.assertj.core.internal.bytebuddy.implementation.bind.annotation.RuntimeType;
import org.assertj.core.internal.bytebuddy.implementation.bind.annotation.SuperCall;
import org.assertj.core.internal.bytebuddy.implementation.bind.annotation.SuperMethod;
import org.assertj.core.internal.bytebuddy.implementation.bind.annotation.This;

public class ErrorCollector {
    private static final String INTERCEPT_METHOD_NAME = "intercept";
    private static final String CLASS_NAME = ErrorCollector.class.getName();
    private final List<Throwable> errors = new ArrayList<Throwable>();
    private final LastResult lastResult = new LastResult();

    @RuntimeType
    public Object intercept(@This Object obj, @SuperCall Callable<Object> proxy, @SuperMethod(nullIfImpossible=true) Method method) throws Exception {
        try {
            Object returnResult = proxy.call();
            this.lastResult.setSuccess(true);
            return returnResult;
        }
        catch (AssertionError e) {
            if (this.isNestedErrorCollectorProxyCall()) {
                throw e;
            }
            this.lastResult.setSuccess(false);
            this.errors.add((Throwable)((Object)e));
            if (method != null && !method.getReturnType().isInstance(obj)) {
                return null;
            }
            return obj;
        }
    }

    public void addError(Throwable error) {
        this.errors.add(error);
        this.lastResult.recordError();
    }

    public List<Throwable> errors() {
        return Collections.unmodifiableList(this.errors);
    }

    public boolean wasSuccess() {
        return this.lastResult.wasSuccess();
    }

    private boolean isNestedErrorCollectorProxyCall() {
        return ErrorCollector.countErrorCollectorProxyCalls() > 1;
    }

    private static int countErrorCollectorProxyCalls() {
        int nbCalls = 0;
        for (StackTraceElement stackTraceElement : Thread.currentThread().getStackTrace()) {
            if (!CLASS_NAME.equals(stackTraceElement.getClassName()) || !stackTraceElement.getMethodName().startsWith(INTERCEPT_METHOD_NAME)) continue;
            ++nbCalls;
        }
        return nbCalls;
    }

    private static class LastResult {
        private boolean wasSuccess = true;
        private boolean errorFound = false;

        private LastResult() {
        }

        private boolean wasSuccess() {
            return this.wasSuccess;
        }

        private void recordError() {
            this.errorFound = true;
            this.wasSuccess = false;
        }

        private void setSuccess(boolean success) {
            this.errorFound |= !success;
            if (this.resolvingOutermostErrorCollectorProxyNestedCall()) {
                this.wasSuccess = !this.errorFound;
                this.errorFound = false;
            }
        }

        private boolean resolvingOutermostErrorCollectorProxyNestedCall() {
            return ErrorCollector.countErrorCollectorProxyCalls() == 1;
        }

        public String toString() {
            return String.format("LastResult [wasSuccess=%s, errorFound=%s]", this.wasSuccess, this.errorFound);
        }
    }
}

