/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.data.Offset;
import org.assertj.core.data.Percentage;
import org.assertj.core.error.ShouldHaveValue;
import org.assertj.core.error.ShouldNotContainValue;
import org.assertj.core.internal.Comparables;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.Integers;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.VisibleForTesting;

public class AtomicIntegerAssert
extends AbstractAssert<AtomicIntegerAssert, AtomicInteger> {
    @VisibleForTesting
    Comparables comparables = new Comparables();
    @VisibleForTesting
    Integers integers = Integers.instance();

    public AtomicIntegerAssert(AtomicInteger actual) {
        super(actual, AtomicIntegerAssert.class);
    }

    public AtomicIntegerAssert hasValueBetween(int startInclusive, int endInclusive) {
        this.isNotNull();
        this.integers.assertIsBetween(this.getWritableAssertionInfo(), ((AtomicInteger)this.actual).get(), startInclusive, endInclusive);
        return (AtomicIntegerAssert)this.myself;
    }

    public AtomicIntegerAssert hasValueLessThan(int other) {
        this.isNotNull();
        this.integers.assertLessThan(this.getWritableAssertionInfo(), ((AtomicInteger)this.actual).get(), other);
        return (AtomicIntegerAssert)this.myself;
    }

    public AtomicIntegerAssert hasValueLessThanOrEqualTo(int other) {
        this.isNotNull();
        this.integers.assertLessThanOrEqualTo(this.getWritableAssertionInfo(), ((AtomicInteger)this.actual).get(), other);
        return (AtomicIntegerAssert)this.myself;
    }

    public AtomicIntegerAssert hasValueGreaterThan(int other) {
        this.isNotNull();
        this.integers.assertGreaterThan(this.getWritableAssertionInfo(), ((AtomicInteger)this.actual).get(), other);
        return (AtomicIntegerAssert)this.myself;
    }

    public AtomicIntegerAssert hasValueGreaterThanOrEqualTo(int other) {
        this.isNotNull();
        this.integers.assertGreaterThanOrEqualTo(this.getWritableAssertionInfo(), ((AtomicInteger)this.actual).get(), other);
        return (AtomicIntegerAssert)this.myself;
    }

    public AtomicIntegerAssert hasPositiveValue() {
        this.isNotNull();
        this.integers.assertIsPositive(this.getWritableAssertionInfo(), ((AtomicInteger)this.actual).get());
        return (AtomicIntegerAssert)this.myself;
    }

    public AtomicIntegerAssert hasNonPositiveValue() {
        this.isNotNull();
        this.integers.assertIsNotPositive(this.getWritableAssertionInfo(), ((AtomicInteger)this.actual).get());
        return (AtomicIntegerAssert)this.myself;
    }

    public AtomicIntegerAssert hasNegativeValue() {
        this.isNotNull();
        this.integers.assertIsNegative(this.getWritableAssertionInfo(), ((AtomicInteger)this.actual).get());
        return (AtomicIntegerAssert)this.myself;
    }

    public AtomicIntegerAssert hasNonNegativeValue() {
        this.isNotNull();
        this.integers.assertIsNotNegative(this.getWritableAssertionInfo(), ((AtomicInteger)this.actual).get());
        return (AtomicIntegerAssert)this.myself;
    }

    public AtomicIntegerAssert hasValueCloseTo(int expected, Percentage percentage) {
        this.isNotNull();
        this.integers.assertIsCloseToPercentage(this.getWritableAssertionInfo(), ((AtomicInteger)this.actual).get(), expected, percentage);
        return (AtomicIntegerAssert)this.myself;
    }

    public AtomicIntegerAssert hasValueCloseTo(int expected, Offset<Integer> offset) {
        this.isNotNull();
        this.integers.assertIsCloseTo(this.getWritableAssertionInfo(), ((AtomicInteger)this.actual).get(), expected, offset);
        return (AtomicIntegerAssert)this.myself;
    }

    public AtomicIntegerAssert hasValue(int expectedValue) {
        this.isNotNull();
        int actualValue = ((AtomicInteger)this.actual).get();
        if (!this.objects.getComparisonStrategy().areEqual(actualValue, expectedValue)) {
            this.throwAssertionError(ShouldHaveValue.shouldHaveValue(this.actual, expectedValue));
        }
        return (AtomicIntegerAssert)this.myself;
    }

    public AtomicIntegerAssert doesNotHaveValue(int expectedValue) {
        this.isNotNull();
        int actualValue = ((AtomicInteger)this.actual).get();
        if (this.objects.getComparisonStrategy().areEqual(actualValue, expectedValue)) {
            this.throwAssertionError(ShouldNotContainValue.shouldNotContainValue(this.actual, expectedValue));
        }
        return (AtomicIntegerAssert)this.myself;
    }

    @Override
    @CheckReturnValue
    public AtomicIntegerAssert usingComparator(Comparator<? super AtomicInteger> customComparator) {
        super.usingComparator(customComparator);
        this.integers = new Integers(new ComparatorBasedComparisonStrategy(customComparator));
        return (AtomicIntegerAssert)this.myself;
    }

    @Override
    @CheckReturnValue
    public AtomicIntegerAssert usingDefaultComparator() {
        super.usingDefaultComparator();
        this.integers = Integers.instance();
        return (AtomicIntegerAssert)this.myself;
    }
}

