/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.FloatingPointNumberAssert;
import org.assertj.core.data.Offset;
import org.assertj.core.data.Percentage;
import org.assertj.core.error.ShouldBeEqual;
import org.assertj.core.error.ShouldNotBeEqual;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.Doubles;
import org.assertj.core.internal.Failures;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractDoubleAssert<SELF extends AbstractDoubleAssert<SELF>>
extends AbstractComparableAssert<SELF, Double>
implements FloatingPointNumberAssert<SELF, Double> {
    private static final Double NEGATIVE_ZERO = new Double(-0.0);
    @VisibleForTesting
    Doubles doubles = Doubles.instance();
    private boolean isPrimitive;

    public AbstractDoubleAssert(Double actual, Class<?> selfType) {
        super(actual, selfType);
        this.isPrimitive = false;
    }

    public AbstractDoubleAssert(double actual, Class<?> selfType) {
        super(actual, selfType);
        this.isPrimitive = true;
    }

    @Override
    public SELF isNaN() {
        this.doubles.assertIsNaN(this.info, (Number)this.actual);
        return (SELF)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public SELF isNotNaN() {
        this.doubles.assertIsNotNaN(this.info, (Number)this.actual);
        return (SELF)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public SELF isZero() {
        if (this.isPrimitive) {
            this.assertIsPrimitiveZero();
        } else {
            this.doubles.assertIsZero(this.info, (Number)this.actual);
        }
        return (SELF)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public SELF isNotZero() {
        if (this.isPrimitive) {
            this.assertIsPrimitiveNonZero();
        } else {
            if (NEGATIVE_ZERO.equals(this.actual)) {
                return (SELF)((AbstractDoubleAssert)this.myself);
            }
            this.doubles.assertIsNotZero(this.info, (Number)this.actual);
        }
        return (SELF)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public SELF isOne() {
        this.doubles.assertIsOne(this.info, (Number)this.actual);
        return (SELF)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public SELF isPositive() {
        this.doubles.assertIsPositive(this.info, (Number)this.actual);
        return (SELF)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public SELF isNegative() {
        this.doubles.assertIsNegative(this.info, (Number)this.actual);
        return (SELF)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public SELF isNotNegative() {
        this.doubles.assertIsNotNegative(this.info, (Number)this.actual);
        return (SELF)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public SELF isNotPositive() {
        this.doubles.assertIsNotPositive(this.info, (Number)this.actual);
        return (SELF)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public SELF isCloseTo(double expected, Offset<Double> offset) {
        this.doubles.assertIsCloseTo(this.info, (Number)this.actual, expected, offset);
        return (SELF)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public SELF isNotCloseTo(double expected, Offset<Double> offset) {
        this.doubles.assertIsNotCloseTo(this.info, (Number)this.actual, expected, offset);
        return (SELF)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public SELF isCloseTo(Double expected, Offset<Double> offset) {
        this.doubles.assertIsCloseTo(this.info, (Number)this.actual, expected, offset);
        return (SELF)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public SELF isNotCloseTo(Double expected, Offset<Double> offset) {
        this.doubles.assertIsNotCloseTo(this.info, (Number)this.actual, expected, offset);
        return (SELF)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public SELF isCloseTo(Double expected, Percentage percentage) {
        this.doubles.assertIsCloseToPercentage(this.info, (Number)this.actual, expected, percentage);
        return (SELF)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public SELF isNotCloseTo(Double expected, Percentage percentage) {
        this.doubles.assertIsNotCloseToPercentage(this.info, (Number)this.actual, expected, percentage);
        return (SELF)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public SELF isCloseTo(double expected, Percentage percentage) {
        this.doubles.assertIsCloseToPercentage(this.info, (Number)this.actual, expected, percentage);
        return (SELF)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public SELF isNotCloseTo(double expected, Percentage percentage) {
        this.doubles.assertIsNotCloseToPercentage(this.info, (Number)this.actual, expected, percentage);
        return (SELF)((AbstractDoubleAssert)this.myself);
    }

    public SELF isEqualTo(double expected) {
        this.doubles.assertEqual(this.info, this.actual, expected);
        return (SELF)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public SELF isEqualTo(Double expected, Offset<Double> offset) {
        this.doubles.assertIsCloseTo(this.info, (Number)this.actual, expected, offset);
        return (SELF)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public SELF isEqualTo(double expected, Offset<Double> offset) {
        this.doubles.assertIsCloseTo(this.info, (Number)this.actual, expected, offset);
        return (SELF)((AbstractDoubleAssert)this.myself);
    }

    public SELF isNotEqualTo(double other) {
        this.doubles.assertNotEqual(this.info, this.actual, other);
        return (SELF)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public SELF isLessThan(double other) {
        this.doubles.assertLessThan(this.info, (Comparable)this.actual, other);
        return (SELF)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public SELF isLessThanOrEqualTo(double other) {
        this.doubles.assertLessThanOrEqualTo(this.info, (Comparable)this.actual, other);
        return (SELF)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public SELF isGreaterThan(double other) {
        this.doubles.assertGreaterThan(this.info, (Comparable)this.actual, other);
        return (SELF)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public SELF isGreaterThanOrEqualTo(double other) {
        this.doubles.assertGreaterThanOrEqualTo(this.info, (Comparable)this.actual, other);
        return (SELF)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public SELF isBetween(Double start, Double end) {
        this.doubles.assertIsBetween(this.info, (Number)this.actual, start, end);
        return (SELF)((AbstractDoubleAssert)this.myself);
    }

    @Override
    public SELF isStrictlyBetween(Double start, Double end) {
        this.doubles.assertIsStrictlyBetween(this.info, (Number)this.actual, start, end);
        return (SELF)((AbstractDoubleAssert)this.myself);
    }

    @Override
    @CheckReturnValue
    public SELF usingComparator(Comparator<? super Double> customComparator) {
        super.usingComparator(customComparator);
        this.doubles = new Doubles(new ComparatorBasedComparisonStrategy(customComparator));
        return (SELF)((AbstractDoubleAssert)this.myself);
    }

    @Override
    @CheckReturnValue
    public SELF usingDefaultComparator() {
        super.usingDefaultComparator();
        this.doubles = Doubles.instance();
        return (SELF)((AbstractDoubleAssert)this.myself);
    }

    private void assertIsPrimitiveZero() {
        if ((Double)this.actual == 0.0) {
            return;
        }
        throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqual.shouldBeEqual(this.actual, 0.0, this.info.representation()));
    }

    private void assertIsPrimitiveNonZero() {
        if ((Double)this.actual != 0.0) {
            return;
        }
        throw Failures.instance().failure((AssertionInfo)this.info, ShouldNotBeEqual.shouldNotBeEqual(this.actual, 0.0));
    }
}

