/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Predicate;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.AssertionsForClassTypes;
import org.assertj.core.error.ShouldBeEqual;
import org.assertj.core.error.ShouldMatch;
import org.assertj.core.error.future.ShouldBeCancelled;
import org.assertj.core.error.future.ShouldBeCompleted;
import org.assertj.core.error.future.ShouldBeCompletedExceptionally;
import org.assertj.core.error.future.ShouldBeDone;
import org.assertj.core.error.future.ShouldHaveFailed;
import org.assertj.core.error.future.ShouldNotBeCancelled;
import org.assertj.core.error.future.ShouldNotBeCompleted;
import org.assertj.core.error.future.ShouldNotBeCompletedExceptionally;
import org.assertj.core.error.future.ShouldNotBeDone;
import org.assertj.core.error.future.ShouldNotHaveFailed;
import org.assertj.core.internal.Failures;
import org.assertj.core.presentation.PredicateDescription;

public abstract class AbstractCompletableFutureAssert<S extends AbstractCompletableFutureAssert<S, T>, T>
extends AbstractAssert<S, CompletableFuture<T>> {
    protected AbstractCompletableFutureAssert(CompletableFuture<T> actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public S isDone() {
        this.isNotNull();
        if (!((CompletableFuture)this.actual).isDone()) {
            this.throwAssertionError(ShouldBeDone.shouldBeDone((CompletableFuture)this.actual));
        }
        return (S)((AbstractCompletableFutureAssert)this.myself);
    }

    public S isNotDone() {
        this.isNotNull();
        if (((CompletableFuture)this.actual).isDone()) {
            this.throwAssertionError(ShouldNotBeDone.shouldNotBeDone((CompletableFuture)this.actual));
        }
        return (S)((AbstractCompletableFutureAssert)this.myself);
    }

    public S isCompletedExceptionally() {
        this.isNotNull();
        if (!((CompletableFuture)this.actual).isCompletedExceptionally()) {
            this.throwAssertionError(ShouldBeCompletedExceptionally.shouldHaveCompletedExceptionally((CompletableFuture)this.actual));
        }
        return (S)((AbstractCompletableFutureAssert)this.myself);
    }

    public S isNotCompletedExceptionally() {
        this.isNotNull();
        if (((CompletableFuture)this.actual).isCompletedExceptionally()) {
            this.throwAssertionError(ShouldNotBeCompletedExceptionally.shouldNotHaveCompletedExceptionally((CompletableFuture)this.actual));
        }
        return (S)((AbstractCompletableFutureAssert)this.myself);
    }

    public S isCancelled() {
        this.isNotNull();
        if (!((CompletableFuture)this.actual).isCancelled()) {
            this.throwAssertionError(ShouldBeCancelled.shouldBeCancelled((CompletableFuture)this.actual));
        }
        return (S)((AbstractCompletableFutureAssert)this.myself);
    }

    public S isNotCancelled() {
        this.isNotNull();
        if (((CompletableFuture)this.actual).isCancelled()) {
            this.throwAssertionError(ShouldNotBeCancelled.shouldNotBeCancelled((CompletableFuture)this.actual));
        }
        return (S)((AbstractCompletableFutureAssert)this.myself);
    }

    public S isCompleted() {
        this.isNotNull();
        if (!((CompletableFuture)this.actual).isDone() || ((CompletableFuture)this.actual).isCompletedExceptionally()) {
            this.throwAssertionError(ShouldBeCompleted.shouldBeCompleted((CompletableFuture)this.actual));
        }
        return (S)((AbstractCompletableFutureAssert)this.myself);
    }

    public S isNotCompleted() {
        this.isNotNull();
        if (((CompletableFuture)this.actual).isDone() && !((CompletableFuture)this.actual).isCompletedExceptionally()) {
            this.throwAssertionError(ShouldNotBeCompleted.shouldNotBeCompleted((CompletableFuture)this.actual));
        }
        return (S)((AbstractCompletableFutureAssert)this.myself);
    }

    public S isCompletedWithValue(T expected) {
        this.isCompleted();
        Object actualResult = ((CompletableFuture)this.actual).join();
        if (!Objects.equals(actualResult, expected)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqual.shouldBeEqual(actualResult, expected, this.info.representation()));
        }
        return (S)((AbstractCompletableFutureAssert)this.myself);
    }

    public S isCompletedWithValueMatching(Predicate<? super T> predicate) {
        return this.isCompletedWithValueMatching(predicate, PredicateDescription.GIVEN);
    }

    public S isCompletedWithValueMatching(Predicate<? super T> predicate, String description) {
        return this.isCompletedWithValueMatching(predicate, new PredicateDescription(description));
    }

    private S isCompletedWithValueMatching(Predicate<? super T> predicate, PredicateDescription description) {
        this.isCompleted();
        Object actualResult = ((CompletableFuture)this.actual).join();
        if (!predicate.test(actualResult)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldMatch.shouldMatch(actualResult, predicate, description));
        }
        return (S)((AbstractCompletableFutureAssert)this.myself);
    }

    public S hasFailed() {
        this.isNotNull();
        if (!((CompletableFuture)this.actual).isCompletedExceptionally() || ((CompletableFuture)this.actual).isCancelled()) {
            this.throwAssertionError(ShouldHaveFailed.shouldHaveFailed((CompletableFuture)this.actual));
        }
        return (S)((AbstractCompletableFutureAssert)this.myself);
    }

    public S hasNotFailed() {
        this.isNotNull();
        if (((CompletableFuture)this.actual).isCompletedExceptionally() && !((CompletableFuture)this.actual).isCancelled()) {
            this.throwAssertionError(ShouldNotHaveFailed.shouldNotHaveFailed((CompletableFuture)this.actual));
        }
        return (S)((AbstractCompletableFutureAssert)this.myself);
    }

    public AbstractThrowableAssert<?, ? extends Throwable> hasFailedWithThrowableThat() {
        this.hasFailed();
        try {
            ((CompletableFuture)this.actual).join();
            return AssertionsForClassTypes.assertThat((Throwable)null);
        }
        catch (CompletionException e) {
            return AssertionsForClassTypes.assertThat(e.getCause());
        }
    }
}

