/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.io.File;
import java.util.Comparator;
import java.util.regex.Pattern;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.EnumerableAssert;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.Strings;
import org.assertj.core.util.IterableUtil;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractCharSequenceAssert<S extends AbstractCharSequenceAssert<S, A>, A extends CharSequence>
extends AbstractAssert<S, A>
implements EnumerableAssert<S, Character> {
    @VisibleForTesting
    Strings strings = Strings.instance();

    public AbstractCharSequenceAssert(A actual, Class<?> selfType) {
        super(actual, selfType);
    }

    @Override
    public void isNullOrEmpty() {
        this.strings.assertNullOrEmpty(this.info, (CharSequence)this.actual);
    }

    @Override
    public void isEmpty() {
        this.strings.assertEmpty(this.info, (CharSequence)this.actual);
    }

    @Override
    public S isNotEmpty() {
        this.strings.assertNotEmpty(this.info, (CharSequence)this.actual);
        return (S)((AbstractCharSequenceAssert)this.myself);
    }

    public S isBlank() {
        this.strings.assertBlank(this.info, (CharSequence)this.actual);
        return (S)((AbstractCharSequenceAssert)this.myself);
    }

    public S isNotBlank() {
        this.strings.assertNotBlank(this.info, (CharSequence)this.actual);
        return (S)((AbstractCharSequenceAssert)this.myself);
    }

    public S isJavaBlank() {
        this.strings.assertJavaBlank(this.info, (CharSequence)this.actual);
        return (S)((AbstractCharSequenceAssert)this.myself);
    }

    public S isNotJavaBlank() {
        this.strings.assertNotJavaBlank(this.info, (CharSequence)this.actual);
        return (S)((AbstractCharSequenceAssert)this.myself);
    }

    @Override
    public S hasSize(int expected) {
        this.strings.assertHasSize(this.info, (CharSequence)this.actual, expected);
        return (S)((AbstractCharSequenceAssert)this.myself);
    }

    public S hasLineCount(int expectedLineCount) {
        this.strings.assertHasLineCount(this.info, (CharSequence)this.actual, expectedLineCount);
        return (S)((AbstractCharSequenceAssert)this.myself);
    }

    public S hasSameSizeAs(CharSequence other) {
        this.strings.assertHasSameSizeAs((AssertionInfo)this.info, (CharSequence)this.actual, other);
        return (S)((AbstractCharSequenceAssert)this.myself);
    }

    @Override
    public S hasSameSizeAs(Object other) {
        this.strings.assertHasSameSizeAs((AssertionInfo)this.info, (CharSequence)this.actual, other);
        return (S)((AbstractCharSequenceAssert)this.myself);
    }

    @Override
    public S hasSameSizeAs(Iterable<?> other) {
        this.strings.assertHasSameSizeAs((AssertionInfo)this.info, (CharSequence)this.actual, other);
        return (S)((AbstractCharSequenceAssert)this.myself);
    }

    public S isEqualToIgnoringCase(CharSequence expected) {
        this.strings.assertEqualsIgnoringCase(this.info, (CharSequence)this.actual, expected);
        return (S)((AbstractCharSequenceAssert)this.myself);
    }

    public S isNotEqualToIgnoringCase(CharSequence expected) {
        this.strings.assertNotEqualsIgnoringCase(this.info, (CharSequence)this.actual, expected);
        return (S)((AbstractCharSequenceAssert)this.myself);
    }

    public S containsOnlyDigits() {
        this.strings.assertContainsOnlyDigits(this.info, (CharSequence)this.actual);
        return (S)((AbstractCharSequenceAssert)this.myself);
    }

    public S containsOnlyOnce(CharSequence sequence) {
        this.strings.assertContainsOnlyOnce(this.info, (CharSequence)this.actual, sequence);
        return (S)((AbstractCharSequenceAssert)this.myself);
    }

    public S contains(CharSequence ... values) {
        this.strings.assertContains(this.info, (CharSequence)this.actual, values);
        return (S)((AbstractCharSequenceAssert)this.myself);
    }

    public S contains(Iterable<? extends CharSequence> values) {
        this.strings.assertContains(this.info, (CharSequence)this.actual, IterableUtil.toArray(values, CharSequence.class));
        return (S)((AbstractCharSequenceAssert)this.myself);
    }

    public S containsSequence(CharSequence ... values) {
        this.strings.assertContainsSequence(this.info, (CharSequence)this.actual, values);
        return (S)((AbstractCharSequenceAssert)this.myself);
    }

    public S containsSequence(Iterable<? extends CharSequence> values) {
        this.strings.assertContainsSequence(this.info, (CharSequence)this.actual, IterableUtil.toArray(values, CharSequence.class));
        return (S)((AbstractCharSequenceAssert)this.myself);
    }

    public S containsIgnoringCase(CharSequence sequence) {
        this.strings.assertContainsIgnoringCase(this.info, (CharSequence)this.actual, sequence);
        return (S)((AbstractCharSequenceAssert)this.myself);
    }

    public S doesNotContain(CharSequence sequence) {
        this.strings.assertDoesNotContain(this.info, (CharSequence)this.actual, sequence);
        return (S)((AbstractCharSequenceAssert)this.myself);
    }

    public S startsWith(CharSequence prefix) {
        this.strings.assertStartsWith(this.info, (CharSequence)this.actual, prefix);
        return (S)((AbstractCharSequenceAssert)this.myself);
    }

    public S doesNotStartWith(CharSequence prefix) {
        this.strings.assertDoesNotStartWith(this.info, (CharSequence)this.actual, prefix);
        return (S)((AbstractCharSequenceAssert)this.myself);
    }

    public S endsWith(CharSequence suffix) {
        this.strings.assertEndsWith(this.info, (CharSequence)this.actual, suffix);
        return (S)((AbstractCharSequenceAssert)this.myself);
    }

    public S doesNotEndWith(CharSequence suffix) {
        this.strings.assertDoesNotEndWith(this.info, (CharSequence)this.actual, suffix);
        return (S)((AbstractCharSequenceAssert)this.myself);
    }

    public S matches(CharSequence regex) {
        this.strings.assertMatches((AssertionInfo)this.info, (CharSequence)this.actual, regex);
        return (S)((AbstractCharSequenceAssert)this.myself);
    }

    public S doesNotMatch(CharSequence regex) {
        this.strings.assertDoesNotMatch((AssertionInfo)this.info, (CharSequence)this.actual, regex);
        return (S)((AbstractCharSequenceAssert)this.myself);
    }

    public S matches(Pattern pattern) {
        this.strings.assertMatches((AssertionInfo)this.info, (CharSequence)this.actual, pattern);
        return (S)((AbstractCharSequenceAssert)this.myself);
    }

    public S doesNotMatch(Pattern pattern) {
        this.strings.assertDoesNotMatch((AssertionInfo)this.info, (CharSequence)this.actual, pattern);
        return (S)((AbstractCharSequenceAssert)this.myself);
    }

    public S isXmlEqualTo(CharSequence expectedXml) {
        this.strings.assertXmlEqualsTo(this.info, (CharSequence)this.actual, expectedXml);
        return (S)((AbstractCharSequenceAssert)this.myself);
    }

    public S isXmlEqualToContentOf(File xmlFile) {
        this.isXmlEqualTo(Assertions.contentOf(xmlFile));
        return (S)((AbstractCharSequenceAssert)this.myself);
    }

    @Override
    @Deprecated
    public final S usingElementComparator(Comparator<? super Character> customComparator) {
        throw new UnsupportedOperationException("custom element Comparator is not supported for CharSequence comparison");
    }

    @Override
    @Deprecated
    public final S usingDefaultElementComparator() {
        throw new UnsupportedOperationException("custom element Comparator is not supported for CharSequence comparison");
    }

    @Override
    public S usingComparator(Comparator<? super A> customComparator) {
        super.usingComparator((Comparator)customComparator);
        this.strings = new Strings(new ComparatorBasedComparisonStrategy(customComparator));
        return (S)((AbstractCharSequenceAssert)this.myself);
    }

    @Override
    public S usingDefaultComparator() {
        super.usingDefaultComparator();
        this.strings = Strings.instance();
        return (S)((AbstractCharSequenceAssert)this.myself);
    }

    @Override
    public S inHexadecimal() {
        return (S)((AbstractCharSequenceAssert)super.inHexadecimal());
    }

    public S inUnicode() {
        this.info.useUnicodeRepresentation();
        return (S)((AbstractCharSequenceAssert)this.myself);
    }

    public S isEqualToIgnoringWhitespace(CharSequence expected) {
        this.strings.assertEqualsIgnoringWhitespace(this.info, (CharSequence)this.actual, expected);
        return (S)((AbstractCharSequenceAssert)this.myself);
    }

    public S isNotEqualToIgnoringWhitespace(CharSequence expected) {
        this.strings.assertNotEqualsIgnoringWhitespace(this.info, (CharSequence)this.actual, expected);
        return (S)((AbstractCharSequenceAssert)this.myself);
    }

    public S isSubstringOf(CharSequence sequence) {
        this.strings.assertIsSubstringOf(this.info, (CharSequence)this.actual, sequence);
        return (S)((AbstractCharSequenceAssert)this.myself);
    }

    public S containsPattern(CharSequence regex) {
        this.strings.assertContainsPattern((AssertionInfo)this.info, (CharSequence)this.actual, regex);
        return (S)((AbstractCharSequenceAssert)this.myself);
    }

    public S containsPattern(Pattern pattern) {
        this.strings.assertContainsPattern((AssertionInfo)this.info, (CharSequence)this.actual, pattern);
        return (S)((AbstractCharSequenceAssert)this.myself);
    }
}

