/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractObjectArrayAssert;
import org.assertj.core.api.ObjectArrayAssert;
import org.assertj.core.extractor.Extractors;
import org.assertj.core.groups.Tuple;

public abstract class AbstractObjectAssert<S extends AbstractObjectAssert<S, A>, A>
extends AbstractAssert<S, A> {
    protected AbstractObjectAssert(A actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public S isEqualToIgnoringNullFields(Object other) {
        this.objects.assertIsEqualToIgnoringNullFields(this.info, this.actual, other);
        return (S)((AbstractObjectAssert)this.myself);
    }

    public S isEqualToComparingOnlyGivenFields(Object other, String ... propertiesOrFieldsUsedInComparison) {
        this.objects.assertIsEqualToComparingOnlyGivenFields(this.info, this.actual, other, propertiesOrFieldsUsedInComparison);
        return (S)((AbstractObjectAssert)this.myself);
    }

    public S isEqualToIgnoringGivenFields(Object other, String ... propertiesOrFieldsToIgnore) {
        this.objects.assertIsEqualToIgnoringGivenFields(this.info, this.actual, other, propertiesOrFieldsToIgnore);
        return (S)((AbstractObjectAssert)this.myself);
    }

    public S isEqualToComparingFieldByField(Object other) {
        this.objects.assertIsEqualToIgnoringGivenFields(this.info, this.actual, other, new String[0]);
        return (S)((AbstractObjectAssert)this.myself);
    }

    public S hasFieldOrProperty(String name) {
        this.objects.assertHasFieldOrProperty(this.info, this.actual, name);
        return (S)((AbstractObjectAssert)this.myself);
    }

    public S hasFieldOrPropertyWithValue(String name, Object value) {
        this.objects.assertHasFieldOrPropertyWithValue(this.info, this.actual, name, value);
        return (S)((AbstractObjectAssert)this.myself);
    }

    public AbstractObjectArrayAssert<?, Object> extracting(String ... propertiesOrFields) {
        Tuple values = Extractors.byName(propertiesOrFields).extract(this.actual);
        return new ObjectArrayAssert<Object>(values.toArray());
    }

    @SafeVarargs
    public final AbstractObjectArrayAssert<?, Object> extracting(Function<? super A, Object> ... extractors) {
        Object[] values = Stream.of(extractors).map(extractor -> extractor.apply(this.actual)).toArray();
        return new ObjectArrayAssert<Object>(values);
    }
}

