/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api.filter;

import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Condition;
import org.assertj.core.util.Lists;
import org.assertj.core.util.Objects;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.Strings;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.core.util.introspection.PropertyOrFieldSupport;

public class Filters<E> {
    @VisibleForTesting
    final Iterable<E> initialIterable;
    List<E> filteredIterable;
    private final PropertyOrFieldSupport propertyOrFieldSupport = PropertyOrFieldSupport.EXTRACTION;
    private String propertyOrFieldNameToFilterOn;

    public static <E> Filters<E> filter(Iterable<E> iterable) {
        return new Filters<E>(java.util.Objects.requireNonNull(iterable, "The iterable to filter should not be null"));
    }

    public static <E> Filters<E> filter(E[] array) {
        return new Filters<E>(java.util.Objects.requireNonNull(array, "The array to filter should not be null"));
    }

    private Filters(Iterable<E> iterable) {
        this.initialIterable = iterable;
        this.filteredIterable = Lists.newArrayList(iterable);
    }

    private Filters(E[] array) {
        this(Lists.newArrayList(array));
    }

    public Filters<E> being(Condition<? super E> condition) {
        Preconditions.checkArgument(condition != null, "The filter condition should not be null", new Object[0]);
        return this.applyFilterCondition(condition);
    }

    public Filters<E> having(Condition<? super E> condition) {
        Preconditions.checkArgument(condition != null, "The filter condition should not be null", new Object[0]);
        return this.applyFilterCondition(condition);
    }

    private Filters<E> applyFilterCondition(Condition<? super E> condition) {
        this.filteredIterable = this.filteredIterable.stream().filter(condition::matches).collect(Collectors.toList());
        return this;
    }

    public Filters<E> with(String propertyOrFieldName, Object propertyValue) {
        this.validatePropertyOrFieldName(propertyOrFieldName);
        this.propertyOrFieldNameToFilterOn = propertyOrFieldName;
        return this.equalsTo(propertyValue);
    }

    public Filters<E> with(String propertyOrFieldName) {
        this.validatePropertyOrFieldName(propertyOrFieldName);
        this.propertyOrFieldNameToFilterOn = propertyOrFieldName;
        return this;
    }

    private void validatePropertyOrFieldName(String propertyOrFieldName) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(propertyOrFieldName), "The property/field name to filter on should not be null or empty", new Object[0]);
    }

    public Filters<E> and(String propertyOrFieldName) {
        return this.with(propertyOrFieldName);
    }

    public Filters<E> equalsTo(Object propertyValue) {
        this.checkPropertyNameToFilterOnIsNotNull();
        this.filteredIterable = this.filteredIterable.stream().filter(element -> {
            Object propertyValueOfCurrentElement = this.propertyOrFieldSupport.getValueOf(this.propertyOrFieldNameToFilterOn, element);
            return Objects.areEqual(propertyValueOfCurrentElement, propertyValue);
        }).collect(Collectors.toList());
        return this;
    }

    public Filters<E> notEqualsTo(Object propertyValue) {
        this.checkPropertyNameToFilterOnIsNotNull();
        this.filteredIterable = this.filteredIterable.stream().filter(element -> {
            Object propertyValueOfCurrentElement = this.propertyOrFieldSupport.getValueOf(this.propertyOrFieldNameToFilterOn, element);
            return !Objects.areEqual(propertyValueOfCurrentElement, propertyValue);
        }).collect(Collectors.toList());
        return this;
    }

    private void checkPropertyNameToFilterOnIsNotNull() {
        Preconditions.checkArgument(this.propertyOrFieldNameToFilterOn != null, "The property name to filter on has not been set - no filtering is possible", new Object[0]);
    }

    public Filters<E> in(Object ... propertyValues) {
        this.checkPropertyNameToFilterOnIsNotNull();
        this.filteredIterable = this.filteredIterable.stream().filter(element -> {
            Object propertyValueOfCurrentElement = this.propertyOrFieldSupport.getValueOf(this.propertyOrFieldNameToFilterOn, element);
            return Filters.isItemInArray(propertyValueOfCurrentElement, propertyValues);
        }).collect(Collectors.toList());
        return this;
    }

    public Filters<E> notIn(Object ... propertyValues) {
        this.checkPropertyNameToFilterOnIsNotNull();
        this.filteredIterable = this.filteredIterable.stream().filter(element -> {
            Object propertyValueOfCurrentElement = this.propertyOrFieldSupport.getValueOf(this.propertyOrFieldNameToFilterOn, element);
            return !Filters.isItemInArray(propertyValueOfCurrentElement, propertyValues);
        }).collect(Collectors.toList());
        return this;
    }

    private static boolean isItemInArray(Object item, Object[] arrayOfValues) {
        for (Object value : arrayOfValues) {
            if (!Objects.areEqual(value, item)) continue;
            return true;
        }
        return false;
    }

    public List<E> get() {
        return this.filteredIterable;
    }
}

