/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api.recursive.comparison;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.stream.Stream;
import org.assertj.core.util.Arrays;
import org.assertj.core.util.Strings;

final class DualValue {
    static final Class<?>[] DEFAULT_ORDERED_COLLECTION_TYPES = Arrays.array(List.class, SortedSet.class, LinkedHashSet.class);
    final List<String> path;
    final String concatenatedPath;
    final Object actual;
    final Object expected;
    private final int hashCode;

    DualValue(List<String> path, Object actual, Object expected) {
        this.path = path;
        this.concatenatedPath = Strings.join(path).with(".");
        this.actual = actual;
        this.expected = expected;
        int h1 = actual != null ? actual.hashCode() : 0;
        int h2 = expected != null ? expected.hashCode() : 0;
        this.hashCode = h1 + h2;
    }

    public boolean equals(Object other) {
        if (!(other instanceof DualValue)) {
            return false;
        }
        DualValue that = (DualValue)other;
        return this.actual == that.actual && this.expected == that.expected;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return String.format("DualValue [path=%s, actual=%s, expected=%s]", this.concatenatedPath, this.actual, this.expected);
    }

    public List<String> getPath() {
        return Collections.unmodifiableList(this.path);
    }

    public String getConcatenatedPath() {
        return this.concatenatedPath;
    }

    public boolean isJavaType() {
        if (this.actual == null) {
            return false;
        }
        return this.actual.getClass().getName().startsWith("java.");
    }

    public boolean isExpectedFieldAnArray() {
        return Arrays.isArray(this.expected);
    }

    public boolean isActualFieldAnArray() {
        return Arrays.isArray(this.actual);
    }

    public boolean hasIterableValues() {
        return this.actual instanceof Iterable && this.expected instanceof Iterable;
    }

    public boolean isActualFieldAnOptional() {
        return this.actual instanceof Optional;
    }

    public boolean isExpectedFieldAnOptional() {
        return this.expected instanceof Optional;
    }

    public boolean isActualFieldAMap() {
        return this.actual instanceof Map;
    }

    public boolean isExpectedFieldAMap() {
        return this.expected instanceof Map;
    }

    public boolean isActualFieldASortedMap() {
        return this.actual instanceof SortedMap;
    }

    public boolean isExpectedFieldASortedMap() {
        return this.expected instanceof SortedMap;
    }

    public boolean isActualFieldAnOrderedCollection() {
        return DualValue.isAnOrderedCollection(this.actual);
    }

    public boolean isExpectedFieldAnOrderedCollection() {
        return DualValue.isAnOrderedCollection(this.expected);
    }

    public boolean isActualFieldAnIterable() {
        return this.actual instanceof Iterable;
    }

    public boolean isExpectedFieldAnIterable() {
        return this.expected instanceof Iterable;
    }

    private static boolean isAnOrderedCollection(Object value) {
        return Stream.of(DEFAULT_ORDERED_COLLECTION_TYPES).anyMatch(type -> type.isInstance(value));
    }
}

