/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import java.util.Map;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.EnumerableAssert;
import org.assertj.core.data.MapEntry;
import org.assertj.core.internal.Maps;
import org.assertj.core.util.Arrays;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractMapAssert<S extends AbstractMapAssert<S, A, K, V>, A extends Map<K, V>, K, V>
extends AbstractAssert<S, A>
implements EnumerableAssert<S, MapEntry<? extends K, ? extends V>> {
    @VisibleForTesting
    Maps maps = Maps.instance();

    protected AbstractMapAssert(A actual, Class<?> selfType) {
        super(actual, selfType);
    }

    @Override
    public void isNullOrEmpty() {
        this.maps.assertNullOrEmpty(this.info, (Map)this.actual);
    }

    @Override
    public void isEmpty() {
        this.maps.assertEmpty(this.info, (Map)this.actual);
    }

    @Override
    public S isNotEmpty() {
        this.maps.assertNotEmpty(this.info, (Map)this.actual);
        return (S)((AbstractMapAssert)this.myself);
    }

    @Override
    public S hasSize(int expected) {
        this.maps.assertHasSize(this.info, (Map)this.actual, expected);
        return (S)((AbstractMapAssert)this.myself);
    }

    @Override
    public S hasSameSizeAs(Object other) {
        this.maps.assertHasSameSizeAs((AssertionInfo)this.info, (Map)this.actual, other);
        return (S)((AbstractMapAssert)this.myself);
    }

    @Override
    public S hasSameSizeAs(Iterable<?> other) {
        this.maps.assertHasSameSizeAs((AssertionInfo)this.info, (Map)this.actual, other);
        return (S)((AbstractMapAssert)this.myself);
    }

    public S hasSameSizeAs(Map<?, ?> other) {
        this.maps.assertHasSameSizeAs((AssertionInfo)this.info, (Map)this.actual, other);
        return (S)((AbstractMapAssert)this.myself);
    }

    public S contains(MapEntry<? extends K, ? extends V> ... entries) {
        this.maps.assertContains(this.info, (Map)this.actual, entries);
        return (S)((AbstractMapAssert)this.myself);
    }

    public S containsEntry(K key, V value) {
        this.maps.assertContains(this.info, (Map)this.actual, Arrays.array(MapEntry.entry(key, value)));
        return (S)((AbstractMapAssert)this.myself);
    }

    public S doesNotContain(MapEntry<? extends K, ? extends V> ... entries) {
        this.maps.assertDoesNotContain(this.info, (Map)this.actual, entries);
        return (S)((AbstractMapAssert)this.myself);
    }

    public S doesNotContainEntry(K key, V value) {
        this.maps.assertDoesNotContain(this.info, (Map)this.actual, Arrays.array(MapEntry.entry(key, value)));
        return (S)((AbstractMapAssert)this.myself);
    }

    public S containsKey(K key) {
        return this.containsKeys(key);
    }

    public S containsKeys(K ... keys) {
        this.maps.assertContainsKeys(this.info, (Map)this.actual, keys);
        return (S)((AbstractMapAssert)this.myself);
    }

    public S doesNotContainKey(K key) {
        return this.doesNotContainKeys(key);
    }

    public S doesNotContainKeys(K ... keys) {
        this.maps.assertDoesNotContainKeys(this.info, (Map)this.actual, keys);
        return (S)((AbstractMapAssert)this.myself);
    }

    public S containsOnlyKeys(K ... keys) {
        this.maps.assertContainsOnlyKeys(this.info, (Map)this.actual, keys);
        return (S)((AbstractMapAssert)this.myself);
    }

    public S containsValue(V value) {
        this.maps.assertContainsValue(this.info, (Map)this.actual, value);
        return (S)((AbstractMapAssert)this.myself);
    }

    public S containsValues(V ... values) {
        this.maps.assertContainsValues(this.info, (Map)this.actual, values);
        return (S)((AbstractMapAssert)this.myself);
    }

    public S doesNotContainValue(V value) {
        this.maps.assertDoesNotContainValue(this.info, (Map)this.actual, value);
        return (S)((AbstractMapAssert)this.myself);
    }

    public S containsOnly(MapEntry<? extends K, ? extends V> ... entries) {
        this.maps.assertContainsOnly(this.info, (Map)this.actual, entries);
        return (S)((AbstractMapAssert)this.myself);
    }

    public S containsExactly(MapEntry<? extends K, ? extends V> ... entries) {
        this.maps.assertContainsExactly(this.info, (Map)this.actual, entries);
        return (S)((AbstractMapAssert)this.myself);
    }

    @Override
    @Deprecated
    public S usingElementComparator(Comparator<? super MapEntry<? extends K, ? extends V>> customComparator) {
        throw new UnsupportedOperationException("custom element Comparator is not supported for MapEntry comparison");
    }

    @Override
    @Deprecated
    public S usingDefaultElementComparator() {
        throw new UnsupportedOperationException("custom element Comparator is not supported for MapEntry comparison");
    }
}

