/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import java.util.List;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.api.WritableAssertionInfo;
import org.assertj.core.description.Description;
import org.assertj.core.error.MessageFormatter;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.Conditions;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Objects;
import org.assertj.core.util.Strings;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractAssert<S extends AbstractAssert<S, A>, A>
implements Assert<S, A> {
    @VisibleForTesting
    Objects objects = Objects.instance();
    @VisibleForTesting
    Conditions conditions = Conditions.instance();
    @VisibleForTesting
    protected final WritableAssertionInfo info;
    @VisibleForTesting
    protected final A actual;
    protected final S myself;

    protected AbstractAssert(A actual, Class<?> selfType) {
        this.myself = (AbstractAssert)selfType.cast(this);
        this.actual = actual;
        this.info = new WritableAssertionInfo();
    }

    protected WritableAssertionInfo getWritableAssertionInfo() {
        return this.info;
    }

    protected void failWithMessage(String errorMessage, Object ... arguments) {
        AssertionError failureWithOverriddenErrorMessage = Failures.instance().failureIfErrorMessageIsOverridden(this.info);
        if (failureWithOverriddenErrorMessage != null) {
            throw failureWithOverriddenErrorMessage;
        }
        String description = MessageFormatter.instance().format(this.info.description(), this.info.representation(), "", new Object[0]);
        throw new AssertionError((Object)(description + String.format(errorMessage, arguments)));
    }

    @Override
    public S as(String description, Object ... args) {
        return (S)this.describedAs(description, args);
    }

    @Override
    public S as(Description description) {
        return (S)this.describedAs(description);
    }

    protected S inHexadecimal() {
        this.info.useHexadecimalRepresentation();
        return this.myself;
    }

    protected S inBinary() {
        this.info.useBinaryRepresentation();
        return this.myself;
    }

    @Override
    public S describedAs(String description, Object ... args) {
        this.info.description(description, args);
        return this.myself;
    }

    @Override
    public S describedAs(Description description) {
        this.info.description(description);
        return this.myself;
    }

    @Override
    public S isEqualTo(Object expected) {
        this.objects.assertEqual(this.info, this.actual, expected);
        return this.myself;
    }

    @Override
    public S isNotEqualTo(Object other) {
        this.objects.assertNotEqual(this.info, this.actual, other);
        return this.myself;
    }

    @Override
    public void isNull() {
        this.objects.assertNull(this.info, this.actual);
    }

    @Override
    public S isNotNull() {
        this.objects.assertNotNull(this.info, this.actual);
        return this.myself;
    }

    @Override
    public S isSameAs(Object expected) {
        this.objects.assertSame(this.info, this.actual, expected);
        return this.myself;
    }

    @Override
    public S isNotSameAs(Object other) {
        this.objects.assertNotSame(this.info, this.actual, other);
        return this.myself;
    }

    @Override
    public S isIn(Object ... values) {
        this.objects.assertIsIn((AssertionInfo)this.info, this.actual, values);
        return this.myself;
    }

    @Override
    public S isNotIn(Object ... values) {
        this.objects.assertIsNotIn((AssertionInfo)this.info, this.actual, values);
        return this.myself;
    }

    @Override
    public S isIn(Iterable<?> values) {
        this.objects.assertIsIn((AssertionInfo)this.info, this.actual, values);
        return this.myself;
    }

    @Override
    public S isNotIn(Iterable<?> values) {
        this.objects.assertIsNotIn((AssertionInfo)this.info, this.actual, values);
        return this.myself;
    }

    @Override
    public S is(Condition<? super A> condition) {
        this.conditions.assertIs(this.info, this.actual, condition);
        return this.myself;
    }

    @Override
    public S isNot(Condition<? super A> condition) {
        this.conditions.assertIsNot(this.info, this.actual, condition);
        return this.myself;
    }

    @Override
    public S has(Condition<? super A> condition) {
        this.conditions.assertHas(this.info, this.actual, condition);
        return this.myself;
    }

    @Override
    public S doesNotHave(Condition<? super A> condition) {
        this.conditions.assertDoesNotHave(this.info, this.actual, condition);
        return this.myself;
    }

    @Override
    public S isInstanceOf(Class<?> type) {
        this.objects.assertIsInstanceOf(this.info, this.actual, type);
        return this.myself;
    }

    @Override
    public S isInstanceOfAny(Class<?> ... types) {
        this.objects.assertIsInstanceOfAny(this.info, this.actual, types);
        return this.myself;
    }

    @Override
    public S isNotInstanceOf(Class<?> type) {
        this.objects.assertIsNotInstanceOf(this.info, this.actual, type);
        return this.myself;
    }

    @Override
    public S isNotInstanceOfAny(Class<?> ... types) {
        this.objects.assertIsNotInstanceOfAny(this.info, this.actual, types);
        return this.myself;
    }

    @Override
    public S hasSameClassAs(Object other) {
        this.objects.assertHasSameClassAs(this.info, this.actual, other);
        return this.myself;
    }

    @Override
    public S hasToString(String expectedToString) {
        this.objects.assertHasToString(this.info, this.actual, expectedToString);
        return this.myself;
    }

    @Override
    public S doesNotHaveSameClassAs(Object other) {
        this.objects.assertDoesNotHaveSameClassAs(this.info, this.actual, other);
        return this.myself;
    }

    @Override
    public S isExactlyInstanceOf(Class<?> type) {
        this.objects.assertIsExactlyInstanceOf(this.info, this.actual, type);
        return this.myself;
    }

    @Override
    public S isNotExactlyInstanceOf(Class<?> type) {
        this.objects.assertIsNotExactlyInstanceOf(this.info, this.actual, type);
        return this.myself;
    }

    @Override
    public S isOfAnyClassIn(Class<?> ... types) {
        this.objects.assertIsOfAnyClassIn(this.info, this.actual, types);
        return this.myself;
    }

    @Override
    public S isNotOfAnyClassIn(Class<?> ... types) {
        this.objects.assertIsNotOfAnyClassIn(this.info, this.actual, types);
        return this.myself;
    }

    @Override
    public AbstractListAssert<?, ?, Object> asList() {
        this.objects.assertIsInstanceOf(this.info, this.actual, List.class);
        return Assertions.assertThat((List)this.actual);
    }

    @Override
    public AbstractCharSequenceAssert<?, String> asString() {
        this.objects.assertIsInstanceOf(this.info, this.actual, String.class);
        return Assertions.assertThat((String)this.actual);
    }

    public String descriptionText() {
        return this.info.descriptionText();
    }

    public S overridingErrorMessage(String newErrorMessage, Object ... args) {
        this.info.overridingErrorMessage(Strings.formatIfArgs(newErrorMessage, args));
        return this.myself;
    }

    @Override
    public S usingComparator(Comparator<? super A> customComparator) {
        this.objects = new Objects(new ComparatorBasedComparisonStrategy(customComparator));
        return this.myself;
    }

    @Override
    public S usingDefaultComparator() {
        this.objects = Objects.instance();
        return this.myself;
    }

    @Override
    public S withThreadDumpOnError() {
        Failures.instance().enablePrintThreadDump();
        return this.myself;
    }

    @Override
    @Deprecated
    public boolean equals(Object obj) {
        throw new UnsupportedOperationException("'equals' is not supported...maybe you intended to call 'isEqualTo'");
    }

    public int hashCode() {
        return 1;
    }
}

