/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.presentation;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.assertj.core.groups.Tuple;
import org.assertj.core.presentation.Representation;
import org.assertj.core.util.Collections;
import org.assertj.core.util.Maps;

final class CollectionToString {
    public static String toStringOf(Representation representation, Object o) {
        if (org.assertj.core.util.Arrays.isArray(o)) {
            return org.assertj.core.util.Arrays.format(representation, o);
        }
        if (o instanceof Collection) {
            return CollectionToString.toStringOf((Collection)o, representation);
        }
        if (o instanceof Map) {
            return CollectionToString.toStringOf((Map)o, representation);
        }
        if (o instanceof Tuple) {
            return CollectionToString.toStringOf((Tuple)o, representation);
        }
        return CollectionToString.defaultToString(o);
    }

    private static String toStringOf(Collection<?> c, Representation p) {
        return Collections.format(p, c);
    }

    private static String toStringOf(Map<?, ?> m, Representation p) {
        return Maps.format(p, m);
    }

    private static String toStringOf(Tuple tuple, Representation representation) {
        return Collections.format(representation, Arrays.asList(tuple.toArray()), "(", ")");
    }

    private static String defaultToString(Object o) {
        return o == null ? null : o.toString();
    }

    private CollectionToString() {
    }
}

