/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Iterator;
import org.assertj.core.api.AbstractIterableAssert;

public class IterableAssert<T>
extends AbstractIterableAssert<IterableAssert<T>, Iterable<T>, T> {
    protected IterableAssert(Iterable<T> actual) {
        super(actual, IterableAssert.class);
    }

    protected IterableAssert(Iterator<T> actual) {
        this(IterableAssert.toLazyIterable(actual));
    }

    private static <T> Iterable<T> toLazyIterable(Iterator<T> actual) {
        if (actual == null) {
            return null;
        }
        return new LazyIteratorToIterableWrapper<T>(actual);
    }

    private static <T> Iterable<T> toIterable(Iterator<T> iterator) {
        ArrayList<T> list = new ArrayList<T>();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static class LazyIteratorToIterableWrapper<T>
    extends AbstractCollection<T> {
        private Iterator<T> iterator;
        private Iterable<T> iterable;

        public LazyIteratorToIterableWrapper(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        @Override
        public Iterator<T> iterator() {
            if (this.iterable == null) {
                this.iterable = IterableAssert.toIterable(this.iterator);
            }
            return this.iterable.iterator();
        }

        @Override
        public int size() {
            int size = 0;
            Iterator<T> localIterator = this.iterator();
            while (localIterator.hasNext()) {
                localIterator.next();
                ++size;
            }
            return size;
        }
    }
}

