/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.jobs;

import org.eclipse.core.internal.jobs.InternalJob;
import org.eclipse.core.internal.jobs.JobManager;
import org.eclipse.core.internal.jobs.LockManager;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

class ThreadJob
extends Job {
    static final Object notifier = new Object();
    private final JobManager manager;
    protected boolean acquireRule = false;
    boolean isBlocked = false;
    protected boolean isRunning = false;
    private RuntimeException lastPush = null;
    protected Job realJob;
    private ISchedulingRule[] ruleStack;
    private int top;

    ThreadJob(JobManager manager, ISchedulingRule rule) {
        super("Implicit Job");
        this.manager = manager;
        this.setSystem(true);
        this.setPriority(10);
        this.ruleStack = new ISchedulingRule[2];
        this.top = -1;
        this.setRule(rule);
    }

    private void illegalPop(ISchedulingRule rule) {
        StringBuffer buf = new StringBuffer("Attempted to endRule: ");
        buf.append(rule);
        if (this.top >= 0 && this.top < this.ruleStack.length) {
            buf.append(", does not match most recent begin: ");
            buf.append(this.ruleStack[this.top]);
        } else if (this.top < 0) {
            buf.append(", but there was no matching beginRule");
        } else {
            buf.append(", but the rule stack was out of bounds: " + this.top);
        }
        buf.append(".  See log for trace information if rule tracing is enabled.");
        String msg = buf.toString();
        if (JobManager.DEBUG || JobManager.DEBUG_BEGIN_END) {
            System.out.println(msg);
            RuntimeException t = this.lastPush == null ? new IllegalArgumentException() : this.lastPush;
            Status error = new Status(4, "org.eclipse.core.jobs", 1, msg, t);
            RuntimeLog.log(error);
        }
        Assert.isLegal(false, msg);
    }

    private void illegalPush(ISchedulingRule pushRule, ISchedulingRule baseRule) {
        StringBuffer buf = new StringBuffer("Attempted to beginRule: ");
        buf.append(pushRule);
        buf.append(", does not match outer scope rule: ");
        buf.append(baseRule);
        String msg = buf.toString();
        if (JobManager.DEBUG) {
            System.out.println(msg);
            Status error = new Status(4, "org.eclipse.core.jobs", 1, msg, new IllegalArgumentException());
            RuntimeLog.log(error);
        }
        Assert.isLegal(false, msg);
    }

    private boolean isCanceled(IProgressMonitor monitor) {
        try {
            return monitor.isCanceled();
        }
        catch (RuntimeException e) {
            Status status = new Status(4, "org.eclipse.core.jobs", 2, "ThreadJob.isCanceled", e);
            RuntimeLog.log(status);
            return false;
        }
    }

    synchronized boolean isRunning() {
        return this.isRunning;
    }

    /*
     * Exception decompiling
     */
    ThreadJob joinRun(IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 21[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    boolean pop(ISchedulingRule rule) {
        if (this.top < 0 || this.ruleStack[this.top] != rule) {
            this.illegalPop(rule);
        }
        this.ruleStack[this.top--] = null;
        return this.top < 0;
    }

    void push(ISchedulingRule rule) {
        ISchedulingRule baseRule = this.getRule();
        if (++this.top >= this.ruleStack.length) {
            ISchedulingRule[] newStack = new ISchedulingRule[this.ruleStack.length * 2];
            System.arraycopy(this.ruleStack, 0, newStack, 0, this.ruleStack.length);
            this.ruleStack = newStack;
        }
        this.ruleStack[this.top] = rule;
        if (JobManager.DEBUG_BEGIN_END) {
            this.lastPush = (RuntimeException)new RuntimeException().fillInStackTrace();
        }
        if (baseRule != null && rule != null && !baseRule.contains(rule)) {
            this.illegalPush(rule, baseRule);
        }
    }

    boolean recycle() {
        if (this.getState() != 0) {
            return false;
        }
        this.isBlocked = false;
        this.isRunning = false;
        this.acquireRule = false;
        this.realJob = null;
        this.setRule(null);
        this.setThread(null);
        if (this.ruleStack.length != 2) {
            this.ruleStack = new ISchedulingRule[2];
        } else {
            this.ruleStack[1] = null;
            this.ruleStack[0] = null;
        }
        this.top = -1;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus run(IProgressMonitor monitor) {
        ThreadJob threadJob = this;
        synchronized (threadJob) {
            this.isRunning = true;
        }
        return Job.ASYNC_FINISH;
    }

    void setRealJob(Job realJob) {
        this.realJob = realJob;
    }

    boolean shouldInterrupt() {
        return this.realJob == null ? true : !this.realJob.isSystem();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("ThreadJob");
        buf.append('(').append(this.realJob).append(',').append('[');
        int i = 0;
        while (i <= this.top && i < this.ruleStack.length) {
            buf.append(this.ruleStack[i]).append(',');
            ++i;
        }
        buf.append(']').append(')');
        return buf.toString();
    }

    private void waitEnd(IProgressMonitor monitor) {
        LockManager lockManager = this.manager.getLockManager();
        Thread currentThread = Thread.currentThread();
        if (this.isRunning()) {
            lockManager.addLockThread(currentThread, this.getRule());
            lockManager.resumeSuspendedLocks(currentThread);
        } else {
            lockManager.removeLockWaitThread(currentThread, this.getRule());
        }
    }

    private void waitStart(IProgressMonitor monitor, InternalJob blockingJob) {
        this.manager.getLockManager().addLockWaitThread(Thread.currentThread(), this.getRule());
        this.isBlocked = true;
        this.manager.reportBlocked(monitor, blockingJob);
    }
}

