/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.asimba.util.ldap;

import com.alfaariss.oa.OAException;
import com.unboundid.ldap.sdk.Filter;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gluu.asimba.util.ldap.idp.IDPEntry;
import org.gluu.asimba.util.ldap.idp.LdapIDPEntry;
import org.gluu.asimba.util.ldap.selector.ApplicationSelectorEntry;
import org.gluu.asimba.util.ldap.selector.LDAPApplicationSelectorEntry;
import org.gluu.asimba.util.ldap.sp.LDAPRequestorEntry;
import org.gluu.asimba.util.ldap.sp.LDAPRequestorPoolEntry;
import org.gluu.asimba.util.ldap.sp.RequestorEntry;
import org.gluu.asimba.util.ldap.sp.RequestorPoolEntry;
import org.gluu.site.ldap.LDAPConnectionProvider;
import org.gluu.site.ldap.OperationsFacade;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.xdi.config.oxtrust.LdapOxAsimbaConfiguration;
import org.xdi.util.StringHelper;
import org.xdi.util.properties.FileConfiguration;
import org.xdi.util.security.StringEncrypter;

public class LDAPUtility {
    private static final Log log = LogFactory.getLog(LDAPUtility.class);
    @Deprecated
    private static final String ASIMBA_LDAP_CONFIGURATION_FILENAME = "oxasimba-ldap.properties";
    private static final String OX_LDAP_CONFIGURATION_FILENAME = "ox-ldap.properties";
    @Deprecated
    private static final String CONFIGURATION_ENTRY_DN = "configurationEntryDN";
    private static final String OXASIMBA_CONFIGURATION_ENTRY_DN = "oxasimba_ConfigurationEntryDN";
    private static final String SALT_FILE_NAME = "salt";
    public static final String inum = "inum";
    public static final String iname = "iname";
    public static final String uniqueIdentifier = "uniqueIdentifier";
    public static final String friendlyName = "friendlyName";
    public static final String identificationURL = "identificationURL";
    public static final String organizationId = "organizationId";
    public static final String description = "description";
    private static final LdapEntryManager ldapEntryManager = LDAPUtility.getLDAPEntryManagerSafe();
    private static String configurationEntryDN;

    public static String getBaseDirectory() {
        if (System.getProperty("gluu.base") != null) {
            return System.getProperty("gluu.base");
        }
        if (System.getProperty("catalina.base") != null && System.getProperty("catalina.base.ignore") == null) {
            return System.getProperty("catalina.base");
        }
        if (System.getProperty("catalina.home") != null) {
            return System.getProperty("catalina.home");
        }
        if (System.getProperty("jboss.home.dir") != null) {
            return System.getProperty("jboss.home.dir");
        }
        return null;
    }

    private static String getConfigurationFilePath() {
        String configurationFilePath = LDAPUtility.getBaseDirectory() + File.separator + "conf" + File.separator + ASIMBA_LDAP_CONFIGURATION_FILENAME;
        File configurationFile = new File(configurationFilePath);
        if (!(configurationFile.exists() && configurationFile.isFile() && configurationFile.canRead())) {
            configurationFilePath = LDAPUtility.getBaseDirectory() + File.separator + "conf" + File.separator + OX_LDAP_CONFIGURATION_FILENAME;
        }
        return configurationFilePath;
    }

    private static String getSaltFilePath() {
        return LDAPUtility.getBaseDirectory() + File.separator + "conf" + File.separator + SALT_FILE_NAME;
    }

    private static FileConfiguration createFileConfiguration(String fileName, boolean isMandatory) throws OAException {
        block3: {
            try {
                FileConfiguration fileConfiguration = new FileConfiguration(fileName);
                if (fileConfiguration.isLoaded()) {
                    return fileConfiguration;
                }
            }
            catch (Exception ex) {
                if (!isMandatory) break block3;
                log.error((Object)("Failed to load configuration from " + fileName), (Throwable)ex);
                throw new OAException(17);
            }
        }
        return null;
    }

    private static String loadCryptoConfigurationSalt() {
        try {
            FileConfiguration cryptoConfiguration = LDAPUtility.createFileConfiguration(LDAPUtility.getSaltFilePath(), true);
            return cryptoConfiguration.getString("encodeSalt");
        }
        catch (Exception ex) {
            log.error((Object)("Failed to loadCryptoConfigurationSalt() from: " + LDAPUtility.getSaltFilePath()));
            return null;
        }
    }

    public static synchronized LdapEntryManager getLDAPEntryManager() throws OAException {
        try {
            FileConfiguration configuration = LDAPUtility.createFileConfiguration(LDAPUtility.getConfigurationFilePath(), false);
            configurationEntryDN = configuration.getString(OXASIMBA_CONFIGURATION_ENTRY_DN);
            if (configurationEntryDN == null || "".equals(configurationEntryDN)) {
                configurationEntryDN = configuration.getString(CONFIGURATION_ENTRY_DN);
            }
            String cryptoConfigurationSalt = LDAPUtility.loadCryptoConfigurationSalt();
            Properties properties = configuration.getProperties();
            properties.setProperty("bindDN", configuration.getString("bindDN"));
            properties.setProperty("bindPassword", StringEncrypter.defaultInstance().decrypt(configuration.getString("bindPassword"), cryptoConfigurationSalt));
            properties.setProperty("servers", configuration.getString("servers"));
            properties.setProperty("useSSL", configuration.getString("useSSL"));
            LDAPConnectionProvider provider = new LDAPConnectionProvider(properties);
            OperationsFacade ops = new OperationsFacade(provider, null);
            return new LdapEntryManager(ops);
        }
        catch (Exception e) {
            log.error((Object)"cannot open LdapEntryManager", (Throwable)e);
            throw new OAException(17);
        }
    }

    private static LdapEntryManager getLDAPEntryManagerSafe() {
        try {
            return LDAPUtility.getLDAPEntryManager();
        }
        catch (Exception e) {
            log.error((Object)e);
            return null;
        }
    }

    public static synchronized LdapOxAsimbaConfiguration loadAsimbaConfiguration() {
        String applianceDn = LDAPUtility.getDnForAsimbaAppliance();
        LdapOxAsimbaConfiguration ldapConfiguration = (LdapOxAsimbaConfiguration)ldapEntryManager.find(LdapOxAsimbaConfiguration.class, (Object)applianceDn, null);
        return ldapConfiguration;
    }

    public static synchronized List<IDPEntry> loadIDPs() {
        ArrayList<IDPEntry> result = new ArrayList<IDPEntry>();
        try {
            List entries = ldapEntryManager.findEntries(LDAPUtility.getDnForLdapIDPEntry(null), LdapIDPEntry.class, null);
            for (LdapIDPEntry entry : entries) {
                result.add(entry.getEntry());
            }
        }
        catch (Exception ex) {
            log.error((Object)"Failed to load LDAP configuration IDPEntry list");
        }
        return result;
    }

    public static synchronized List<RequestorPoolEntry> loadRequestorPools() {
        ArrayList<RequestorPoolEntry> result = new ArrayList<RequestorPoolEntry>();
        try {
            List entries = ldapEntryManager.findEntries(LDAPUtility.getDnForLDAPRequestorPoolEntry(null), LDAPRequestorPoolEntry.class, null);
            for (LDAPRequestorPoolEntry entry : entries) {
                result.add(entry.getEntry());
            }
        }
        catch (Exception ex) {
            log.error((Object)"Failed to load LDAP configuration RequestorPoolEntry list");
        }
        return result;
    }

    public static synchronized List<RequestorEntry> loadRequestors() {
        ArrayList<RequestorEntry> result = new ArrayList<RequestorEntry>();
        try {
            List entries = ldapEntryManager.findEntries(LDAPUtility.getDnForLDAPRequestorEntry(null), LDAPRequestorEntry.class, null);
            for (LDAPRequestorEntry entry : entries) {
                result.add(entry.getEntry());
            }
        }
        catch (Exception ex) {
            log.error((Object)"Failed to load LDAP configuration RequestorEntry list");
        }
        return result;
    }

    public static synchronized List<ApplicationSelectorEntry> loadSelectors() {
        ArrayList<ApplicationSelectorEntry> result = new ArrayList<ApplicationSelectorEntry>();
        try {
            List entries = ldapEntryManager.findEntries(LDAPUtility.getDnForLDAPApplicationSelectorEntry(null), LDAPApplicationSelectorEntry.class, null);
            for (LDAPApplicationSelectorEntry entry : entries) {
                result.add(entry.getEntry());
            }
        }
        catch (Exception ex) {
            log.error((Object)"Failed to load LDAP configuration ApplicationSelectorEntry list");
        }
        return result;
    }

    public static synchronized List<RequestorEntry> loadRequestorsForPool(String poolID) {
        ArrayList<RequestorEntry> result = new ArrayList<RequestorEntry>();
        try {
            List entries = ldapEntryManager.findEntries(LDAPUtility.getDnForLDAPRequestorEntry(null), LDAPRequestorEntry.class, null);
            for (LDAPRequestorEntry entry : entries) {
                if (!poolID.equalsIgnoreCase(entry.getEntry().getPoolID())) continue;
                result.add(entry.getEntry());
            }
        }
        catch (Exception ex) {
            log.error((Object)"Failed to load LDAP configuration RequestorEntry list");
        }
        return result;
    }

    public static String getDnForLdapIDPEntry(String inum) {
        String asimbaDn = LDAPUtility.getDnForAsimbaData();
        if (StringHelper.isEmpty((String)inum)) {
            return String.format("ou=idps,%s", asimbaDn);
        }
        return String.format("inum=%s,ou=idps,%s", inum, asimbaDn);
    }

    public static String getDnForLDAPApplicationSelectorEntry(String inum) {
        String asimbaDn = LDAPUtility.getDnForAsimbaData();
        if (StringHelper.isEmpty((String)inum)) {
            return String.format("ou=selectors,%s", asimbaDn);
        }
        return String.format("inum=%s,ou=selectors,%s", inum, asimbaDn);
    }

    public static String getDnForLDAPRequestorEntry(String inum) {
        String applianceDn = LDAPUtility.getDnForAsimbaData();
        if (StringHelper.isEmpty((String)inum)) {
            return String.format("ou=requestors,%s", applianceDn);
        }
        return String.format("inum=%s,ou=requestors,%s", inum, applianceDn);
    }

    public static String getDnForLDAPRequestorPoolEntry(String inum) {
        String asimbaDn = LDAPUtility.getDnForAsimbaData();
        if (StringHelper.isEmpty((String)inum)) {
            return String.format("ou=requestorpools,%s", asimbaDn);
        }
        return String.format("inum=%s,ou=requestorpools,%s", inum, asimbaDn);
    }

    public static String getDnForAsimbaAppliance() {
        return configurationEntryDN;
    }

    public static String getDnForAsimbaData() {
        try {
            LdapOxAsimbaConfiguration configuration = LDAPUtility.loadAsimbaConfiguration();
            String asimbaDn = configuration.getApplicationConfiguration().getOxasimba();
            log.info((Object)("oxasimba: " + asimbaDn));
            return asimbaDn;
        }
        catch (Exception e) {
            log.error((Object)"Failed to load AsimbaConfiguration from LDAP Appliance", (Throwable)e);
            return null;
        }
    }

    public static List<IDPEntry> searchIDPs(String pattern, int sizeLimit) throws Exception {
        String[] targetArray = new String[]{pattern};
        Filter idFilter = Filter.createSubstringFilter((String)uniqueIdentifier, null, (String[])targetArray, null);
        Filter friendlyNameFilter = Filter.createSubstringFilter((String)friendlyName, null, (String[])targetArray, null);
        Filter descriptionFilter = Filter.createSubstringFilter((String)description, null, (String[])targetArray, null);
        Filter inameFilter = Filter.createSubstringFilter((String)iname, null, (String[])targetArray, null);
        Filter searchFilter = Filter.createORFilter((Filter[])new Filter[]{idFilter, friendlyNameFilter, descriptionFilter, inameFilter});
        List entries = ldapEntryManager.findEntries(LDAPUtility.getDnForLdapIDPEntry(null), LdapIDPEntry.class, searchFilter, sizeLimit);
        ArrayList<IDPEntry> ret = new ArrayList<IDPEntry>();
        for (LdapIDPEntry entry : entries) {
            ret.add(entry.getEntry());
        }
        return ret;
    }

    public static List<ApplicationSelectorEntry> searchSelectors(String pattern, int sizeLimit) throws Exception {
        String[] targetArray = new String[]{pattern};
        Filter idFilter = Filter.createSubstringFilter((String)uniqueIdentifier, null, (String[])targetArray, null);
        Filter friendlyNameFilter = Filter.createSubstringFilter((String)friendlyName, null, (String[])targetArray, null);
        Filter descriptionFilter = Filter.createSubstringFilter((String)description, null, (String[])targetArray, null);
        Filter inameFilter = Filter.createSubstringFilter((String)iname, null, (String[])targetArray, null);
        Filter organizationIdFilter = Filter.createSubstringFilter((String)organizationId, null, (String[])targetArray, null);
        Filter searchFilter = Filter.createORFilter((Filter[])new Filter[]{idFilter, friendlyNameFilter, descriptionFilter, inameFilter, organizationIdFilter});
        List entries = ldapEntryManager.findEntries(LDAPUtility.getDnForLDAPApplicationSelectorEntry(null), LDAPApplicationSelectorEntry.class, searchFilter, sizeLimit);
        ArrayList<ApplicationSelectorEntry> ret = new ArrayList<ApplicationSelectorEntry>();
        for (LDAPApplicationSelectorEntry entry : entries) {
            ret.add(entry.getEntry());
        }
        return ret;
    }

    public static List<RequestorEntry> searchRequestors(String pattern, int sizeLimit) throws Exception {
        String[] targetArray = new String[]{pattern};
        Filter idFilter = Filter.createSubstringFilter((String)uniqueIdentifier, null, (String[])targetArray, null);
        Filter friendlyNameFilter = Filter.createSubstringFilter((String)friendlyName, null, (String[])targetArray, null);
        Filter descriptionFilter = Filter.createSubstringFilter((String)description, null, (String[])targetArray, null);
        Filter inameFilter = Filter.createSubstringFilter((String)iname, null, (String[])targetArray, null);
        Filter searchFilter = Filter.createORFilter((Filter[])new Filter[]{idFilter, friendlyNameFilter, descriptionFilter, inameFilter});
        List entries = ldapEntryManager.findEntries(LDAPUtility.getDnForLDAPRequestorEntry(null), LDAPRequestorEntry.class, searchFilter, sizeLimit);
        ArrayList<RequestorEntry> ret = new ArrayList<RequestorEntry>();
        for (LDAPRequestorEntry entry : entries) {
            ret.add(entry.getEntry());
        }
        return ret;
    }

    public static List<RequestorPoolEntry> searchRequestorPools(String pattern, int sizeLimit) throws Exception {
        String[] targetArray = new String[]{pattern};
        Filter idFilter = Filter.createSubstringFilter((String)uniqueIdentifier, null, (String[])targetArray, null);
        Filter friendlyNameFilter = Filter.createSubstringFilter((String)friendlyName, null, (String[])targetArray, null);
        Filter descriptionFilter = Filter.createSubstringFilter((String)description, null, (String[])targetArray, null);
        Filter inameFilter = Filter.createSubstringFilter((String)iname, null, (String[])targetArray, null);
        Filter searchFilter = Filter.createORFilter((Filter[])new Filter[]{idFilter, friendlyNameFilter, descriptionFilter, inameFilter});
        List entries = ldapEntryManager.findEntries(LDAPUtility.getDnForLDAPRequestorPoolEntry(null), LDAPRequestorPoolEntry.class, searchFilter, sizeLimit);
        ArrayList<RequestorPoolEntry> ret = new ArrayList<RequestorPoolEntry>();
        for (LDAPRequestorPoolEntry entry : entries) {
            ret.add(entry.getEntry());
        }
        return ret;
    }
}

