/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.asimba.util.ldap.selector;

import org.gluu.asimba.util.ldap.selector.ApplicationSelectorEntry;
import org.gluu.site.ldap.persistence.annotation.LdapAttribute;
import org.gluu.site.ldap.persistence.annotation.LdapEntry;
import org.gluu.site.ldap.persistence.annotation.LdapJsonObject;
import org.gluu.site.ldap.persistence.annotation.LdapObjectClass;
import org.xdi.ldap.model.BaseEntry;

@LdapEntry(sortBy={"uniqueIdentifier"})
@LdapObjectClass(values={"top", "oxAsimbaSelector"})
public class LDAPApplicationSelectorEntry
extends BaseEntry {
    @LdapAttribute(ignoreDuringUpdate=true)
    private String inum;
    @LdapAttribute(name="uniqueIdentifier")
    private String id;
    @LdapAttribute
    private String organizationId;
    @LdapAttribute
    private String friendlyName;
    @LdapAttribute(name="oxAsimbaEntry")
    @LdapJsonObject
    private ApplicationSelectorEntry entry = new ApplicationSelectorEntry();

    public void setEntry(ApplicationSelectorEntry entry) {
        this.entry = entry;
        if (entry != null) {
            this.inum = entry.getInum();
            this.id = entry.getId();
            this.friendlyName = entry.getFriendlyName();
            this.organizationId = entry.getOrganizationId();
        }
    }

    public void setInum(String inum) {
        this.inum = inum;
        this.entry.setInum(inum);
    }

    public void setId(String id) {
        this.id = id;
        this.entry.setId(id);
    }

    public void setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        this.entry.setFriendlyName(friendlyName);
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
        this.entry.setOrganizationId(organizationId);
    }

    public void setUniqueIdentifier(String uniqueIdentifier) {
        this.setId(uniqueIdentifier);
    }

    public String getUniqueIdentifier() {
        return this.getId();
    }

    public String getInum() {
        return this.inum;
    }

    public String getId() {
        return this.id;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public ApplicationSelectorEntry getEntry() {
        return this.entry;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LDAPApplicationSelectorEntry)) {
            return false;
        }
        LDAPApplicationSelectorEntry other = (LDAPApplicationSelectorEntry)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$inum = this.getInum();
        String other$inum = other.getInum();
        if (this$inum == null ? other$inum != null : !this$inum.equals(other$inum)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$organizationId = this.getOrganizationId();
        String other$organizationId = other.getOrganizationId();
        if (this$organizationId == null ? other$organizationId != null : !this$organizationId.equals(other$organizationId)) {
            return false;
        }
        String this$friendlyName = this.getFriendlyName();
        String other$friendlyName = other.getFriendlyName();
        if (this$friendlyName == null ? other$friendlyName != null : !this$friendlyName.equals(other$friendlyName)) {
            return false;
        }
        ApplicationSelectorEntry this$entry = this.getEntry();
        ApplicationSelectorEntry other$entry = other.getEntry();
        return !(this$entry == null ? other$entry != null : !((Object)this$entry).equals(other$entry));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LDAPApplicationSelectorEntry;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $inum = this.getInum();
        result = result * 59 + ($inum == null ? 43 : $inum.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $organizationId = this.getOrganizationId();
        result = result * 59 + ($organizationId == null ? 43 : $organizationId.hashCode());
        String $friendlyName = this.getFriendlyName();
        result = result * 59 + ($friendlyName == null ? 43 : $friendlyName.hashCode());
        ApplicationSelectorEntry $entry = this.getEntry();
        result = result * 59 + ($entry == null ? 43 : ((Object)$entry).hashCode());
        return result;
    }

    public String toString() {
        return "LDAPApplicationSelectorEntry(inum=" + this.getInum() + ", id=" + this.getId() + ", organizationId=" + this.getOrganizationId() + ", friendlyName=" + this.getFriendlyName() + ", entry=" + this.getEntry() + ")";
    }
}

