/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.asimba.util.ldap;

import com.alfaariss.oa.OAException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gluu.site.ldap.LDAPConnectionProvider;
import org.gluu.site.ldap.OperationsFacade;
import org.gluu.site.ldap.persistence.LdapEntryManager;

public class LDAPUtility {
    private static final Log log = LogFactory.getLog(LDAPUtility.class);
    private static final String ASIMBA_LDAP_CONFIGURATION_FILENAME = "oxasimba-ldap.properties";

    public static String getLDAPConfigurationFilePath() {
        String tomcatHome = System.getProperty("catalina.home");
        if (tomcatHome == null) {
            log.error((Object)"Failed to load configuration from 'oxasimba-ldap.properties'. The environment variable catalina.home isn't defined");
            return null;
        }
        String confPath = System.getProperty("catalina.home") + File.separator + "conf" + File.separator + ASIMBA_LDAP_CONFIGURATION_FILENAME;
        log.info((Object)("Reading configuration from: " + confPath));
        return confPath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Properties getLDAPConfigurationProperties() throws OAException {
        String path = LDAPUtility.getLDAPConfigurationFilePath();
        if (path == null) {
            log.error((Object)"Failed to load configuration. path == null");
            return null;
        }
        try (FileInputStream input = new FileInputStream(path);){
            Properties result = new Properties();
            result.load(input);
            Properties properties = result;
            return properties;
        }
        catch (IOException e) {
            log.error((Object)("Failed to load configuration from path: " + path), (Throwable)e);
            throw new OAException(17);
        }
    }

    public static LdapEntryManager getLDAPEntryManager() throws OAException {
        try {
            Properties props = LDAPUtility.getLDAPConfigurationProperties();
            LDAPConnectionProvider provider = new LDAPConnectionProvider(props);
            OperationsFacade ops = new OperationsFacade(provider, null);
            return new LdapEntryManager(ops);
        }
        catch (Exception e) {
            log.error((Object)"cannot open LdapEntryManager", (Throwable)e);
            throw new OAException(17);
        }
    }
}

