/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.asimba.util.ldap;

import com.alfaariss.oa.OAException;
import com.alfaariss.oa.api.IComponent;
import com.alfaariss.oa.api.configuration.IConfigurationManager;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gluu.asimba.util.ldap.LDAPUtility;
import org.gluu.asimba.util.ldap.idp.LdapIDPEntry;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.w3c.dom.Element;

public class LDAPConfigurationLoader
implements IComponent {
    private static final Log _logger = LogFactory.getLog(LDAPConfigurationLoader.class);
    private List<LdapIDPEntry> idpEntries;

    public void loadConfiguration() throws OAException {
        LdapEntryManager ldapEntryManager = LDAPUtility.getLDAPEntryManager();
        try {
            LdapIDPEntry template = new LdapIDPEntry();
            this.idpEntries = ldapEntryManager.findEntries((Object)template);
            for (LdapIDPEntry ldapIDPEntry : this.idpEntries) {
                _logger.info((Object)("Loaded IDPEntry from LDAP: " + ldapIDPEntry.getId() + " : " + ldapIDPEntry.getFriendlyName()));
            }
        }
        catch (Exception e) {
            _logger.error((Object)"cannot load LDAP IDPs settings", (Throwable)e);
            throw new OAException(17);
        }
        finally {
            ldapEntryManager.destroy();
        }
    }

    public void start(IConfigurationManager oConfigurationManager, Element eConfig) throws OAException {
    }

    public void restart(Element eConfig) throws OAException {
    }

    public void stop() {
    }

    public List<LdapIDPEntry> getIdpEntries() {
        return this.idpEntries;
    }
}

