/*
 * Decompiled with CFR 0.152.
 */
package com.alfaariss.oa.sso.web.profile.web;

import com.alfaariss.oa.OAException;
import com.alfaariss.oa.UserEvent;
import com.alfaariss.oa.UserException;
import com.alfaariss.oa.api.IService;
import com.alfaariss.oa.api.authentication.IAuthenticationProfile;
import com.alfaariss.oa.api.configuration.IConfigurationManager;
import com.alfaariss.oa.api.logging.IAuthority;
import com.alfaariss.oa.api.persistence.PersistenceException;
import com.alfaariss.oa.api.requestor.IRequestor;
import com.alfaariss.oa.api.session.ISession;
import com.alfaariss.oa.api.session.SessionState;
import com.alfaariss.oa.api.sso.ISSOProfile;
import com.alfaariss.oa.api.tgt.ITGT;
import com.alfaariss.oa.engine.core.Engine;
import com.alfaariss.oa.engine.core.requestor.RequestorPool;
import com.alfaariss.oa.engine.core.server.Server;
import com.alfaariss.oa.sso.SSOException;
import com.alfaariss.oa.sso.SSOService;
import com.alfaariss.oa.sso.authentication.web.AuthenticationManager;
import com.alfaariss.oa.sso.authorization.web.PostAuthorizationManager;
import com.alfaariss.oa.sso.authorization.web.PreAuthorizationManager;
import com.alfaariss.oa.util.logging.SystemLogItem;
import com.alfaariss.oa.util.logging.UserEventLogItem;
import com.alfaariss.oa.util.validation.SessionValidator;
import com.alfaariss.oa.util.validation.TGTValidator;
import com.alfaariss.oa.util.web.CookieTool;
import com.alfaariss.oa.util.web.HttpUtils;
import com.alfaariss.oa.util.web.ResponseHeader;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.asimba.utility.web.RequestorHelper;
import org.w3c.dom.Element;

public class WebProfile
implements ISSOProfile,
IService,
IAuthority {
    private static final Log _systemLogger = LogFactory.getLog(WebProfile.class);
    private static final Log _eventLogger = LogFactory.getLog((String)"com.alfaariss.oa.EventLogger");
    public static final String PROFILE_ID = "web";
    public static final String AUTHN_PROFILES_NAME = "authenticationProfiles";
    public static final String REQUESTORS_ATTRIBUTE_NAME = "requestors";
    public static final String AUTHN_PROFILES_ATTRIBUTE_NAME = "authnProfiles";
    private static final long serialVersionUID = 216120079251404994L;
    private static final String AUTHORITY_NAME = "WebSSO";
    private static final String DEFAULT_JSP_SELECTION = "/ui/sso/select.jsp";
    private static final String PROPERTY_WEB_ALWAYS_SHOW_SELECT = ".always_show_select_form";
    public static final String PARAMETER_LANGUAGE_LOCALE = "locale_language";
    protected static final String TGT_ATTR_TGTPROFILE = "TGT-Profile";
    private boolean _bStarted;
    private String _sSelectionPath;
    private boolean _bShowAlways;
    private SSOService _ssoService;
    private PreAuthorizationManager _preAuthorizationManager;
    private PostAuthorizationManager _postAuthorizationManager = new PostAuthorizationManager();
    private AuthenticationManager _authenticationManager;
    private IConfigurationManager _configurationManager;
    private String _sGlobalPreAuthzProfileID;
    private String _sGlobalPostAuthzProfileID;
    private List<ResponseHeader> _listHeaders;
    private CookieTool _cookieTool;
    protected boolean _bTGTProfileEnabled = false;

    public WebProfile(AuthenticationManager authenticationManager) {
        this._preAuthorizationManager = new PreAuthorizationManager();
        this._authenticationManager = authenticationManager;
        this._ssoService = new SSOService();
        this._bStarted = false;
        this._sSelectionPath = null;
        this._cookieTool = null;
        this._listHeaders = new Vector<ResponseHeader>();
    }

    public String getID() {
        return PROFILE_ID;
    }

    public void init(ServletContext context, IConfigurationManager configurationManager, Element eParent, Element eSpecific) throws OAException {
        if (configurationManager == null) {
            throw new IllegalArgumentException("Supplied ConfigurationManager is empty");
        }
        this._configurationManager = configurationManager;
        Engine oEngine = Engine.getInstance();
        Server oServer = oEngine.getServer();
        if (oServer == null) {
            _systemLogger.error((Object)"Server object could not be retrieved");
            throw new OAException(2);
        }
        this._sGlobalPreAuthzProfileID = oServer.getPreAuthorizationProfileID();
        this._sGlobalPostAuthzProfileID = oServer.getPostAuthorizationProfileID();
        this._ssoService.start(configurationManager, eParent);
        this.readDefaultConfiguration(eParent);
        this._cookieTool = new CookieTool(configurationManager, eParent);
        this.readHeadersConfiguration(eParent);
        Element ePreAuthorization = this._configurationManager.getSection(eParent, "preauthorization");
        if (ePreAuthorization == null) {
            _systemLogger.info((Object)"No preauthorization configuration found, pre authorization is disabled");
        } else {
            this._preAuthorizationManager.start(this._configurationManager, ePreAuthorization);
        }
        Element ePostAuthorization = this._configurationManager.getSection(eParent, "postauthorization");
        if (ePostAuthorization == null) {
            _systemLogger.info((Object)"No postauthorization configuration found, post authorization is disabled");
        } else {
            this._postAuthorizationManager.start(this._configurationManager, ePostAuthorization);
        }
        Element eAuthentication = this._configurationManager.getSection(eParent, "authentication");
        if (eAuthentication == null) {
            _systemLogger.error((Object)"No authentication configuration found");
            throw new OAException(17);
        }
        this.readShowAlwaysConfiguration(eAuthentication);
        Element elTGT = this._configurationManager.getSection(eParent, "tgt");
        if (elTGT != null) {
            this._bTGTProfileEnabled = this.establishOptionalBooleanAttribute(elTGT, "addprofile", "websso/tgt");
        }
        _systemLogger.info((Object)"WebSSO started [Localization; TGTProfile patches]");
        this._bStarted = true;
    }

    public String getAuthority() {
        return AUTHORITY_NAME;
    }

    public void service(HttpServletRequest oRequest, HttpServletResponse oResponse) throws OAException {
        block33: {
            ISession oSession = null;
            try {
                RequestorPool oRequestorPool;
                String sNewLocale;
                if (!this._bStarted) {
                    oResponse.sendError(503);
                    return;
                }
                HttpUtils.setDisableCachingHttpHeaders((HttpServletRequest)oRequest, (HttpServletResponse)oResponse);
                oSession = (ISession)oRequest.getAttribute("asid");
                if (oSession == null) {
                    String sId = oRequest.getParameter("asid");
                    if (sId != null) {
                        if (!SessionValidator.validateDefaultSessionId((String)sId)) {
                            _systemLogger.warn((Object)("Invalid session id in request: " + sId));
                            throw new UserException(UserEvent.REQUEST_INVALID);
                        }
                        oSession = this._ssoService.getSession(sId);
                    }
                    if (oSession == null) {
                        _systemLogger.debug((Object)"No valid session found");
                        this.handleStartPage(oRequest, oResponse);
                    }
                }
                if (oSession == null) break block33;
                if (oSession.isExpired()) {
                    throw new UserException(UserEvent.SESSION_EXPIRED);
                }
                if (oRequest.getParameter("cancel") != null) {
                    try {
                        oSession.setState(SessionState.USER_CANCELLED);
                        oSession.persist();
                        _eventLogger.info((Object)new UserEventLogItem(oSession, oRequest.getRemoteAddr(), UserEvent.USER_CANCELLED, (IAuthority)this, null));
                    }
                    catch (OAException e) {
                        _systemLogger.warn((Object)"Could not store session");
                        throw new SSOException(e.getCode(), (Throwable)e);
                    }
                }
                if (oRequest.getParameter(PARAMETER_LANGUAGE_LOCALE) != null && !(sNewLocale = oRequest.getParameter(PARAMETER_LANGUAGE_LOCALE)).equals("")) {
                    oSession.setLocale(new Locale(sNewLocale));
                    oSession.persist();
                    _systemLogger.info((Object)("User changed session 'locale_language' to " + sNewLocale));
                }
                if ((oRequestorPool = this._ssoService.getRequestorPool(oSession)) == null) {
                    _systemLogger.warn((Object)new SystemLogItem(oSession.getId(), 1, "Could not retrieve requestor pool from session"));
                    throw new SSOException(1);
                }
                switch (oSession.getState()) {
                    case SESSION_CREATED: {
                        List listAuthNProfiles = this._ssoService.getAllAuthNProfiles(oRequestorPool);
                        if (listAuthNProfiles.isEmpty()) {
                            _systemLogger.warn((Object)("Not one enabled authentication profile for requestor pool: " + oRequestorPool.getID()));
                            throw new SSOException(1);
                        }
                        oSession.setAuthNProfiles(listAuthNProfiles);
                        oSession.setState(SessionState.PRE_AUTHZ_IN_PROGRESS);
                        if (oRequestorPool.isForcedAuthenticate()) {
                            oSession.setForcedAuthentication(true);
                            _systemLogger.debug((Object)"Forced by requestor pool: Force authentication");
                        }
                        this.handlePreAuthorization(oRequest, oResponse, oSession, oRequestorPool);
                        break;
                    }
                    case PRE_AUTHZ_IN_PROGRESS: {
                        this.handlePreAuthorization(oRequest, oResponse, oSession, oRequestorPool);
                        break;
                    }
                    case PRE_AUTHZ_OK: {
                        this.checkTGT(oRequest, oResponse, oSession, oRequestorPool);
                        break;
                    }
                    case AUTHN_SELECTION_IN_PROGRESS: {
                        this.handleAuthenticationSelection(oRequest, oResponse, oSession, oRequestorPool);
                        break;
                    }
                    case AUTHN_SELECTION_OK: 
                    case AUTHN_IN_PROGRESS: {
                        this.handleAuthentication(oRequest, oResponse, oSession, oRequestorPool, oSession.getSelectedAuthNProfile());
                        break;
                    }
                    case POST_AUTHZ_IN_PROGRESS: {
                        this.handlePostAuthorization(oRequest, oResponse, oSession, oRequestorPool);
                        break;
                    }
                    default: {
                        _systemLogger.debug((Object)new SystemLogItem(oSession.getId(), 0, "Redirect back to Profile"));
                        oResponse.sendRedirect(oSession.getProfileURL());
                    }
                }
            }
            catch (UserException e) {
                if (oSession != null) {
                    _eventLogger.info((Object)new UserEventLogItem(oSession, oRequest.getRemoteAddr(), e.getEvent(), (IAuthority)this, null));
                } else {
                    _eventLogger.info((Object)new UserEventLogItem(null, null, null, e.getEvent(), null, oRequest.getRemoteAddr(), null, (IAuthority)this, null));
                }
                if (!oResponse.isCommitted()) {
                    try {
                        oResponse.sendError(400);
                    }
                    catch (IOException e1) {
                        _systemLogger.warn((Object)"Could not send response", (Throwable)e1);
                    }
                }
            }
            catch (SSOException e) {
                if (oSession != null) {
                    _eventLogger.info((Object)new UserEventLogItem(oSession, oRequest.getRemoteAddr(), UserEvent.INTERNAL_ERROR, (IAuthority)this, null));
                } else {
                    _eventLogger.info((Object)new UserEventLogItem(null, null, null, UserEvent.INTERNAL_ERROR, null, oRequest.getRemoteAddr(), null, (IAuthority)this, null));
                }
                this.handleError(oRequest, oResponse, oSession, e, e.getCode());
            }
            catch (OAException e) {
                this.handleError(oRequest, oResponse, oSession, e, e.getCode());
            }
            catch (Exception e) {
                this.handleError(oRequest, oResponse, oSession, e, 1);
            }
        }
    }

    public void destroy() {
        this._bStarted = false;
        this._cookieTool = null;
        if (this._ssoService != null) {
            this._ssoService.stop();
        }
        if (this._preAuthorizationManager != null) {
            this._preAuthorizationManager.stop();
        }
        if (this._postAuthorizationManager != null) {
            this._postAuthorizationManager.stop();
        }
        _systemLogger.info((Object)"WebSSO stopped");
    }

    private void handleError(HttpServletRequest oRequest, HttpServletResponse oResponse, ISession oSession, Throwable t, int iErrorCode) {
        if (oSession != null) {
            _systemLogger.error((Object)new SystemLogItem(oSession.getId(), iErrorCode, "Internal error while processing request"), t);
            try {
                IRequestor oRequestor;
                oRequest.setAttribute("sessionLocale", (Object)oSession.getLocale());
                oRequest.setAttribute("serverInfo", (Object)Engine.getInstance().getServer());
                String sRequestorID = oSession.getRequestorId();
                if (sRequestorID != null && (oRequestor = this._ssoService.getRequestor(oSession)) != null) {
                    oRequest.setAttribute("requestor", (Object)oRequestor);
                }
            }
            catch (Exception e) {
                _systemLogger.error((Object)"could not set request attributes", (Throwable)e);
            }
            oSession.expire();
            try {
                oSession.persist();
            }
            catch (PersistenceException e1) {
                _systemLogger.error((Object)"Could not persist session", (Throwable)e1);
            }
        } else {
            _systemLogger.error((Object)"Internal error while processing request", t);
        }
        if (!oResponse.isCommitted()) {
            try {
                oResponse.sendError(500);
            }
            catch (IOException e1) {
                _systemLogger.warn((Object)"Could not send response", (Throwable)e1);
            }
        }
    }

    private void readDefaultConfiguration(Element eConfig) throws OAException {
        assert (eConfig != null) : "Supplied config == null";
        this._sSelectionPath = DEFAULT_JSP_SELECTION;
        Element eView = this._configurationManager.getSection(eConfig, "view");
        if (eView == null) {
            _systemLogger.warn((Object)"No optional 'view' section configuration found, using default");
        } else {
            Element ePage = this._configurationManager.getSection(eView, "profile_selection");
            if (ePage == null) {
                _systemLogger.warn((Object)"No optional 'profile_selection' section found in 'view' section in configuration, using default");
            } else {
                this._sSelectionPath = this._configurationManager.getParam(ePage, "path");
                if (this._sSelectionPath == null || this._sSelectionPath.length() == 0) {
                    _systemLogger.error((Object)"No 'path' parameter in 'profile_selection' section in configuration");
                    throw new OAException(17);
                }
            }
        }
        _systemLogger.warn((Object)("Using profile selection JSP: " + this._sSelectionPath));
    }

    private void readShowAlwaysConfiguration(Element eAuthentication) throws OAException {
        assert (eAuthentication != null) : "Supplied authentication config element == null";
        this._bShowAlways = false;
        String sShowAllways = this._configurationManager.getParam(eAuthentication, "always_show_select_form");
        if (sShowAllways != null) {
            if ("true".equalsIgnoreCase(sShowAllways)) {
                this._bShowAlways = true;
            } else if (!"false".equalsIgnoreCase(sShowAllways)) {
                _systemLogger.error((Object)("Invalid value for 'always_show_select_form' item found in configuration: " + sShowAllways));
                throw new OAException(17);
            }
            _systemLogger.info((Object)("Optional 'always_show_select_form' item is configured with value: " + this._bShowAlways));
        }
    }

    private boolean establishOptionalBooleanAttribute(Element elElement, String sAttributeName, String sParentElementName) throws OAException {
        boolean b = false;
        String s = this._configurationManager.getParam(elElement, sAttributeName);
        if (s != null) {
            if ("true".equalsIgnoreCase(s)) {
                b = true;
            } else if (!"false".equalsIgnoreCase(s)) {
                _systemLogger.error((Object)("Invalid value for optional @" + sAttributeName + "-attribute of " + sParentElementName + ": " + s));
                throw new OAException(17);
            }
            _systemLogger.info((Object)("Optional '" + sAttributeName + "' item is configured with value: " + b));
        }
        return b;
    }

    private void readHeadersConfiguration(Element eConfig) throws OAException {
        assert (eConfig != null) : "Supplied config == null";
        this._listHeaders.clear();
        Element eHeaders = this._configurationManager.getSection(eConfig, "headers");
        if (eHeaders != null) {
            Element eHeader = this._configurationManager.getSection(eHeaders, "header");
            while (eHeader != null) {
                ResponseHeader header = new ResponseHeader(this._configurationManager, eHeader);
                this._listHeaders.add(header);
                _systemLogger.info((Object)("Adding header: " + header.toString()));
                eHeader = this._configurationManager.getNextSection(eHeader);
            }
        }
    }

    private void handleStartPage(HttpServletRequest oRequest, HttpServletResponse oResponse) throws SSOException, IOException, ServletException {
        String sServletPath = oRequest.getServletPath();
        StringBuffer sbServletPath = new StringBuffer(sServletPath);
        if (!sServletPath.endsWith("/")) {
            sbServletPath.append("/");
        }
        sbServletPath.append("user");
        RequestDispatcher oDispatcher = oRequest.getRequestDispatcher(sbServletPath.toString());
        if (oDispatcher == null) {
            _systemLogger.fatal((Object)("Forward request not supported: " + sbServletPath.toString()));
            throw new SSOException(1);
        }
        oDispatcher.forward((ServletRequest)oRequest, (ServletResponse)oResponse);
    }

    private void handlePreAuthorization(HttpServletRequest oRequest, HttpServletResponse oResponse, ISession oSession, RequestorPool oRequestorPool) throws OAException, IOException, UserException {
        if (this._preAuthorizationManager.isEnabled()) {
            this._preAuthorizationManager.authorize(oRequest, oResponse, oSession, oRequestorPool);
            switch (oSession.getState()) {
                case PRE_AUTHZ_FAILED: {
                    try {
                        oSession.persist();
                    }
                    catch (OAException e) {
                        _systemLogger.warn((Object)"Could not persist session", (Throwable)e);
                        throw new SSOException(e.getCode(), (Throwable)e);
                    }
                    oResponse.sendRedirect(oSession.getProfileURL());
                    break;
                }
                case PRE_AUTHZ_OK: {
                    String sPoolPreAuthProfileID;
                    StringBuffer sbMessage = new StringBuffer();
                    if (this._sGlobalPreAuthzProfileID != null) {
                        sbMessage.append(this._sGlobalPreAuthzProfileID);
                    }
                    if ((sPoolPreAuthProfileID = oRequestorPool.getPreAuthorizationProfileID()) != null) {
                        if (this._sGlobalPreAuthzProfileID != null) {
                            sbMessage.append(",");
                        }
                        sbMessage.append(sPoolPreAuthProfileID);
                    }
                    _eventLogger.info((Object)new UserEventLogItem(oSession, oRequest.getRemoteAddr(), UserEvent.USER_PRE_AUTHORIZED, (IAuthority)this, sbMessage.toString()));
                    this.checkTGT(oRequest, oResponse, oSession, oRequestorPool);
                    break;
                }
                case PRE_AUTHZ_IN_PROGRESS: {
                    break;
                }
                case USER_CANCELLED: {
                    try {
                        oSession.persist();
                    }
                    catch (OAException e) {
                        _systemLogger.warn((Object)"Could not persist session", (Throwable)e);
                        throw new SSOException(e.getCode(), (Throwable)e);
                    }
                    oResponse.sendRedirect(oSession.getProfileURL());
                    break;
                }
                default: {
                    _systemLogger.error((Object)new SystemLogItem(oSession.getId(), 1, "Session state not supported during preautorization"));
                    throw new SSOException(1);
                }
            }
        }
        oSession.setState(SessionState.PRE_AUTHZ_OK);
        _eventLogger.info((Object)new UserEventLogItem(oSession, oRequest.getRemoteAddr(), UserEvent.USER_PRE_AUTHORIZED, (IAuthority)this, null));
        this.checkTGT(oRequest, oResponse, oSession, oRequestorPool);
    }

    private void handlePostAuthorization(HttpServletRequest oRequest, HttpServletResponse oResponse, ISession oSession, RequestorPool oRequestorPool) throws OAException, IOException {
        if (this._postAuthorizationManager.isEnabled()) {
            this._postAuthorizationManager.authorize(oRequest, oResponse, oSession, oRequestorPool);
            switch (oSession.getState()) {
                case POST_AUTHZ_FAILED: {
                    try {
                        oSession.persist();
                    }
                    catch (OAException e) {
                        _systemLogger.warn((Object)"Could not persist session", (Throwable)e);
                        throw new SSOException(e.getCode(), (Throwable)e);
                    }
                    oResponse.sendRedirect(oSession.getProfileURL());
                    break;
                }
                case POST_AUTHZ_OK: {
                    String sPoolPostAuthProfileID;
                    StringBuffer sbMessage = new StringBuffer();
                    if (this._sGlobalPostAuthzProfileID != null) {
                        sbMessage.append(this._sGlobalPostAuthzProfileID);
                    }
                    if ((sPoolPostAuthProfileID = oRequestorPool.getPostAuthorizationProfileID()) != null) {
                        if (this._sGlobalPostAuthzProfileID != null) {
                            sbMessage.append(",");
                        }
                        sbMessage.append(sPoolPostAuthProfileID);
                    }
                    _eventLogger.info((Object)new UserEventLogItem(oSession, oRequest.getRemoteAddr(), UserEvent.USER_POST_AUTHORIZED, (IAuthority)this, sbMessage.toString()));
                    this.finishAuthentication(oResponse, oSession, oRequestorPool);
                    break;
                }
                case POST_AUTHZ_IN_PROGRESS: {
                    break;
                }
                case USER_CANCELLED: {
                    try {
                        oSession.persist();
                    }
                    catch (OAException e) {
                        _systemLogger.warn((Object)"Could not persist session", (Throwable)e);
                        throw new SSOException(e.getCode(), (Throwable)e);
                    }
                    oResponse.sendRedirect(oSession.getProfileURL());
                    break;
                }
                default: {
                    _systemLogger.error((Object)new SystemLogItem(oSession.getId(), 1, "Session state not supported during postautorization"));
                    throw new SSOException(1);
                }
            }
        }
        _eventLogger.info((Object)new UserEventLogItem(oSession, oRequest.getRemoteAddr(), UserEvent.USER_POST_AUTHORIZED, (IAuthority)this, null));
        this.finishAuthentication(oResponse, oSession, oRequestorPool);
    }

    private void checkTGT(HttpServletRequest oRequest, HttpServletResponse oResponse, ISession oSession, RequestorPool oRequestorPool) throws SSOException, IOException, UserException {
        block15: {
            try {
                boolean bTGTSufficient = false;
                try {
                    String sTGTId = this._cookieTool.getCookieValue("oa_sso_id", oRequest);
                    if (sTGTId != null && !TGTValidator.validateDefaultTGTId((String)sTGTId)) {
                        _systemLogger.debug((Object)("Invalid request, tgt id invalid: " + sTGTId));
                        throw new UserException(UserEvent.REQUEST_INVALID);
                    }
                    boolean bAllowedTGTProfile = true;
                    if (this._bTGTProfileEnabled && sTGTId != null) {
                        String sProfileURL = RequestorHelper.entityHostFromRequestor((String)oSession.getProfileURL());
                        _systemLogger.debug((Object)("Checking whether a TGT is valid for profile " + sProfileURL));
                        ITGT oTGT = this._ssoService.getTGT(sTGTId);
                        if (oTGT != null) {
                            String sTGTProfile = (String)oTGT.getAttributes().get(WebProfile.class, TGT_ATTR_TGTPROFILE);
                            if (sTGTProfile == null) {
                                _systemLogger.debug((Object)("No TGT Profile with TGT: " + sTGTId));
                                throw new UserException(UserEvent.REQUEST_INVALID);
                            }
                            if (!sTGTProfile.equalsIgnoreCase(sProfileURL)) {
                                _systemLogger.debug((Object)("TGT was issued for profile " + sTGTProfile + "; but request is for profile " + sProfileURL + ". TGT is ignored for this request."));
                                bAllowedTGTProfile = false;
                            }
                        }
                    }
                    if (!this._bTGTProfileEnabled || this._bTGTProfileEnabled && bAllowedTGTProfile) {
                        bTGTSufficient = this._ssoService.checkSingleSignon(oSession, sTGTId, oRequestorPool);
                    }
                }
                catch (UserException e) {
                    _eventLogger.info((Object)new UserEventLogItem(oSession, oRequest.getRemoteAddr(), e.getEvent(), (IAuthority)this, null));
                    this._cookieTool.removeCookie("oa_sso_id", oRequest, oResponse);
                }
                if (bTGTSufficient) {
                    _eventLogger.info((Object)new UserEventLogItem(oSession, oRequest.getRemoteAddr(), UserEvent.USER_AUTHENTICATED, (IAuthority)this, "TGT"));
                    oSession.setState(SessionState.POST_AUTHZ_IN_PROGRESS);
                    this._ssoService.gatherAttributes(oSession);
                    this.handlePostAuthorization(oRequest, oResponse, oSession, oRequestorPool);
                    break block15;
                }
                if (oSession.isPassive()) {
                    oSession.setState(SessionState.PASSIVE_FAILED);
                    try {
                        oSession.persist();
                    }
                    catch (OAException e) {
                        _systemLogger.warn((Object)"Could not persist session", (Throwable)e);
                        throw new SSOException(e.getCode(), (Throwable)e);
                    }
                    oResponse.sendRedirect(oSession.getProfileURL());
                    break block15;
                }
                oSession.setState(SessionState.AUTHN_SELECTION_IN_PROGRESS);
                _eventLogger.info((Object)new UserEventLogItem(oSession, oRequest.getRemoteAddr(), UserEvent.TGT_NOT_SUFFICIENT, (IAuthority)this, null));
                this.handleAuthenticationSelection(oRequest, oResponse, oSession, oRequestorPool);
            }
            catch (SSOException e) {
                throw e;
            }
            catch (OAException e) {
                _systemLogger.warn((Object)"Could not check TGT", (Throwable)e);
                throw new SSOException(e.getCode(), (Throwable)e);
            }
        }
    }

    private void handleAuthenticationSelection(HttpServletRequest oRequest, HttpServletResponse oResponse, ISession oSession, RequestorPool oRequestorPool) throws SSOException, UserException {
        block9: {
            try {
                IRequestor requestor = this._ssoService.getRequestor(oSession.getRequestorId());
                IAuthenticationProfile oSelectedProfile = this._ssoService.getSelectedAuthNProfile(oSession, oRequest.getParameter("profile"), this.doShowAlways(oRequestorPool, requestor));
                if (oSelectedProfile != null) {
                    if (oSession.getState() == SessionState.AUTHN_NOT_SUPPORTED) {
                        oRequest.setAttribute("userEvent", (Object)UserEvent.AUTHN_METHOD_NOT_SUPPORTED);
                    }
                    oSession.setState(SessionState.AUTHN_SELECTION_OK);
                    _eventLogger.info((Object)new UserEventLogItem(oSession, oRequest.getRemoteAddr(), UserEvent.AUTHN_PROFILE_SELECTED, (IAuthority)this, null));
                    this.handleAuthentication(oRequest, oResponse, oSession, oRequestorPool, oSelectedProfile);
                    break block9;
                }
                if (oSession.getAuthNProfiles().isEmpty()) {
                    oSession.setState(SessionState.AUTHN_SELECTION_FAILED);
                    _systemLogger.error((Object)("No allowed authentication profiles available for session: " + oSession.getId()));
                    try {
                        oSession.persist();
                    }
                    catch (OAException e) {
                        _systemLogger.warn((Object)"Could not persists session", (Throwable)e);
                        throw new SSOException(e.getCode(), (Throwable)e);
                    }
                    _eventLogger.info((Object)new UserEventLogItem(oSession, oRequest.getRemoteAddr(), UserEvent.AUTHN_PROFILE_NOT_AVAILABLE, (IAuthority)this, oRequestorPool.getID()));
                    oResponse.sendRedirect(oSession.getProfileURL());
                    break block9;
                }
                this.showSelectPage(oRequest, oResponse, oSession);
            }
            catch (UserException e) {
                throw e;
            }
            catch (SSOException e) {
                throw e;
            }
            catch (Exception e) {
                _systemLogger.error((Object)"Internal error during authN profile selection", (Throwable)e);
                throw new SSOException(1);
            }
        }
    }

    private void showSelectPage(HttpServletRequest oRequest, HttpServletResponse oResponse, ISession oSession) throws SSOException {
        try {
            if (oSession.getState() == SessionState.AUTHN_NOT_SUPPORTED) {
                oRequest.setAttribute("userEvent", (Object)UserEvent.AUTHN_METHOD_NOT_SUPPORTED);
            }
            oSession.setState(SessionState.AUTHN_SELECTION_IN_PROGRESS);
            oSession.persist();
            oRequest.setAttribute("requestor", (Object)this._ssoService.getRequestor(oSession));
            oRequest.setAttribute(AUTHN_PROFILES_NAME, (Object)oSession.getAuthNProfiles());
            oRequest.setAttribute("asid", (Object)oSession.getId());
            oRequest.setAttribute("sessionLocale", (Object)oSession.getLocale());
            oRequest.setAttribute("serverInfo", (Object)Engine.getInstance().getServer());
            RequestDispatcher oDispatcher = oRequest.getRequestDispatcher(this._sSelectionPath);
            if (oDispatcher == null) {
                _systemLogger.fatal((Object)new SystemLogItem(oSession.getId(), 1, "Forward request not supported"));
                throw new SSOException(1);
            }
            oDispatcher.forward((ServletRequest)oRequest, (ServletResponse)oResponse);
        }
        catch (SSOException e) {
            throw e;
        }
        catch (OAException e) {
            throw new SSOException(e.getCode(), (Throwable)e);
        }
        catch (Exception e) {
            _systemLogger.fatal((Object)("Could not forward request with session: " + oSession.getId()), (Throwable)e);
            throw new SSOException(1);
        }
    }

    private void handleAuthentication(HttpServletRequest oRequest, HttpServletResponse oResponse, ISession oSession, RequestorPool oRequestorPool, IAuthenticationProfile oSelectedAuthNProfile) throws OAException, IOException, UserException {
        this._authenticationManager.authenticate(oSelectedAuthNProfile, oRequest, oResponse, oSession);
        switch (oSession.getState()) {
            case AUTHN_OK: {
                oSession.setState(SessionState.POST_AUTHZ_IN_PROGRESS);
                if (oSession.getUser() == null) {
                    _systemLogger.error((Object)new SystemLogItem(oSession.getId(), 1, "No user added during authentication, invalid configuration"));
                    throw new SSOException(1);
                }
                ITGT oTGT = this._ssoService.handleSingleSignon(oSession);
                if (oTGT != null) {
                    Cookie cTGT;
                    String sProfileID = RequestorHelper.entityHostFromRequestor((String)oSession.getProfileURL());
                    if (this._bTGTProfileEnabled) {
                        cTGT = this._cookieTool.createCookie("oa_sso_id", oTGT.getId(), "profiles/" + sProfileID, oRequest);
                        oTGT.getAttributes().put(WebProfile.class, TGT_ATTR_TGTPROFILE, (Object)sProfileID);
                        oTGT.persist();
                    } else {
                        cTGT = this._cookieTool.createCookie("oa_sso_id", oTGT.getId(), oRequest);
                    }
                    oResponse.addCookie(cTGT);
                    this.addHeaders(oResponse);
                }
                try {
                    oSession.persist();
                }
                catch (OAException e) {
                    _systemLogger.warn((Object)"Could not persist session", (Throwable)e);
                    throw new SSOException(e.getCode(), (Throwable)e);
                }
                _eventLogger.info((Object)new UserEventLogItem(oSession, oRequest.getRemoteAddr(), UserEvent.USER_AUTHENTICATED, (IAuthority)this, oSelectedAuthNProfile.getID()));
                this._ssoService.gatherAttributes(oSession);
                this.handlePostAuthorization(oRequest, oResponse, oSession, oRequestorPool);
                break;
            }
            case AUTHN_NOT_SUPPORTED: {
                List listProfiles = oSession.getAuthNProfiles();
                listProfiles.remove(oSelectedAuthNProfile);
                oSession.setAuthNProfiles(listProfiles);
                this.handleAuthenticationSelection(oRequest, oResponse, oSession, oRequestorPool);
                break;
            }
            case USER_CANCELLED: 
            case AUTHN_FAILED: 
            case USER_BLOCKED: 
            case USER_UNKNOWN: {
                try {
                    oSession.persist();
                }
                catch (OAException e) {
                    _systemLogger.warn((Object)"Could not persist session", (Throwable)e);
                    throw new SSOException(e.getCode(), (Throwable)e);
                }
                oResponse.sendRedirect(oSession.getProfileURL());
                break;
            }
            case AUTHN_IN_PROGRESS: {
                break;
            }
            default: {
                _systemLogger.fatal((Object)new SystemLogItem(oSession.getId(), 1, "Session state not supported during authentication"));
                throw new SSOException(1);
            }
        }
    }

    private void addHeaders(HttpServletResponse response) {
        for (int i = 0; i < this._listHeaders.size(); ++i) {
            ResponseHeader header = this._listHeaders.get(i);
            response.addHeader(header.getName(), header.getValue());
        }
    }

    private void finishAuthentication(HttpServletResponse response, ISession session, RequestorPool pool) throws OAException, IOException {
        this._ssoService.performAttributeReleasePolicy(session, pool.getAttributeReleasePolicyID());
        session.setState(SessionState.AUTHN_OK);
        session.persist();
        response.sendRedirect(session.getProfileURL());
    }

    private boolean doShowAlways(RequestorPool pool, IRequestor requestor) {
        StringBuffer sbDebug;
        String propertyName = "web.always_show_select_form";
        String value = (String)requestor.getProperty(propertyName);
        if (value != null) {
            if ("TRUE".equalsIgnoreCase(value)) {
                return true;
            }
            if ("FALSE".equalsIgnoreCase(value)) {
                return false;
            }
            sbDebug = new StringBuffer("Invalid requestor specific '");
            sbDebug.append(propertyName);
            sbDebug.append("' property found for requestor with ID '");
            sbDebug.append(requestor.getID());
            sbDebug.append("': ");
            sbDebug.append(value);
            _systemLogger.error((Object)sbDebug.toString());
        } else {
            sbDebug = new StringBuffer("No (optional) requestor specific '");
            sbDebug.append(propertyName);
            sbDebug.append("' property found for requestor with ID: ");
            sbDebug.append(requestor.getID());
            _systemLogger.debug((Object)sbDebug.toString());
        }
        value = (String)pool.getProperty(propertyName);
        if (value != null) {
            if ("TRUE".equalsIgnoreCase(value)) {
                return true;
            }
            if ("FALSE".equalsIgnoreCase(value)) {
                return false;
            }
            sbDebug = new StringBuffer("Invalid requestorpool specific '");
            sbDebug.append(propertyName);
            sbDebug.append("' property found for requestorpool with ID '");
            sbDebug.append(pool.getID());
            sbDebug.append("': ");
            sbDebug.append(value);
            _systemLogger.error((Object)sbDebug.toString());
        } else {
            sbDebug = new StringBuffer("No (optional) requestorpool specific '");
            sbDebug.append(propertyName);
            sbDebug.append("' property found for requestorpool with ID: ");
            sbDebug.append(pool.getID());
            _systemLogger.debug((Object)sbDebug.toString());
        }
        return this._bShowAlways;
    }
}

