/*
 * Decompiled with CFR 0.152.
 */
package com.alfaariss.oa.sso.web.profile.user;

import com.alfaariss.oa.OAException;
import com.alfaariss.oa.RequestorEvent;
import com.alfaariss.oa.UserEvent;
import com.alfaariss.oa.UserException;
import com.alfaariss.oa.api.IService;
import com.alfaariss.oa.api.attribute.IAttributes;
import com.alfaariss.oa.api.attribute.ISessionAttributes;
import com.alfaariss.oa.api.authentication.IAuthenticationProfile;
import com.alfaariss.oa.api.configuration.IConfigurationManager;
import com.alfaariss.oa.api.logging.IAuthority;
import com.alfaariss.oa.api.requestor.IRequestor;
import com.alfaariss.oa.api.session.ISession;
import com.alfaariss.oa.api.session.SessionState;
import com.alfaariss.oa.api.sso.ISSOProfile;
import com.alfaariss.oa.api.tgt.ITGT;
import com.alfaariss.oa.api.tgt.TGTEventError;
import com.alfaariss.oa.engine.core.Engine;
import com.alfaariss.oa.engine.core.authentication.AuthenticationProfile;
import com.alfaariss.oa.engine.core.authentication.factory.IAuthenticationProfileFactory;
import com.alfaariss.oa.engine.core.requestor.RequestorPool;
import com.alfaariss.oa.engine.core.requestor.factory.IRequestorPoolFactory;
import com.alfaariss.oa.engine.core.session.factory.ISessionFactory;
import com.alfaariss.oa.engine.core.tgt.factory.ITGTFactory;
import com.alfaariss.oa.sso.web.profile.logout.LogoutState;
import com.alfaariss.oa.sso.web.profile.user.Errors;
import com.alfaariss.oa.sso.web.profile.user.info.IAttribute;
import com.alfaariss.oa.sso.web.profile.user.info.UserAttribute;
import com.alfaariss.oa.sso.web.profile.user.info.UserInfo;
import com.alfaariss.oa.util.logging.RequestorEventLogItem;
import com.alfaariss.oa.util.logging.UserEventLogItem;
import com.alfaariss.oa.util.validation.SessionValidator;
import com.alfaariss.oa.util.validation.TGTValidator;
import com.alfaariss.oa.util.web.CookieTool;
import com.alfaariss.oa.util.web.HttpUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class UserProfile
implements ISSOProfile,
IService,
IAuthority {
    public static final String PROFILE_ID = "user";
    private static final String AUTHORITY_NAME = "UserProfile";
    private static final String JSP_AUTHN_ENABLED = "authnEnabled";
    private static final String TARGET_AUTHN = "authn";
    private static final String TARGET_LOGOUT = "logout";
    private static final String DEFAULT_JSP_INDEX = "/ui/sso/user/index.jsp";
    private static final String DEFAULT_REQUESTOR_ID = "userpage";
    private static Log _logger;
    private static Log _eventLogger;
    private ITGTFactory<?> _tgtFactory;
    private ISessionFactory<?> _sessionFactory;
    private IRequestorPoolFactory _requestorPoolFactory;
    private IAuthenticationProfileFactory _authenticationProfileFactory;
    private CookieTool _cookieTool;
    private String _sRedirectURL;
    private String _sJSPUserIndex;
    private String _sUserPageRequestorId;
    private boolean _bAuthNEnabled;

    public UserProfile() {
        _logger = LogFactory.getLog(UserProfile.class);
        _eventLogger = LogFactory.getLog((String)"com.alfaariss.oa.EventLogger");
        this._cookieTool = null;
        this._sJSPUserIndex = null;
        this._sUserPageRequestorId = null;
        this._sRedirectURL = null;
        this._bAuthNEnabled = true;
    }

    public void destroy() {
        this._sJSPUserIndex = null;
        this._sUserPageRequestorId = null;
        this._sRedirectURL = null;
        this._cookieTool = null;
        this._bAuthNEnabled = true;
    }

    public String getID() {
        return PROFILE_ID;
    }

    public void init(ServletContext context, IConfigurationManager configurationManager, Element eParent, Element eSpecific) throws OAException {
        Engine engine = Engine.getInstance();
        this._tgtFactory = engine.getTGTFactory();
        this._sessionFactory = engine.getSessionFactory();
        this._requestorPoolFactory = engine.getRequestorPoolFactory();
        this._authenticationProfileFactory = engine.getAuthenticationProfileFactory();
        this._cookieTool = new CookieTool(configurationManager, eParent);
        this.readConfigRedirectURL(configurationManager, eParent);
        Element eUserPage = configurationManager.getSection(eParent, DEFAULT_REQUESTOR_ID);
        if (eUserPage == null) {
            _logger.warn((Object)"No 'userpage' section available in configuration, using defaults");
            this._sJSPUserIndex = DEFAULT_JSP_INDEX;
            this._sUserPageRequestorId = DEFAULT_REQUESTOR_ID;
            this._sRedirectURL = null;
            this._bAuthNEnabled = this.isSSOEnabledInWebSSO(configurationManager, eParent);
            if (!this._bAuthNEnabled) {
                _logger.warn((Object)"Single Sign-On is disabled; Default setting is set to disabled for authentication within the user page");
            }
        } else {
            this.readConfig(configurationManager, eParent, eUserPage);
        }
        _logger.info((Object)"Started User Profile: user");
    }

    public void service(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws OAException {
        ISession session = null;
        try {
            String sTarget;
            String sId;
            HttpUtils.setDisableCachingHttpHeaders((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse);
            session = (ISession)servletRequest.getAttribute("asid");
            if (session == null && (sId = servletRequest.getParameter("asid")) != null) {
                if (!SessionValidator.validateDefaultSessionId((String)sId)) {
                    _logger.warn((Object)("Invalid session id in request: " + sId));
                    throw new UserException(UserEvent.REQUEST_INVALID);
                }
                session = this._sessionFactory.retrieve((Object)sId);
            }
            if ((sTarget = this.resolveTarget(servletRequest)) != null) {
                if (sTarget.equalsIgnoreCase(TARGET_AUTHN) && this._bAuthNEnabled) {
                    _logger.debug((Object)("Performing 'authn' request sent from IP: " + servletRequest.getRemoteAddr()));
                    this.processAuthN(servletRequest, servletResponse, session);
                    return;
                }
                if (sTarget.equalsIgnoreCase(TARGET_LOGOUT)) {
                    _logger.debug((Object)("Performing 'logout' request sent from IP: " + servletRequest.getRemoteAddr()));
                    this.processLogout(servletRequest, servletResponse, session);
                    return;
                }
            }
            _logger.debug((Object)("Performing 'info' request sent from IP: " + servletRequest.getRemoteAddr()));
            this.processDefault(servletRequest, servletResponse, session);
        }
        catch (UserException e) {
            try {
                if (!servletResponse.isCommitted()) {
                    servletResponse.sendError(400);
                }
            }
            catch (IOException e1) {
                _logger.debug((Object)"Could not respond", (Throwable)e1);
                throw new OAException(1);
            }
        }
        catch (OAException e) {
            if (session != null) {
                _eventLogger.info((Object)new RequestorEventLogItem(session, servletRequest.getRemoteAddr(), RequestorEvent.INTERNAL_ERROR, (IAuthority)this, null));
            } else {
                _eventLogger.info((Object)new RequestorEventLogItem(null, null, null, RequestorEvent.INTERNAL_ERROR, null, servletRequest.getRemoteAddr(), null, (IAuthority)this, null));
            }
            throw e;
        }
        catch (Exception e) {
            if (session != null) {
                _eventLogger.info((Object)new RequestorEventLogItem(session, servletRequest.getRemoteAddr(), RequestorEvent.INTERNAL_ERROR, (IAuthority)this, null));
            } else {
                _eventLogger.info((Object)new RequestorEventLogItem(null, null, null, RequestorEvent.INTERNAL_ERROR, null, servletRequest.getRemoteAddr(), null, (IAuthority)this, null));
            }
            _logger.fatal((Object)"Internal error during request processing", (Throwable)e);
            throw new OAException(1);
        }
    }

    public String getAuthority() {
        return AUTHORITY_NAME;
    }

    private void readConfigRedirectURL(IConfigurationManager configurationManager, Element config) throws OAException {
        this._sRedirectURL = configurationManager.getParam(config, "redirect_url");
        if (this._sRedirectURL == null) {
            _logger.info((Object)"No optional 'redirect_url' parameter found in configuration");
        } else {
            if (!this._sRedirectURL.endsWith("/")) {
                this._sRedirectURL = this._sRedirectURL + "/";
            }
            this._sRedirectURL = this._sRedirectURL + PROFILE_ID;
            try {
                new URL(this._sRedirectURL);
            }
            catch (MalformedURLException e) {
                _logger.error((Object)("The configured 'redirect_url' parameter isn't a valid URL: " + this._sRedirectURL), (Throwable)e);
                throw new OAException(1);
            }
            _logger.info((Object)("Using configured 'redirect_url' parameter: " + this._sRedirectURL));
        }
    }

    private void readConfig(IConfigurationManager configurationManager, Element eParent, Element config) throws OAException {
        Element eAuthN;
        Element eJSP = configurationManager.getSection(config, "jsp");
        if (eJSP == null) {
            _logger.warn((Object)"No optional 'jsp' section found in 'userpage' section in configuration; using default");
            this._sJSPUserIndex = DEFAULT_JSP_INDEX;
        } else {
            this._sJSPUserIndex = configurationManager.getParam(eJSP, "path");
            if (this._sJSPUserIndex == null) {
                _logger.error((Object)"No 'path' parameter found in 'jsp' section in configuration");
                throw new OAException(17);
            }
        }
        _logger.info((Object)("Using user info jsp location: " + this._sJSPUserIndex));
        this._sUserPageRequestorId = configurationManager.getParam(config, "requestor");
        if (this._sUserPageRequestorId == null) {
            this._sUserPageRequestorId = DEFAULT_REQUESTOR_ID;
            _logger.warn((Object)"No optional 'requestor' parameter found in 'userpage' section in configuration");
        }
        _logger.info((Object)("Userpage will use requestor id: " + this._sUserPageRequestorId));
        this._bAuthNEnabled = this.isSSOEnabledInWebSSO(configurationManager, eParent);
        if (!this._bAuthNEnabled) {
            _logger.warn((Object)"Single Sign-On is disabled; Default setting is set to disabled for authentication within the user page");
        }
        if ((eAuthN = configurationManager.getSection(config, TARGET_AUTHN)) == null) {
            _logger.warn((Object)("No optional 'authn' section found in 'userpage' section in configuration; using authentication enabled: " + this._bAuthNEnabled));
        } else {
            String sEnabled = configurationManager.getParam(eAuthN, "enabled");
            if (sEnabled != null) {
                if (sEnabled.equalsIgnoreCase("FALSE")) {
                    this._bAuthNEnabled = false;
                } else if (sEnabled.equalsIgnoreCase("TRUE")) {
                    this._bAuthNEnabled = true;
                } else {
                    _logger.error((Object)("Unknown value in 'enabled' configuration item: " + sEnabled));
                    throw new OAException(17);
                }
            }
        }
        _logger.info((Object)("Authentication for Userpage is: " + (this._bAuthNEnabled ? "enabled" : "disabled")));
        if (this._bAuthNEnabled) {
            IRequestor requestor = this._requestorPoolFactory.getRequestor(this._sUserPageRequestorId);
            if (requestor == null) {
                _logger.warn((Object)("Unknown 'requestor' configured; Requestor is not available in any requestorpool: " + this._sUserPageRequestorId));
            } else if (!requestor.isEnabled()) {
                _logger.warn((Object)("Disabled 'requestor' configured; Requestor is disabled: " + this._sUserPageRequestorId));
            }
        }
    }

    private boolean isSSOEnabledInWebSSO(IConfigurationManager configurationManager, Element config) throws OAException {
        String sSingleSignOn = configurationManager.getParam(config, "single_sign_on");
        if (sSingleSignOn != null) {
            if ("false".equalsIgnoreCase(sSingleSignOn)) {
                _logger.info((Object)"Single sign-on is disabled in the Web SSO");
                return false;
            }
            if (!"true".equalsIgnoreCase(sSingleSignOn)) {
                _logger.error((Object)("Invalid value for 'single_sign_on' item found in websso configuration: " + sSingleSignOn));
                throw new OAException(17);
            }
        }
        return true;
    }

    private String resolveTarget(HttpServletRequest servletRequest) {
        int iIndex;
        String sRequestURI = servletRequest.getRequestURI();
        if (!sRequestURI.endsWith("/")) {
            sRequestURI = sRequestURI + "/";
        }
        if ((iIndex = (sRequestURI = sRequestURI.toLowerCase()).indexOf("user/")) > -1) {
            String target;
            int iStart = iIndex + PROFILE_ID.length() + "/".length();
            if (sRequestURI.length() > iStart && (target = sRequestURI.substring(iStart, sRequestURI.length() - 1)).length() > 0) {
                return target;
            }
        }
        return null;
    }

    private void processDefault(HttpServletRequest servletRequest, HttpServletResponse servletResponse, ISession session) throws OAException {
        boolean bShowAuthNButton = this._bAuthNEnabled;
        Errors error = null;
        Vector<TGTEventError> warnings = new Vector<TGTEventError>();
        String sTGTCookie = this._cookieTool.getCookieValue("oa_sso_id", servletRequest);
        if (session == null) {
            ITGT oTgt = null;
            if (sTGTCookie != null) {
                if (TGTValidator.validateDefaultTGTId((String)sTGTCookie)) {
                    oTgt = this._tgtFactory.retrieve((Object)sTGTCookie);
                } else {
                    _logger.debug((Object)("TGT cookie contains invalid TGT ID: " + sTGTCookie));
                    this._cookieTool.removeCookie("oa_sso_id", servletRequest, servletResponse);
                    _logger.debug((Object)"TGT cookie removed");
                }
            }
            if (oTgt != null) {
                if (!oTgt.isExpired()) {
                    UserInfo userInfo;
                    if (bShowAuthNButton) {
                        if (this.verifyRequestorEnabled(oTgt)) {
                            _logger.debug((Object)"Valid TGT available, but no session available with user attributes");
                            this.processAuthN(servletRequest, servletResponse, null);
                            return;
                        }
                        bShowAuthNButton = false;
                    }
                    if ((userInfo = this.getUserInfo(session, oTgt)) != null) {
                        servletRequest.setAttribute("userInfo", (Object)userInfo);
                    }
                } else {
                    oTgt.persist();
                    error = Errors.NO_TGT;
                }
            } else {
                error = Errors.NO_TGT;
            }
        } else if (sTGTCookie == null && session.getState() != SessionState.USER_LOGOUT_SUCCESS) {
            ITGT tgt;
            String sTGTID = session.getTGTId();
            if (sTGTID != null && (tgt = this._tgtFactory.retrieve((Object)sTGTID)) != null && !tgt.isExpired()) {
                tgt.expire();
                tgt.persist();
                _logger.debug((Object)("Removed TGT: " + sTGTID));
            }
            switch (session.getState()) {
                case AUTHN_FAILED: 
                case USER_CANCELLED: 
                case POST_AUTHZ_FAILED: 
                case PRE_AUTHZ_FAILED: {
                    error = session.getState();
                    break;
                }
                case USER_BLOCKED: 
                case USER_UNKNOWN: {
                    error = SessionState.AUTHN_FAILED;
                    break;
                }
                default: {
                    error = Errors.NO_TGT;
                }
            }
            session.expire();
            session.persist();
            _logger.debug((Object)("Removed session: " + session.getId()));
        } else {
            switch (session.getState()) {
                case AUTHN_OK: {
                    UserInfo userInfo;
                    ITGT oTgt;
                    String sTGTId = session.getTGTId();
                    if (sTGTId != null && (oTgt = this._tgtFactory.retrieve((Object)sTGTId)) != null && !oTgt.isExpired() && (userInfo = this.getUserInfo(session, oTgt)) != null) {
                        servletRequest.setAttribute("userInfo", (Object)userInfo);
                        break;
                    }
                    error = Errors.NO_TGT;
                    session.expire();
                    session.persist();
                    break;
                }
                case USER_LOGOUT_PARTIAL: 
                case USER_LOGOUT_FAILED: {
                    ISessionAttributes sessionAttributes = session.getAttributes();
                    if (sessionAttributes.contains(LogoutState.class, "logoutResults") && sessionAttributes.contains(LogoutState.class, "logoutResults")) {
                        List totalWarnings = (List)sessionAttributes.get(LogoutState.class, "logoutResults");
                        for (int i = 0; i < totalWarnings.size(); ++i) {
                            TGTEventError eventError = (TGTEventError)totalWarnings.get(i);
                            if (eventError.getCode() == UserEvent.USER_LOGGED_OUT) continue;
                            warnings.add(eventError);
                        }
                    }
                    bShowAuthNButton = false;
                    error = session.getState();
                    _eventLogger.info((Object)new UserEventLogItem(session, servletRequest.getRemoteAddr(), UserEvent.USER_LOGOUT_FAILED, (IAuthority)this, null));
                    if (session.getId() == null) break;
                    session.expire();
                    session.persist();
                    break;
                }
                case USER_LOGOUT_SUCCESS: {
                    _eventLogger.info((Object)new UserEventLogItem(session, servletRequest.getRemoteAddr(), UserEvent.USER_LOGGED_OUT, (IAuthority)this, null));
                    bShowAuthNButton = false;
                    error = session.getState();
                    session.expire();
                    session.persist();
                    break;
                }
                default: {
                    error = session.getState();
                    _eventLogger.info((Object)new UserEventLogItem(session, servletRequest.getRemoteAddr(), UserEvent.INTERNAL_ERROR, (IAuthority)this, "invalid state"));
                    session.expire();
                    session.persist();
                }
            }
        }
        this.forwardToIndex(servletRequest, servletResponse, error, warnings, bShowAuthNButton, session);
    }

    private void processLogout(HttpServletRequest servletRequest, HttpServletResponse servletResponse, ISession session) throws OAException {
        try {
            String sTGTCookie = this._cookieTool.getCookieValue("oa_sso_id", servletRequest);
            if (sTGTCookie == null) {
                _logger.debug((Object)"No TGT cookie found, user already loggedout");
                if (session != null) {
                    session.expire();
                    session.persist();
                }
                this.processDefault(servletRequest, servletResponse, null);
                return;
            }
            String sServletPath = servletRequest.getServletPath();
            if (session == null) {
                String sRequestURL = this._sRedirectURL;
                if (sRequestURL == null) {
                    sRequestURL = servletRequest.getRequestURL().toString();
                    if (sRequestURL.endsWith("/")) {
                        sRequestURL = sRequestURL.substring(0, sRequestURL.length() - 1);
                    }
                    if (sRequestURL.endsWith("user/logout")) {
                        sRequestURL = sRequestURL.substring(0, sRequestURL.length() - TARGET_LOGOUT.length());
                    }
                }
                session = this._sessionFactory.createSession(this._sUserPageRequestorId);
                session.persist();
                StringBuilder sbProfileURL = new StringBuilder(sRequestURL);
                if (!sRequestURL.endsWith("/")) {
                    sbProfileURL.append("/");
                }
                sbProfileURL.append("?");
                sbProfileURL.append("asid");
                sbProfileURL.append("=");
                sbProfileURL.append(session.getId());
                session.setProfileURL(sbProfileURL.toString());
            }
            _logger.debug((Object)"Starting logout");
            session.persist();
            servletRequest.setAttribute("asid", (Object)session);
            StringBuilder sbForward = new StringBuilder(sServletPath);
            if (!sServletPath.endsWith("/")) {
                sbForward.append("/");
            }
            sbForward.append(TARGET_LOGOUT);
            RequestDispatcher oDispatcher = servletRequest.getRequestDispatcher(sbForward.toString());
            if (oDispatcher == null) {
                _logger.warn((Object)("There is no requestor dispatcher supported with name: " + sbForward.toString()));
                throw new OAException(1);
            }
            oDispatcher.forward((ServletRequest)servletRequest, (ServletResponse)servletResponse);
        }
        catch (OAException e) {
            throw e;
        }
        catch (Exception e) {
            _logger.fatal((Object)"Internal error during logout", (Throwable)e);
            throw new OAException(1);
        }
    }

    private void processAuthN(HttpServletRequest servletRequest, HttpServletResponse servletResponse, ISession session) throws OAException {
        try {
            if (session != null) {
                this.processDefault(servletRequest, servletResponse, session);
            } else {
                String sRequestURL = this._sRedirectURL;
                if (sRequestURL == null) {
                    sRequestURL = servletRequest.getRequestURL().toString();
                    if (sRequestURL.endsWith("/")) {
                        sRequestURL = sRequestURL.substring(0, sRequestURL.length() - 1);
                    }
                    if (sRequestURL.endsWith("user/authn")) {
                        sRequestURL = sRequestURL.substring(0, sRequestURL.length() - TARGET_AUTHN.length());
                    }
                }
                session = this._sessionFactory.createSession(this._sUserPageRequestorId);
                session.persist();
                StringBuilder sbProfileURL = new StringBuilder(sRequestURL);
                if (!sRequestURL.endsWith("/")) {
                    sbProfileURL.append("/");
                }
                sbProfileURL.append("?");
                sbProfileURL.append("asid");
                sbProfileURL.append("=");
                sbProfileURL.append(session.getId());
                session.setProfileURL(sbProfileURL.toString());
                servletRequest.setAttribute("asid", (Object)session);
                _logger.debug((Object)"Starting authentication");
                String sServletPath = servletRequest.getServletPath();
                RequestDispatcher oDispatcher = servletRequest.getRequestDispatcher(sServletPath);
                if (oDispatcher == null) {
                    _logger.warn((Object)("There is no requestor dispatcher supported with name: " + sServletPath));
                    throw new OAException(1);
                }
                oDispatcher.forward((ServletRequest)servletRequest, (ServletResponse)servletResponse);
            }
        }
        catch (OAException e) {
            throw e;
        }
        catch (Exception e) {
            _logger.fatal((Object)"Internal error during authentication", (Throwable)e);
            throw new OAException(1);
        }
    }

    private UserInfo getUserInfo(ISession session, ITGT oTgt) throws OAException {
        Vector<IAuthenticationProfile> listAuthNProfiles = new Vector<IAuthenticationProfile>();
        for (String sAuthNProfile : oTgt.getAuthNProfileIDs()) {
            AuthenticationProfile authNProfile = this._authenticationProfileFactory.getProfile(sAuthNProfile);
            if (authNProfile == null) continue;
            listAuthNProfiles.add((IAuthenticationProfile)authNProfile);
        }
        Vector<IRequestor> vRequestors = new Vector<IRequestor>();
        List listRequestorIDs = oTgt.getRequestorIDs();
        for (int i = listRequestorIDs.size() - 1; i >= 0; --i) {
            String sRequestorID = (String)listRequestorIDs.get(i);
            IRequestor oRequestor = this._requestorPoolFactory.getRequestor(sRequestorID);
            if (oRequestor == null || vRequestors.contains(oRequestor)) continue;
            vRequestors.add(oRequestor);
        }
        Vector<IAttribute> listAttributes = new Vector<IAttribute>();
        if (session != null) {
            IAttributes attributes = session.getUser().getAttributes();
            Enumeration enumAttributeNames = attributes.getNames();
            while (enumAttributeNames.hasMoreElements()) {
                String sName = (String)enumAttributeNames.nextElement();
                Object oValue = attributes.get(sName);
                listAttributes.add(new UserAttribute(sName, oValue));
            }
        }
        UserInfo info = new UserInfo(oTgt, listAuthNProfiles, vRequestors, listAttributes);
        return info;
    }

    private void forwardToIndex(HttpServletRequest servletRequest, HttpServletResponse servletResponse, Enum error, List<TGTEventError> warnings, boolean bShowAuthNButton, ISession session) throws OAException {
        try {
            if (bShowAuthNButton) {
                IRequestor requestor = this._requestorPoolFactory.getRequestor(this._sUserPageRequestorId);
                if (requestor == null || !requestor.isEnabled()) {
                    bShowAuthNButton = false;
                } else {
                    RequestorPool requestorPool = this._requestorPoolFactory.getRequestorPool(this._sUserPageRequestorId);
                    if (requestorPool == null || !requestorPool.isEnabled()) {
                        bShowAuthNButton = false;
                    }
                }
            }
            if (session != null) {
                servletRequest.setAttribute("asid", (Object)session.getId());
            }
            if (bShowAuthNButton) {
                servletRequest.setAttribute(JSP_AUTHN_ENABLED, (Object)bShowAuthNButton);
            }
            if (error != null) {
                servletRequest.setAttribute("userEvent", (Object)error);
            }
            if (warnings != null) {
                servletRequest.setAttribute("details", warnings);
            }
            servletRequest.setAttribute("serverInfo", (Object)Engine.getInstance().getServer());
            RequestDispatcher oDispatcher = servletRequest.getRequestDispatcher(this._sJSPUserIndex);
            if (oDispatcher == null) {
                _logger.fatal((Object)"Forward request not supported");
                throw new OAException(1);
            }
            oDispatcher.forward((ServletRequest)servletRequest, (ServletResponse)servletResponse);
        }
        catch (OAException e) {
            throw e;
        }
        catch (Exception e) {
            _logger.fatal((Object)"Internal error during jsp forward", (Throwable)e);
            throw new OAException(1);
        }
    }

    private boolean verifyRequestorEnabled(ITGT tgt) throws OAException {
        RequestorPool requestorpool = this._requestorPoolFactory.getRequestorPool(this._sUserPageRequestorId);
        if (requestorpool == null) {
            _logger.debug((Object)("Requestor not available in a requestorpool: " + this._sUserPageRequestorId));
            return false;
        }
        if (!requestorpool.isEnabled()) {
            _logger.debug((Object)("Requestorpool disabled: " + requestorpool.getID()));
            return false;
        }
        IRequestor requestor = this._requestorPoolFactory.getRequestor(this._sUserPageRequestorId);
        if (requestor == null) {
            _logger.debug((Object)("Requestor not available: " + this._sUserPageRequestorId));
            return false;
        }
        if (!requestor.isEnabled()) {
            _logger.debug((Object)("Requestor disabled: " + this._sUserPageRequestorId));
            return false;
        }
        List listAuthNPoolProfiles = requestorpool.getAuthenticationProfileIDs();
        if (listAuthNPoolProfiles.isEmpty()) {
            _logger.debug((Object)("Requestorpool doesn't contains authN profiles: " + requestorpool.getID()));
            return false;
        }
        boolean bAuthNProfileAvailable = false;
        List listAuthNTGTProfiles = tgt.getAuthNProfileIDs();
        for (String authNProfileIDs : listAuthNTGTProfiles) {
            if (!listAuthNPoolProfiles.contains(authNProfileIDs)) continue;
            bAuthNProfileAvailable = true;
            break;
        }
        if (!bAuthNProfileAvailable) {
            StringBuilder sbDebug = new StringBuilder("Requestorpool (");
            sbDebug.append(requestorpool.getID());
            sbDebug.append(") doesn't have any authN Profiles available that are available in TGT: ");
            sbDebug.append(tgt.getId());
            _logger.debug((Object)sbDebug.toString());
        }
        return bAuthNProfileAvailable;
    }
}

