/*
 * Decompiled with CFR 0.152.
 */
package com.alfaariss.oa.sso.web;

import com.alfaariss.oa.OAException;
import com.alfaariss.oa.SystemErrors;
import com.alfaariss.oa.api.IComponent;
import com.alfaariss.oa.api.IService;
import com.alfaariss.oa.api.configuration.IConfigurationManager;
import com.alfaariss.oa.api.sso.ISSOProfile;
import com.alfaariss.oa.engine.core.Engine;
import com.alfaariss.oa.sso.authentication.web.AuthenticationManager;
import com.alfaariss.oa.sso.web.profile.logout.LogoutProfile;
import com.alfaariss.oa.sso.web.profile.user.UserProfile;
import com.alfaariss.oa.sso.web.profile.web.WebProfile;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class WebSSOServlet
extends HttpServlet
implements IComponent {
    public static final String TGT_COOKIE_NAME = "oa_sso_id";
    private static final long serialVersionUID = -2883420193342476092L;
    private static Log _logger;
    private AuthenticationManager _authenticationManager;
    private ServletContext _context;
    private Engine _engine;
    private Map<String, ISSOProfile> _mapSSOProfiles;
    private WebProfile _defaultSSOProfile;

    public WebSSOServlet() {
        _logger = LogFactory.getLog(WebSSOServlet.class);
        this._engine = Engine.getInstance();
        this._authenticationManager = new AuthenticationManager();
        this._mapSSOProfiles = new Hashtable<String, ISSOProfile>();
    }

    public void init(ServletConfig oServletConfig) throws ServletException {
        try {
            this._context = oServletConfig.getServletContext();
            IConfigurationManager config = this._engine.getConfigurationManager();
            this.start(config, null);
            this._engine.addComponent((IComponent)this);
        }
        catch (OAException e) {
            _logger.fatal((Object)"Error starting WebSSO", (Throwable)e);
            this.stop();
            throw new ServletException(SystemErrors.toHexString((int)e.getCode()));
        }
        catch (Exception e) {
            _logger.fatal((Object)"Error starting WebSSO", (Throwable)e);
            this.stop();
            throw new ServletException(SystemErrors.toHexString((int)1));
        }
    }

    public void start(IConfigurationManager configurationManager, Element config) throws OAException {
        Element eWebSSO = configurationManager.getSection(null, "websso");
        if (eWebSSO == null) {
            _logger.error((Object)"No 'websso' configuration found");
            throw new OAException(2);
        }
        Element eAuthentication = configurationManager.getSection(eWebSSO, "authentication");
        if (eAuthentication == null) {
            _logger.error((Object)"No authentication configuration found");
            throw new OAException(17);
        }
        this._authenticationManager.start(configurationManager, eAuthentication);
        this._defaultSSOProfile = new WebProfile(this._authenticationManager);
        this._defaultSSOProfile.init(this._context, configurationManager, eWebSSO, null);
        this.addSSOProfile(this._defaultSSOProfile.getID(), this._defaultSSOProfile);
        _logger.info((Object)("Started WebSSO Profile: " + this._defaultSSOProfile.getID()));
        UserProfile userProfile = new UserProfile();
        userProfile.init(this._context, configurationManager, eWebSSO, null);
        this.addSSOProfile(userProfile.getID(), userProfile);
        LogoutProfile logoutProfile = new LogoutProfile(this._authenticationManager);
        logoutProfile.init(this._context, configurationManager, eWebSSO, null);
        this.addSSOProfile(logoutProfile.getID(), logoutProfile);
        Element eProfiles = configurationManager.getSection(eWebSSO, "profiles");
        if (eProfiles != null) {
            this.loadProfiles(configurationManager, eWebSSO, eProfiles);
        }
        _logger.info((Object)"Started SSO Profiles");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart(Element eConfig) throws OAException {
        WebSSOServlet webSSOServlet = this;
        synchronized (webSSOServlet) {
            _logger.info((Object)"Restarting WebSSO");
            this.stop();
            IConfigurationManager config = this._engine.getConfigurationManager();
            this.start(config, eConfig);
        }
    }

    public void service(HttpServletRequest oRequest, HttpServletResponse oResponse) throws ServletException, IOException {
        block10: {
            try {
                String sTarget;
                if (this._defaultSSOProfile == null) {
                    oResponse.sendError(503, oRequest.getRequestURI());
                }
                if ((sTarget = this.resolveTarget(oRequest)) == null) {
                    this._defaultSSOProfile.service(oRequest, oResponse);
                } else {
                    ISSOProfile ssoProfile = this._mapSSOProfiles.get(sTarget);
                    if (ssoProfile != null & ssoProfile instanceof IService) {
                        ((IService)ssoProfile).service(oRequest, oResponse);
                    } else {
                        this._defaultSSOProfile.service(oRequest, oResponse);
                    }
                }
                if (!oResponse.isCommitted()) {
                    oResponse.sendError(200);
                }
            }
            catch (OAException e) {
                _logger.error((Object)"Could not process request", (Throwable)e);
                if (!oResponse.isCommitted()) {
                    oResponse.sendError(500);
                }
            }
            catch (Exception e) {
                _logger.fatal((Object)"Could not process request due to internal error", (Throwable)e);
                if (oResponse.isCommitted()) break block10;
                oResponse.sendError(500);
            }
        }
    }

    public void destroy() {
        this.stop();
        this._engine.removeComponent((IComponent)this);
        _logger.info((Object)"Stopped: WebSSO");
    }

    public synchronized void stop() {
        if (this._authenticationManager != null) {
            this._authenticationManager.stop();
        }
        for (ISSOProfile profile : this._mapSSOProfiles.values()) {
            profile.destroy();
        }
        this._mapSSOProfiles.clear();
        _logger.info((Object)"Stopped SSO Profiles");
        if (this._defaultSSOProfile != null) {
            this._defaultSSOProfile.destroy();
            _logger.info((Object)"Stopped WebSSO Profile");
        }
    }

    private void loadProfiles(IConfigurationManager config, Element eWebSSO, Element eProfiles) throws OAException {
        try {
            Element eProfile = config.getSection(eProfiles, "profile");
            while (eProfile != null) {
                String sClass = config.getParam(eProfile, "class");
                if (sClass == null) {
                    _logger.error((Object)"No 'class' parameter found in 'profile' section");
                    throw new OAException(17);
                }
                ISSOProfile profile = null;
                try {
                    Class<?> profileClass = Class.forName(sClass);
                    profile = (ISSOProfile)profileClass.newInstance();
                }
                catch (ClassNotFoundException e) {
                    _logger.error((Object)("Configured SSO profile class could not be found: " + sClass), (Throwable)e);
                    throw new OAException(17);
                }
                catch (InstantiationException e) {
                    _logger.error((Object)("Configured SSO profile class could not be instantiated: " + sClass), (Throwable)e);
                    throw new OAException(17);
                }
                catch (IllegalAccessException e) {
                    _logger.error((Object)("Configured SSO profile class could not be accessed: " + sClass), (Throwable)e);
                    throw new OAException(17);
                }
                catch (ClassCastException e) {
                    _logger.error((Object)("Configured SSO profile class isn't of type 'ISSOProfile': " + sClass), (Throwable)e);
                    throw new OAException(17);
                }
                profile.init(this._context, config, eWebSSO, eProfile);
                if (this._mapSSOProfiles.containsKey(profile.getID())) {
                    _logger.error((Object)("Configured SSO profile id is not unique: " + profile.getID()));
                    throw new OAException(2);
                }
                this.addSSOProfile(profile.getID(), profile);
                _logger.info((Object)("Started SSO profile: " + profile.getID()));
                eProfile = config.getNextSection(eProfile);
            }
        }
        catch (OAException e) {
            throw e;
        }
        catch (Exception e) {
            _logger.fatal((Object)"Could not load SSO profiles", (Throwable)e);
            throw new OAException(1);
        }
    }

    private String resolveTarget(HttpServletRequest servletRequest) {
        String sRequestURI = servletRequest.getRequestURI();
        if (!sRequestURI.endsWith("/")) {
            sRequestURI = sRequestURI + "/";
        }
        sRequestURI = sRequestURI.toLowerCase();
        String sContextPath = servletRequest.getContextPath();
        String sServletPath = servletRequest.getServletPath();
        String target = sRequestURI.substring(sContextPath.length() + sServletPath.length() + 1);
        if (target != null && target.length() > 1) {
            int iIndex = target.indexOf("/");
            if (target.length() - 1 > iIndex) {
                return target.substring(0, iIndex + 1);
            }
            return target;
        }
        return null;
    }

    private void addSSOProfile(String profileID, ISSOProfile profile) {
        String id = profileID;
        if (!profileID.endsWith("/")) {
            id = id + "/";
        }
        this._mapSSOProfiles.put(id.toLowerCase(), profile);
    }
}

