/*
 * Decompiled with CFR 0.152.
 */
package com.alfaariss.oa.sso.authorization.web;

import com.alfaariss.oa.OAException;
import com.alfaariss.oa.api.IComponent;
import com.alfaariss.oa.api.IOptional;
import com.alfaariss.oa.api.attribute.ISessionAttributes;
import com.alfaariss.oa.api.authorization.IAuthorizationAction;
import com.alfaariss.oa.api.configuration.IConfigurationManager;
import com.alfaariss.oa.api.logging.IAuthority;
import com.alfaariss.oa.api.session.ISession;
import com.alfaariss.oa.api.session.SessionState;
import com.alfaariss.oa.engine.core.Engine;
import com.alfaariss.oa.engine.core.authorization.AuthorizationMethod;
import com.alfaariss.oa.engine.core.authorization.AuthorizationProfile;
import com.alfaariss.oa.engine.core.authorization.factory.IAuthorizationFactory;
import com.alfaariss.oa.engine.core.requestor.RequestorPool;
import com.alfaariss.oa.engine.core.server.Server;
import com.alfaariss.oa.sso.SSOException;
import com.alfaariss.oa.sso.authorization.web.IWebAuthorizationMethod;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class PostAuthorizationManager
implements IComponent,
IOptional,
IAuthority {
    private final String SESSION_CURRENT_PROFILE = "POST_AUTHZ_PROFILE_CURRENT";
    private final String SESSION_CURRENT_METHOD = "POST_AUTHZ_METHOD_CURRENT";
    private Log _logger = LogFactory.getLog(PostAuthorizationManager.class);
    private boolean _bEnabled = false;
    private IConfigurationManager _configManager;
    private IAuthorizationFactory _oPostAuthorizationFactory;
    private AuthorizationProfile _oGlobalAuthorizationProfile;
    private Map<String, IWebAuthorizationMethod> _mapMethods = new HashMap<String, IWebAuthorizationMethod>();
    private Map<String, IAuthorizationAction> _mapActions = new HashMap<String, IAuthorizationAction>();

    public void start(IConfigurationManager oConfigurationManager, Element eConfig) throws OAException {
        if (eConfig == null) {
            this._bEnabled = false;
        } else {
            if (oConfigurationManager == null) {
                throw new IllegalArgumentException("Supplied oConfigurationManager is empty");
            }
            this._configManager = oConfigurationManager;
            this._bEnabled = true;
            String sEnabled = this._configManager.getParam(eConfig, "enabled");
            if (sEnabled != null) {
                if (sEnabled.equalsIgnoreCase("FALSE")) {
                    this._bEnabled = false;
                } else if (!sEnabled.equalsIgnoreCase("TRUE")) {
                    this._logger.error((Object)("Unknown value in 'enabled' configuration item: " + sEnabled));
                    throw new OAException(17);
                }
            }
            if (this._bEnabled) {
                Engine oEngine = Engine.getInstance();
                this._oPostAuthorizationFactory = oEngine.getPostAuthorizationPoolFactory();
                if (this._oPostAuthorizationFactory == null || !this._oPostAuthorizationFactory.isEnabled()) {
                    this._logger.error((Object)"Post Authorization Manager is disabled");
                    throw new OAException(2);
                }
                Server oServer = oEngine.getServer();
                String sGlobalProfileID = oServer.getPostAuthorizationProfileID();
                this._oGlobalAuthorizationProfile = sGlobalProfileID != null ? this._oPostAuthorizationFactory.getProfile(sGlobalProfileID) : null;
                Element eActions = this._configManager.getSection(eConfig, "actions");
                if (eActions == null) {
                    this._logger.warn((Object)"No optional actions found in configuration");
                } else {
                    Element eAction = this._configManager.getSection(eActions, "action");
                    while (eAction != null) {
                        IAuthorizationAction oAction = this.createAction(eAction);
                        if (!oAction.isEnabled()) {
                            this._logger.debug((Object)("Action is disabled: " + oAction.getID()));
                        }
                        if (this._mapActions.containsKey(oAction.getID())) {
                            this._logger.error((Object)("Action is not unique: " + oAction.getID()));
                            throw new OAException(17);
                        }
                        this._mapActions.put(oAction.getID(), oAction);
                        eAction = this._configManager.getNextSection(eAction);
                    }
                }
                Element eMethods = this._configManager.getSection(eConfig, "methods");
                if (eMethods == null) {
                    this._logger.error((Object)"No 'methods' section found in configuration");
                    throw new OAException(17);
                }
                Element eMethod = this._configManager.getSection(eMethods, "method");
                while (eMethod != null) {
                    IWebAuthorizationMethod oMethod = this.createMethod(eMethod, this._mapActions);
                    if (!oMethod.isEnabled()) {
                        this._logger.debug((Object)("Authentication method is disabled: " + oMethod.getID()));
                    }
                    if (this._mapMethods.containsKey(oMethod.getID())) {
                        this._logger.error((Object)("Authentication method is not unique: " + oMethod.getID()));
                        throw new OAException(17);
                    }
                    this._mapMethods.put(oMethod.getID(), oMethod);
                    eMethod = this._configManager.getNextSection(eMethod);
                }
                this._logger.debug((Object)("Finished action initialization (" + this._mapActions.size() + " actions loaded)"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart(Element eConfig) throws OAException {
        PostAuthorizationManager postAuthorizationManager = this;
        synchronized (postAuthorizationManager) {
            this.stop();
            this.start(this._configManager, eConfig);
        }
    }

    public void stop() {
        if (this._mapMethods != null) {
            for (IWebAuthorizationMethod oMethod : this._mapMethods.values()) {
                oMethod.stop();
            }
            this._mapMethods.clear();
        }
        if (this._mapActions != null) {
            for (IAuthorizationAction oAction : this._mapActions.values()) {
                oAction.stop();
            }
            this._mapActions.clear();
        }
        this._bEnabled = false;
    }

    public void authorize(HttpServletRequest oRequest, HttpServletResponse oResponse, ISession oSession, RequestorPool oRequestorPool) throws SSOException, OAException {
        block19: {
            try {
                if (oRequest == null) {
                    throw new IllegalArgumentException("Supplied request == null");
                }
                if (oResponse == null) {
                    throw new IllegalArgumentException("Supplied response == null");
                }
                if (oSession == null) {
                    throw new IllegalArgumentException("Supplied session == null");
                }
                if (!this._bEnabled) {
                    this._logger.error((Object)"Postauthorization manager disabled");
                    throw new SSOException(1);
                }
                ISessionAttributes oAttributes = oSession.getAttributes();
                List<AuthorizationMethod> listMethods = null;
                if (oAttributes.contains(PostAuthorizationManager.class, "POST_AUTHZ_PROFILE_CURRENT")) {
                    listMethods = (List)oAttributes.get(PostAuthorizationManager.class, "POST_AUTHZ_PROFILE_CURRENT");
                } else {
                    String sPostAuthZProfileID;
                    listMethods = new Vector();
                    if (this._oGlobalAuthorizationProfile != null && this._oGlobalAuthorizationProfile.isEnabled()) {
                        listMethods.addAll(this._oGlobalAuthorizationProfile.getAuthorizationMethods());
                    }
                    if ((sPostAuthZProfileID = oRequestorPool.getPostAuthorizationProfileID()) != null) {
                        AuthorizationProfile reqAuthZProfile = null;
                        try {
                            reqAuthZProfile = this._oPostAuthorizationFactory.getProfile(sPostAuthZProfileID);
                        }
                        catch (OAException e) {
                            this._logger.warn((Object)"Could not get postauthorization profile", (Throwable)e);
                            throw new SSOException(1);
                        }
                        if (reqAuthZProfile == null) {
                            this._logger.warn((Object)("Postauthorization profile not found: " + sPostAuthZProfileID));
                            throw new SSOException(1);
                        }
                        if (reqAuthZProfile.isEnabled()) {
                            listMethods.addAll(reqAuthZProfile.getAuthorizationMethods());
                        } else {
                            this._logger.debug((Object)("Postauthorization profile disabled: " + sPostAuthZProfileID));
                        }
                    }
                    oAttributes.put(PostAuthorizationManager.class, "POST_AUTHZ_PROFILE_CURRENT", listMethods);
                }
                if (listMethods.isEmpty()) {
                    oSession.setState(SessionState.POST_AUTHZ_OK);
                    try {
                        oSession.persist();
                        break block19;
                    }
                    catch (OAException e) {
                        this._logger.warn((Object)"Could not store session", (Throwable)e);
                        throw new SSOException(1);
                    }
                }
                this.authorizeForProfile(listMethods, oRequest, oResponse, oSession);
            }
            catch (OAException e) {
                throw e;
            }
            catch (Exception e) {
                this._logger.fatal((Object)"Internal error during postauthorization", (Throwable)e);
                throw new SSOException(1);
            }
        }
    }

    public boolean isEnabled() {
        return this._bEnabled;
    }

    public String getAuthority() {
        return "Post authZ Manager";
    }

    private IAuthorizationAction createAction(Element eAction) throws OAException {
        IAuthorizationAction oAction = null;
        try {
            String sClass = this._configManager.getParam(eAction, "class");
            if (sClass == null) {
                this._logger.error((Object)"No 'class' item found in 'action' section found in configuration");
                throw new OAException(17);
            }
            Class<?> cAction = null;
            try {
                cAction = Class.forName(sClass);
            }
            catch (Exception e) {
                this._logger.error((Object)("Class not found: " + sClass), (Throwable)e);
                throw new OAException(17);
            }
            try {
                oAction = (IAuthorizationAction)cAction.newInstance();
            }
            catch (Exception e) {
                this._logger.error((Object)("Could not create instance of " + sClass), (Throwable)e);
                throw new OAException(17);
            }
            oAction.start(this._configManager, eAction);
        }
        catch (OAException e) {
            throw e;
        }
        catch (Exception e) {
            this._logger.fatal((Object)"Internal error during object creation", (Throwable)e);
            throw new OAException(1);
        }
        return oAction;
    }

    private IWebAuthorizationMethod createMethod(Element eMethod, Map<String, IAuthorizationAction> mapActions) throws OAException {
        IWebAuthorizationMethod oMethod = null;
        try {
            String sClass = this._configManager.getParam(eMethod, "class");
            if (sClass == null) {
                this._logger.error((Object)"No 'class' item found in 'methods' section found in configuration");
                throw new OAException(17);
            }
            Class<?> cMethod = null;
            try {
                cMethod = Class.forName(sClass);
            }
            catch (Exception e) {
                this._logger.error((Object)("Class not found: " + sClass), (Throwable)e);
                throw new OAException(17);
            }
            try {
                oMethod = (IWebAuthorizationMethod)cMethod.newInstance();
            }
            catch (Exception e) {
                this._logger.error((Object)("Could not create instance of " + sClass), (Throwable)e);
                throw new OAException(17);
            }
            oMethod.start(this._configManager, eMethod, mapActions);
        }
        catch (OAException e) {
            throw e;
        }
        catch (Exception e) {
            this._logger.fatal((Object)"Internal error during object creation", (Throwable)e);
            throw new OAException(1);
        }
        return oMethod;
    }

    private void authorizeForProfile(List<AuthorizationMethod> listMethods, HttpServletRequest oRequest, HttpServletResponse oResponse, ISession oSession) throws OAException, SSOException {
        try {
            ISessionAttributes oAttributes = oSession.getAttributes();
            Integer intCurrentMethod = new Integer(0);
            if (!oAttributes.contains(PostAuthorizationManager.class, "POST_AUTHZ_METHOD_CURRENT")) {
                oAttributes.put(PostAuthorizationManager.class, "POST_AUTHZ_METHOD_CURRENT", (Object)intCurrentMethod);
            } else {
                intCurrentMethod = (Integer)oAttributes.get(PostAuthorizationManager.class, "POST_AUTHZ_METHOD_CURRENT");
            }
            AuthorizationMethod curAuthZMethodBean = listMethods.get(intCurrentMethod);
            IWebAuthorizationMethod oWebAuthZMethod = this._mapMethods.get(curAuthZMethodBean.getID());
            if (oWebAuthZMethod == null) {
                this._logger.error((Object)("No postauthorization method found with id: " + curAuthZMethodBean.getID()));
                throw new SSOException(1);
            }
            block8: while (oSession.getState() == SessionState.POST_AUTHZ_IN_PROGRESS) {
                if (!oWebAuthZMethod.isEnabled()) {
                    this._logger.error((Object)("Postauthorization method is disabled: " + oWebAuthZMethod.getID()));
                    throw new SSOException(1);
                }
                switch (oWebAuthZMethod.authorize(oRequest, oResponse, oSession)) {
                    case AUTHZ_METHOD_SUCCESSFUL: {
                        Integer n = intCurrentMethod;
                        Integer n2 = intCurrentMethod = Integer.valueOf(intCurrentMethod + 1);
                        if (intCurrentMethod < listMethods.size()) {
                            oAttributes.put(PostAuthorizationManager.class, "POST_AUTHZ_METHOD_CURRENT", (Object)intCurrentMethod);
                            curAuthZMethodBean = listMethods.get(intCurrentMethod);
                            if (!this._mapMethods.containsKey(curAuthZMethodBean.getID())) {
                                this._logger.error((Object)("Postauthorization method not available: " + curAuthZMethodBean.getID()));
                                throw new SSOException(1);
                            }
                            oWebAuthZMethod = this._mapMethods.get(curAuthZMethodBean.getID());
                            continue block8;
                        }
                        oSession.setState(SessionState.POST_AUTHZ_OK);
                        continue block8;
                    }
                    case AUTHZ_METHOD_IN_PROGRESS: {
                        return;
                    }
                    case USER_CANCELLED: {
                        oSession.setState(SessionState.USER_CANCELLED);
                        continue block8;
                    }
                }
                oSession.setState(SessionState.POST_AUTHZ_FAILED);
            }
        }
        catch (OAException e) {
            throw e;
        }
        catch (Exception e) {
            this._logger.fatal((Object)"Internal error during postauthorization", (Throwable)e);
            throw new SSOException(1);
        }
    }
}

