/*
 * Decompiled with CFR 0.152.
 */
package com.alfaariss.oa.sso.web.profile.logout;

import com.alfaariss.oa.OAException;
import com.alfaariss.oa.UserEvent;
import com.alfaariss.oa.UserException;
import com.alfaariss.oa.api.IService;
import com.alfaariss.oa.api.attribute.ISessionAttributes;
import com.alfaariss.oa.api.configuration.IConfigurationManager;
import com.alfaariss.oa.api.logging.IAuthority;
import com.alfaariss.oa.api.persistence.PersistenceException;
import com.alfaariss.oa.api.requestor.IRequestor;
import com.alfaariss.oa.api.session.ISession;
import com.alfaariss.oa.api.session.SessionState;
import com.alfaariss.oa.api.sso.ISSOProfile;
import com.alfaariss.oa.api.sso.logout.IASLogout;
import com.alfaariss.oa.api.tgt.ITGT;
import com.alfaariss.oa.api.tgt.ITGTListener;
import com.alfaariss.oa.api.tgt.TGTEventError;
import com.alfaariss.oa.api.user.IUser;
import com.alfaariss.oa.engine.core.Engine;
import com.alfaariss.oa.engine.core.requestor.RequestorPool;
import com.alfaariss.oa.engine.core.requestor.factory.IRequestorPoolFactory;
import com.alfaariss.oa.engine.core.session.factory.ISessionFactory;
import com.alfaariss.oa.engine.core.tgt.factory.ITGTAliasStore;
import com.alfaariss.oa.engine.core.tgt.factory.ITGTFactory;
import com.alfaariss.oa.sso.authentication.web.AuthenticationManager;
import com.alfaariss.oa.sso.authentication.web.IWebAuthenticationMethod;
import com.alfaariss.oa.sso.web.profile.logout.LogoutRunnable;
import com.alfaariss.oa.sso.web.profile.logout.LogoutState;
import com.alfaariss.oa.util.logging.SystemLogItem;
import com.alfaariss.oa.util.logging.UserEventLogItem;
import com.alfaariss.oa.util.validation.SessionValidator;
import com.alfaariss.oa.util.validation.TGTValidator;
import com.alfaariss.oa.util.web.CookieTool;
import com.alfaariss.oa.util.web.HttpUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class LogoutProfile
implements ISSOProfile,
IService,
IAuthority {
    public static final String PROFILE_ID = "logout";
    private static final String AUTHORITY_NAME = "LogoutProfile";
    private static final String SESSION_CURRENT_METHOD = "CURRENT_LOGOUT_METHOD";
    private static final String JSP_LOGOUT_STATE = "logoutState";
    private static final String TARGET_LOGOUT_FORCE = "force";
    private static final String TARGET_LOGOUT_STATE = "state";
    private static final String DEFAULT_JSP_LOGOUT = "/ui/sso/logout/logout.jsp";
    private static final String DEFAULT_JSP_CONFIRM = "/ui/sso/logout/confirm.jsp";
    private static final String PROPERTY_LOGOUT_CONFIRMATION = ".confirmation";
    private static Log _logger;
    private static Log _eventLogger;
    private AuthenticationManager _authenticationManager;
    private ITGTFactory<?> _tgtFactory;
    private ISessionFactory<?> _sessionFactory;
    private CookieTool _cookieTool;
    private Map<String, IASLogout> _mapLogoutMethods;
    private String _sMyOrganizationID;
    private String _sJSPUserLogout;
    private ITGTAliasStore _aliasStoreSP;
    private IRequestorPoolFactory _requestorPoolFactory;
    private boolean _bShowConfirmation;
    private String _sJSPConfirmation;

    public LogoutProfile(AuthenticationManager authenticationManager) {
        _logger = LogFactory.getLog(LogoutProfile.class);
        _eventLogger = LogFactory.getLog((String)"com.alfaariss.oa.EventLogger");
        this._mapLogoutMethods = null;
        this._sJSPUserLogout = null;
        this._authenticationManager = authenticationManager;
        this._bShowConfirmation = false;
        this._sJSPConfirmation = null;
    }

    public void destroy() {
        if (this._mapLogoutMethods != null) {
            this._mapLogoutMethods.clear();
        }
        this._sJSPUserLogout = null;
        this._sJSPConfirmation = null;
        this._bShowConfirmation = false;
    }

    public String getID() {
        return PROFILE_ID;
    }

    public void init(ServletContext context, IConfigurationManager configurationManager, Element eParent, Element eSpecific) throws OAException {
        Engine engine = Engine.getInstance();
        this._tgtFactory = engine.getTGTFactory();
        this._sessionFactory = engine.getSessionFactory();
        this._aliasStoreSP = this._tgtFactory.getAliasStoreSP();
        this._sMyOrganizationID = engine.getServer().getOrganization().getID();
        this._requestorPoolFactory = engine.getRequestorPoolFactory();
        this._cookieTool = new CookieTool(configurationManager, eParent);
        Element eLogout = configurationManager.getSection(eParent, PROFILE_ID);
        if (eLogout == null) {
            _logger.warn((Object)"No optional 'logout' section available in configuration, using defaults");
            this._sJSPUserLogout = DEFAULT_JSP_LOGOUT;
            this._bShowConfirmation = false;
            this._sJSPConfirmation = DEFAULT_JSP_CONFIRM;
        } else {
            this.readConfig(configurationManager, eLogout);
        }
        this._mapLogoutMethods = this.loadLogoutMethods(this._authenticationManager.getAuthenticationMethods());
        _logger.info((Object)"Started Logout Profile: logout");
    }

    public void service(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws OAException {
        try {
            String sTarget;
            HttpUtils.setDisableCachingHttpHeaders((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse);
            ISession session = (ISession)servletRequest.getAttribute("asid");
            if (session == null) {
                String sId = servletRequest.getParameter("asid");
                if (sId != null) {
                    if (!SessionValidator.validateDefaultSessionId((String)sId)) {
                        _logger.warn((Object)("Invalid session id in request: " + sId));
                        throw new UserException(UserEvent.REQUEST_INVALID);
                    }
                    session = this._sessionFactory.retrieve((Object)sId);
                } else {
                    _logger.debug((Object)"No session attribute and no session id supplied in request");
                }
            }
            if ((sTarget = this.resolveTarget(servletRequest)) != null) {
                if (sTarget.equalsIgnoreCase(TARGET_LOGOUT_STATE)) {
                    _logger.debug((Object)"Performing 'logout state' request");
                    this.processLogoutState(servletResponse, session);
                    return;
                }
                if (sTarget.equalsIgnoreCase(TARGET_LOGOUT_FORCE)) {
                    _logger.debug((Object)("Performing 'forced logout' request sent from IP: " + servletRequest.getRemoteAddr()));
                    this.processForceLogout(servletRequest, servletResponse, session);
                    return;
                }
            }
            if (session == null) {
                _logger.debug((Object)"No valid session found");
                throw new UserException(UserEvent.REQUEST_INVALID);
            }
            _logger.debug((Object)("Performing 'logout' request sent from IP: " + servletRequest.getRemoteAddr()));
            switch (session.getState()) {
                case USER_LOGOUT_IN_PROGRESS: {
                    this.finishFederativeLogout(servletRequest, servletResponse, session);
                    break;
                }
                case USER_LOGOUT_FAILED: 
                case USER_LOGOUT_PARTIAL: {
                    this.processForceLogout(servletRequest, servletResponse, session);
                    break;
                }
                case USER_LOGOUT_SUCCESS: {
                    this.processLocalLogout(servletRequest, servletResponse, session, null);
                    break;
                }
                case USER_CANCELLED: {
                    _logger.debug((Object)new SystemLogItem(session.getId(), 0, "Redirect back to Profile"));
                    servletResponse.sendRedirect(session.getProfileURL());
                    break;
                }
                default: {
                    this.processDefault(servletRequest, servletResponse, session);
                    break;
                }
            }
        }
        catch (UserException e) {
            try {
                if (!servletResponse.isCommitted()) {
                    servletResponse.sendError(400);
                }
            }
            catch (IOException e1) {
                _logger.debug((Object)"Could not respond", (Throwable)e1);
                throw new OAException(1);
            }
        }
        catch (OAException e) {
            throw e;
        }
        catch (Exception e) {
            _logger.fatal((Object)"Could not perform logout request", (Throwable)e);
            throw new OAException(1);
        }
    }

    public String getAuthority() {
        return AUTHORITY_NAME;
    }

    private void processDefault(HttpServletRequest servletRequest, HttpServletResponse servletResponse, ISession session) throws OAException, UserException {
        try {
            _logger.debug((Object)"Start logout");
            String sTGTID = this._cookieTool.getCookieValue("oa_sso_id", servletRequest);
            if (sTGTID == null) {
                _logger.debug((Object)"No TGT cookie found");
                throw new UserException(UserEvent.REQUEST_INVALID);
            }
            if (sTGTID != null && !TGTValidator.validateDefaultTGTId((String)sTGTID)) {
                _logger.debug((Object)("Invalid TGT ID in cookie: " + sTGTID));
                throw new UserException(UserEvent.REQUEST_INVALID);
            }
            ITGT tgt = this._tgtFactory.retrieve((Object)sTGTID);
            if (tgt == null || tgt.isExpired()) {
                session.setState(SessionState.USER_LOGOUT_PARTIAL);
                this.processForceLogout(servletRequest, servletResponse, session);
            } else {
                if (this._aliasStoreSP != null) {
                    this._aliasStoreSP.removeAll(session.getRequestorId(), tgt.getId());
                }
                tgt.removeRequestorID(session.getRequestorId());
                tgt.persist();
                session.setTGTId(sTGTID);
                IUser user = tgt.getUser();
                session.setUser(user);
                if (this.mustShowConfirmation(servletRequest, session, tgt)) {
                    this.processConfirmation(servletRequest, servletResponse, tgt, session);
                    return;
                }
                IASLogout asLogout = null;
                if (this._mapLogoutMethods != null) {
                    for (IASLogout method : this._mapLogoutMethods.values()) {
                        if (!method.canLogout(tgt)) continue;
                        asLogout = method;
                        break;
                    }
                }
                if (asLogout != null && !this._sMyOrganizationID.equals(user.getOrganization())) {
                    session.getAttributes().put(this.getClass(), SESSION_CURRENT_METHOD, (Object)asLogout.getID());
                    session.setState(SessionState.USER_LOGOUT_IN_PROGRESS);
                    _logger.debug((Object)"do federative logout");
                    switch (asLogout.logout(servletRequest, servletResponse, tgt, session)) {
                        case USER_LOGOUT_IN_PROGRESS: {
                            break;
                        }
                        case USER_LOGGED_OUT: {
                            session.setState(SessionState.USER_LOGOUT_SUCCESS);
                            this.processLocalLogout(servletRequest, servletResponse, session, tgt);
                            break;
                        }
                        default: {
                            this.processForceLogout(servletRequest, servletResponse, session);
                            break;
                        }
                    }
                } else {
                    this.processLocalLogout(servletRequest, servletResponse, session, tgt);
                }
            }
        }
        catch (UserException e) {
            throw e;
        }
        catch (OAException e) {
            throw e;
        }
        catch (Exception e) {
            _logger.fatal((Object)"Internal error while performing the default process", (Throwable)e);
            throw new OAException(1);
        }
    }

    private void finishFederativeLogout(HttpServletRequest servletRequest, HttpServletResponse servletResponse, ISession session) throws OAException, UserException {
        try {
            _logger.debug((Object)"finish federative logout");
            String sTGTID = session.getTGTId();
            if (sTGTID == null) {
                _logger.debug((Object)"No TGT ID found in session");
                throw new UserException(UserEvent.REQUEST_INVALID);
            }
            ITGT tgt = this._tgtFactory.retrieve((Object)sTGTID);
            if (tgt == null || tgt.isExpired()) {
                _logger.debug((Object)("No TGT available with id: " + sTGTID));
                session.setState(SessionState.USER_LOGOUT_PARTIAL);
                this.processForceLogout(servletRequest, servletResponse, session);
            } else {
                String sLogoutMethodID = (String)session.getAttributes().get(this.getClass(), SESSION_CURRENT_METHOD);
                if (sLogoutMethodID == null) {
                    _logger.debug((Object)"Required session attribute not available: CURRENT_LOGOUT_METHOD");
                    throw new UserException(UserEvent.REQUEST_INVALID);
                }
                IASLogout asLogout = this._mapLogoutMethods.get(sLogoutMethodID);
                if (asLogout == null) {
                    _logger.debug((Object)("No method found: " + sLogoutMethodID));
                    throw new UserException(UserEvent.REQUEST_INVALID);
                }
                _logger.debug((Object)"proceed federative logout");
                switch (asLogout.logout(servletRequest, servletResponse, tgt, session)) {
                    case USER_LOGOUT_IN_PROGRESS: {
                        break;
                    }
                    case USER_LOGGED_OUT: {
                        session.setState(SessionState.USER_LOGOUT_SUCCESS);
                        this.processLocalLogout(servletRequest, servletResponse, session, tgt);
                        break;
                    }
                    default: {
                        this.processForceLogout(servletRequest, servletResponse, session);
                    }
                }
            }
        }
        catch (UserException e) {
            throw e;
        }
        catch (OAException e) {
            throw e;
        }
        catch (Exception e) {
            _logger.fatal((Object)"Internal error while finishing federative logout", (Throwable)e);
            throw new OAException(1);
        }
    }

    private void processLocalLogout(HttpServletRequest servletRequest, HttpServletResponse servletResponse, ISession session, ITGT tgt) throws OAException {
        _logger.debug((Object)"Start Logout at local IDP (only TGT Events)");
        try {
            if (session == null) {
                _logger.debug((Object)"No session available");
                throw new OAException(1);
            }
            String sTGTID = session.getTGTId();
            if (sTGTID == null) {
                sTGTID = this._cookieTool.getCookieValue("oa_sso_id", servletRequest);
                if (sTGTID == null) {
                    _logger.debug((Object)"No TGT ID available");
                    throw new UserException(UserEvent.REQUEST_INVALID);
                }
                if (sTGTID != null && !TGTValidator.validateDefaultTGTId((String)sTGTID)) {
                    _logger.debug((Object)("Invalid TGT ID in cookie: " + sTGTID));
                    throw new UserException(UserEvent.REQUEST_INVALID);
                }
                session.setTGTId(sTGTID);
            }
            SessionState state = session.getState();
            LogoutState logoutState = null;
            if (state != SessionState.USER_LOGOUT_IN_PROGRESS) {
                session.setState(SessionState.USER_LOGOUT_IN_PROGRESS);
                if (tgt == null && ((tgt = this._tgtFactory.retrieve((Object)sTGTID)) == null || tgt.isExpired())) {
                    _logger.debug((Object)("TGT already expired: " + sTGTID));
                    throw new UserException(UserEvent.REQUEST_INVALID);
                }
                logoutState = this.startListeners(tgt, session, servletRequest);
            } else {
                session.persist();
            }
            if (logoutState != null && logoutState.isFinished()) {
                this.processForceLogout(servletRequest, servletResponse, session);
            } else {
                this.showLogoutJSP(servletRequest, servletResponse, SessionState.USER_LOGOUT_IN_PROGRESS, session.getId(), null);
            }
        }
        catch (UserException e) {
            session.setState(SessionState.USER_LOGOUT_FAILED);
            _eventLogger.info((Object)new UserEventLogItem(session, servletRequest.getRemoteAddr(), UserEvent.INTERNAL_ERROR, (IAuthority)this, null));
            this.processForceLogout(servletRequest, servletResponse, session);
        }
        catch (OAException e) {
            throw e;
        }
        catch (Exception e) {
            _logger.fatal((Object)"Internal error during logout processing", (Throwable)e);
            throw new OAException(1);
        }
    }

    private void processForceLogout(HttpServletRequest servletRequest, HttpServletResponse servletResponse, ISession session) throws OAException {
        try {
            ITGT tgt;
            String sTGTCookie;
            _logger.debug((Object)"Perform Forced Logout (remove the TGT)");
            SessionState sessionStateBackup = SessionState.USER_LOGOUT_FAILED;
            String sTGTID = null;
            if (session != null) {
                sTGTID = session.getTGTId();
            }
            if ((sTGTCookie = this._cookieTool.getCookieValue("oa_sso_id", servletRequest)) != null) {
                this._cookieTool.removeCookie("oa_sso_id", servletRequest, servletResponse);
                _logger.debug((Object)"TGT cookie removed");
                sessionStateBackup = SessionState.USER_LOGOUT_PARTIAL;
            }
            if (sTGTID == null && (sTGTID = sTGTCookie) != null && !TGTValidator.validateDefaultTGTId((String)sTGTID)) {
                _logger.debug((Object)("Not using invalid TGT ID resolved from cookie: " + sTGTID));
                sTGTID = null;
            }
            if (sTGTID != null && (tgt = this._tgtFactory.retrieve((Object)sTGTID)) != null) {
                block20: {
                    if (!tgt.isExpired()) {
                        tgt.expire();
                    }
                    try {
                        if (session != null) {
                            tgt.persistPassingListenerEvent();
                        } else {
                            tgt.persist();
                            sessionStateBackup = SessionState.USER_LOGOUT_PARTIAL;
                        }
                    }
                    catch (PersistenceException e) {
                        if (session == null) break block20;
                        session.setState(SessionState.USER_LOGOUT_FAILED);
                    }
                }
                _logger.debug((Object)"TGT removed");
            }
            if (session == null) {
                this.showLogoutJSP(servletRequest, servletResponse, sessionStateBackup, null, null);
            } else {
                if (session.getState() == SessionState.USER_LOGOUT_IN_PROGRESS) {
                    session.setState(SessionState.USER_LOGOUT_FAILED);
                }
                session.setTGTId(null);
                session.persist();
                if (session.getState() != SessionState.USER_LOGOUT_SUCCESS) {
                    Vector<TGTEventError> warnings = new Vector<TGTEventError>();
                    ISessionAttributes sessionAttributes = session.getAttributes();
                    if (sessionAttributes.contains(LogoutState.class, "logoutResults")) {
                        List totalWarnings = (List)sessionAttributes.get(LogoutState.class, "logoutResults");
                        for (int i = 0; i < totalWarnings.size(); ++i) {
                            TGTEventError eventError = (TGTEventError)totalWarnings.get(i);
                            if (eventError.getCode() == UserEvent.USER_LOGGED_OUT) continue;
                            warnings.add(eventError);
                        }
                    }
                    this.showLogoutJSP(servletRequest, servletResponse, session.getState(), session.getId(), warnings);
                } else {
                    String sRedirect = session.getProfileURL();
                    if (sRedirect == null) {
                        _logger.warn((Object)("No redirect to profile URL available in session with id: " + session.getId()));
                        throw new OAException(1);
                    }
                    _logger.debug((Object)("Logout finished for TGT with id: " + sTGTID));
                    _logger.debug((Object)("Redirecting user back to profile URL: " + sRedirect));
                    servletResponse.sendRedirect(sRedirect);
                }
            }
        }
        catch (OAException e) {
            throw e;
        }
        catch (Exception e) {
            _logger.fatal((Object)"Internal error during forced logout", (Throwable)e);
            throw new OAException(1);
        }
    }

    private void processLogoutState(HttpServletResponse servletResponse, ISession session) throws OAException {
        _logger.debug((Object)"Logout - Perform State Request");
        try {
            servletResponse.setContentType("text/plain");
            if (session == null) {
                _logger.debug((Object)"no session");
                servletResponse.sendError(400);
            } else {
                switch (session.getState()) {
                    case USER_LOGOUT_FAILED: 
                    case USER_LOGOUT_PARTIAL: 
                    case USER_LOGOUT_SUCCESS: {
                        _logger.debug((Object)"finished");
                        servletResponse.sendError(200);
                        break;
                    }
                    default: {
                        _logger.debug((Object)"in progress");
                        servletResponse.sendError(503);
                    }
                }
            }
        }
        catch (Exception e) {
            _logger.fatal((Object)"Internal error during logout state resolving", (Throwable)e);
            throw new OAException(1);
        }
    }

    private void showConfirmJSP(HttpServletRequest servletRequest, HttpServletResponse servletResponse, ISession session, List<IRequestor> listRequestors, IRequestor requestor) throws OAException {
        try {
            servletRequest.setAttribute("asid", (Object)session.getId());
            servletRequest.setAttribute("requestors", listRequestors);
            servletRequest.setAttribute("requestor", (Object)requestor);
            servletRequest.setAttribute("user", (Object)session.getUser());
            servletRequest.setAttribute("serverInfo", (Object)Engine.getInstance().getServer());
            RequestDispatcher oDispatcher = servletRequest.getRequestDispatcher(this._sJSPConfirmation);
            if (oDispatcher == null) {
                _logger.fatal((Object)"Forward request not supported");
                throw new OAException(1);
            }
            oDispatcher.forward((ServletRequest)servletRequest, (ServletResponse)servletResponse);
        }
        catch (OAException e) {
            throw e;
        }
        catch (Exception e) {
            _logger.fatal((Object)"Internal error during jsp forward", (Throwable)e);
            throw new OAException(1);
        }
    }

    private void showLogoutJSP(HttpServletRequest servletRequest, HttpServletResponse servletResponse, SessionState state, String sessionID, List<TGTEventError> warnings) throws OAException {
        try {
            if (sessionID != null) {
                servletRequest.setAttribute("asid", (Object)sessionID);
            }
            if (state != null) {
                servletRequest.setAttribute(JSP_LOGOUT_STATE, (Object)state);
            }
            if (warnings != null) {
                servletRequest.setAttribute("details", warnings);
            }
            servletRequest.setAttribute("serverInfo", (Object)Engine.getInstance().getServer());
            RequestDispatcher oDispatcher = servletRequest.getRequestDispatcher(this._sJSPUserLogout);
            if (oDispatcher == null) {
                _logger.fatal((Object)"Forward request not supported");
                throw new OAException(1);
            }
            oDispatcher.forward((ServletRequest)servletRequest, (ServletResponse)servletResponse);
        }
        catch (OAException e) {
            throw e;
        }
        catch (Exception e) {
            _logger.fatal((Object)"Internal error during jsp forward to logout page", (Throwable)e);
            throw new OAException(1);
        }
    }

    private boolean mustShowConfirmation(HttpServletRequest servletRequest, ISession session, ITGT tgt) throws OAException {
        if (this._sJSPConfirmation == null) {
            return false;
        }
        if (servletRequest.getParameter("confirm") != null) {
            return false;
        }
        if (tgt.getRequestorIDs().size() < 1) {
            return false;
        }
        String requestorID = session.getRequestorId();
        IRequestor requestor = this._requestorPoolFactory.getRequestor(requestorID);
        if (requestor != null) {
            String sConfirm = (String)requestor.getProperty("logout.confirmation");
            if (sConfirm != null) {
                if (sConfirm.equalsIgnoreCase("TRUE")) {
                    return true;
                }
                if (sConfirm.equalsIgnoreCase("FALSE")) {
                    return false;
                }
                StringBuffer sbDebug = new StringBuffer("Invalid property '");
                sbDebug.append(PROFILE_ID);
                sbDebug.append(PROPERTY_LOGOUT_CONFIRMATION);
                sbDebug.append("' found for requestor '");
                sbDebug.append(requestorID);
                sbDebug.append("': ");
                sbDebug.append(sConfirm);
                _logger.debug((Object)sbDebug.toString());
            } else {
                _logger.debug((Object)("No (optional) requestor specific logout confirmation property found for requestor with ID: " + requestorID));
            }
            RequestorPool pool = this._requestorPoolFactory.getRequestorPool(requestorID);
            if (pool != null) {
                String sPoolConfirm = (String)pool.getProperty("logout.confirmation");
                if (sPoolConfirm != null) {
                    if (sPoolConfirm.equalsIgnoreCase("TRUE")) {
                        return true;
                    }
                    if (sPoolConfirm.equalsIgnoreCase("FALSE")) {
                        return false;
                    }
                    StringBuffer sbDebug = new StringBuffer("Invalid property '");
                    sbDebug.append(PROFILE_ID);
                    sbDebug.append(PROPERTY_LOGOUT_CONFIRMATION);
                    sbDebug.append("' found for requestorpool '");
                    sbDebug.append(pool.getID());
                    sbDebug.append("': ");
                    sbDebug.append(sPoolConfirm);
                    _logger.debug((Object)sbDebug.toString());
                } else {
                    _logger.debug((Object)("No (optional) requestorpool specific logout confirmation property found for requestorpool with ID: " + pool.getID()));
                }
            }
        }
        return this._bShowConfirmation;
    }

    private void processConfirmation(HttpServletRequest servletRequest, HttpServletResponse servletResponse, ITGT tgt, ISession session) throws OAException {
        Vector<IRequestor> vRequestors = new Vector<IRequestor>();
        List listRequestorIDs = tgt.getRequestorIDs();
        for (int i = listRequestorIDs.size() - 1; i >= 0; --i) {
            String sRequestorID = (String)listRequestorIDs.get(i);
            IRequestor oRequestor = this._requestorPoolFactory.getRequestor(sRequestorID);
            if (oRequestor == null || vRequestors.contains(oRequestor)) continue;
            vRequestors.add(oRequestor);
        }
        session.persist();
        IRequestor requestor = this._requestorPoolFactory.getRequestor(session.getRequestorId());
        this.showConfirmJSP(servletRequest, servletResponse, session, vRequestors, requestor);
    }

    private LogoutState startListeners(ITGT tgt, ISession session, HttpServletRequest servletRequest) throws OAException {
        Vector<Thread> listThreads = new Vector<Thread>();
        LogoutState state = new LogoutState(this._sessionFactory, session.getId());
        int iIndex = 0;
        for (ITGTListener listener : this._tgtFactory.getListeners()) {
            StringBuffer sbRunnableName = new StringBuffer(session.getId());
            sbRunnableName.append("_");
            sbRunnableName.append(++iIndex);
            LogoutRunnable runnable = new LogoutRunnable(listener, tgt, state, sbRunnableName.toString());
            Thread tLogout = new Thread(runnable);
            StringBuffer sbThreadname = new StringBuffer("Logout (");
            sbThreadname.append(sbRunnableName.toString());
            sbThreadname.append(") - ");
            sbThreadname.append(tLogout.getName());
            tLogout.setName(sbThreadname.toString());
            listThreads.add(tLogout);
        }
        session.persist();
        _eventLogger.info((Object)new UserEventLogItem(session, servletRequest.getRemoteAddr(), UserEvent.USER_LOGOUT_IN_PROGRESS, (IAuthority)this, null));
        for (Thread thread : listThreads) {
            thread.start();
            _logger.debug((Object)("Started: " + thread.getName()));
        }
        _logger.debug((Object)"Logout threads started");
        return state;
    }

    private String resolveTarget(HttpServletRequest servletRequest) {
        int iIndex;
        String sRequestURI = servletRequest.getRequestURI();
        if (!sRequestURI.endsWith("/")) {
            sRequestURI = sRequestURI + "/";
        }
        if ((iIndex = (sRequestURI = sRequestURI.toLowerCase()).indexOf("logout/")) > -1) {
            String target;
            int iStart = iIndex + PROFILE_ID.length() + "/".length();
            if (sRequestURI.length() > iStart && (target = sRequestURI.substring(iStart, sRequestURI.length() - 1)).length() > 0) {
                return target;
            }
        }
        return null;
    }

    private Map<String, IASLogout> loadLogoutMethods(Map<String, IWebAuthenticationMethod> mapAuthNMethods) throws OAException {
        HashMap<String, IASLogout> mapLogoutMethods = new HashMap<String, IASLogout>();
        try {
            for (IWebAuthenticationMethod method : mapAuthNMethods.values()) {
                if (!method.isEnabled() || !(method instanceof IASLogout)) continue;
                IASLogout aslogout = (IASLogout)method;
                if (mapLogoutMethods.containsKey(aslogout.getID())) {
                    _logger.info((Object)("Authentication method has not a unique id: " + aslogout.getID()));
                    continue;
                }
                _logger.info((Object)("Found asynchronous logout method: " + aslogout.getID()));
                mapLogoutMethods.put(aslogout.getID(), aslogout);
            }
        }
        catch (Exception e) {
            _logger.fatal((Object)"Could not load asynchronous logout methods", (Throwable)e);
            throw new OAException(1);
        }
        return mapLogoutMethods;
    }

    private void readConfig(IConfigurationManager configurationManager, Element config) throws OAException {
        Element eJSP = configurationManager.getSection(config, "jsp");
        if (eJSP == null) {
            _logger.warn((Object)"No optional 'jsp' parameter found in 'logout' section in configuration; using default");
            this._sJSPUserLogout = DEFAULT_JSP_LOGOUT;
        } else {
            this._sJSPUserLogout = configurationManager.getParam(eJSP, "path");
            if (this._sJSPUserLogout == null) {
                _logger.error((Object)"No 'path' parameter found in 'jsp' section in configuration");
                throw new OAException(17);
            }
        }
        _logger.info((Object)("Using logout jsp location: " + this._sJSPUserLogout));
        this._bShowConfirmation = false;
        this._sJSPConfirmation = DEFAULT_JSP_CONFIRM;
        Element eConfirmation = configurationManager.getSection(config, "confirmation");
        if (eConfirmation == null) {
            _logger.warn((Object)"No optional 'confirmation' section found within 'logout' section in configuration; using defaults");
        } else {
            Element eConfirmationJSP = configurationManager.getSection(eConfirmation, "jsp");
            if (eConfirmationJSP == null) {
                _logger.warn((Object)"No optional 'jsp' parameter found in 'confirmation' section in logout confirmation configuration; using default");
                this._sJSPConfirmation = DEFAULT_JSP_CONFIRM;
            } else {
                this._sJSPConfirmation = configurationManager.getParam(eConfirmationJSP, "path");
                if (this._sJSPConfirmation == null) {
                    _logger.error((Object)"No 'path' parameter found in 'jsp' section in logout confirmation configuration");
                    throw new OAException(17);
                }
            }
            String sShow = configurationManager.getParam(eConfirmation, "show");
            if (sShow == null) {
                _logger.warn((Object)"No optional 'show' parameter found in 'confirmation' section in logout confirmation configuration; using default");
            } else if (sShow.equalsIgnoreCase("TRUE")) {
                this._bShowConfirmation = true;
            } else if (!sShow.equalsIgnoreCase("FALSE")) {
                _logger.error((Object)("Unknown value in 'show' configuration item: " + sShow));
                throw new OAException(17);
            }
        }
        _logger.info((Object)("Using logout confirmation jsp location: " + this._sJSPConfirmation));
        _logger.info((Object)("Default show logout confirmation: " + (this._bShowConfirmation ? "enabled" : "disabled")));
    }
}

