/*
 * Decompiled with CFR 0.152.
 */
package com.alfaariss.oa.sso.web.profile.logout;

import com.alfaariss.oa.OAException;
import com.alfaariss.oa.UserEvent;
import com.alfaariss.oa.api.attribute.ISessionAttributes;
import com.alfaariss.oa.api.session.ISession;
import com.alfaariss.oa.api.session.SessionState;
import com.alfaariss.oa.api.tgt.TGTEventError;
import com.alfaariss.oa.engine.core.session.factory.ISessionFactory;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LogoutState {
    public static final String SESSION_LOGOUT_RESULTS = "logoutResults";
    private static Log _logger;
    private Hashtable<String, List<TGTEventError>> _htResults;
    private int _iSize;
    private String _sSessionID;
    private ISessionFactory<?> _sessionFactory;
    private volatile boolean _bFinished;

    public LogoutState(ISessionFactory sessionFactory, String sessionID) {
        _logger = LogFactory.getLog(LogoutState.class);
        this._sessionFactory = sessionFactory;
        this._sSessionID = sessionID;
        this._htResults = new Hashtable();
        this._iSize = 0;
        this._bFinished = false;
    }

    public synchronized void add(String runnableID) {
        Vector<TGTEventError> listDefault = new Vector<TGTEventError>();
        listDefault.add(new TGTEventError(UserEvent.USER_LOGOUT_IN_PROGRESS));
        this._htResults.put(runnableID, listDefault);
        ++this._iSize;
    }

    public synchronized void set(String runnableID, TGTEventError error) {
        Vector<TGTEventError> listError = new Vector<TGTEventError>();
        listError.add(error);
        this._htResults.put(runnableID, listError);
        --this._iSize;
        if (this._iSize == 0) {
            this.storeResults();
            this._bFinished = true;
        }
    }

    public synchronized void set(String runnableID, List<TGTEventError> errors) {
        this._htResults.put(runnableID, errors);
        --this._iSize;
        if (this._iSize == 0) {
            this.storeResults();
            this._bFinished = true;
        }
    }

    public boolean isFinished() {
        return this._bFinished;
    }

    private void storeResults() {
        try {
            ISession session = this._sessionFactory.retrieve((Object)this._sSessionID);
            if (session != null) {
                ISessionAttributes sessionAttributes = session.getAttributes();
                SessionState sessionState = SessionState.USER_LOGOUT_SUCCESS;
                UserEvent logoutResult = UserEvent.USER_LOGGED_OUT;
                Vector<TGTEventError> listResults = new Vector<TGTEventError>();
                Enumeration<List<TGTEventError>> enumLists = this._htResults.elements();
                while (enumLists.hasMoreElements()) {
                    List<TGTEventError> listError = enumLists.nextElement();
                    for (int i = 0; i < listError.size(); ++i) {
                        TGTEventError tgtEventError = listError.get(i);
                        logoutResult = tgtEventError.getCode();
                        if (logoutResult == UserEvent.USER_LOGGED_OUT) continue;
                        _logger.debug((Object)("Logout failed: " + logoutResult));
                        sessionState = SessionState.USER_LOGOUT_FAILED;
                        break;
                    }
                    listResults.addAll(listError);
                }
                session.setState(sessionState);
                sessionAttributes.put(this.getClass(), SESSION_LOGOUT_RESULTS, listResults);
                session.persist();
                _logger.debug((Object)("Stored logout state results for session with ID: " + this._sSessionID));
            }
        }
        catch (OAException e) {
            _logger.debug((Object)("Could not store logout results in session with id: " + this._sSessionID), (Throwable)e);
        }
    }
}

