/*
 * Decompiled with CFR 0.152.
 */
package com.alfaariss.oa.sso.authentication.web;

import com.alfaariss.oa.OAException;
import com.alfaariss.oa.api.IComponent;
import com.alfaariss.oa.api.attribute.ISessionAttributes;
import com.alfaariss.oa.api.authentication.IAuthenticationMethod;
import com.alfaariss.oa.api.authentication.IAuthenticationProfile;
import com.alfaariss.oa.api.configuration.IConfigurationManager;
import com.alfaariss.oa.api.session.ISession;
import com.alfaariss.oa.api.session.SessionState;
import com.alfaariss.oa.engine.core.authentication.AuthenticationMethod;
import com.alfaariss.oa.sso.SSOException;
import com.alfaariss.oa.sso.authentication.web.IWebAuthenticationMethod;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class AuthenticationManager
implements IComponent {
    private static final String ATTRIBUTE_CURRENT_METHOD = "CURRENT_METHOD";
    private Map<String, IWebAuthenticationMethod> _mapAuthenticationMethods;
    private Log _logger = LogFactory.getLog(AuthenticationManager.class);
    private IConfigurationManager _configManager;

    public AuthenticationManager() {
        this._mapAuthenticationMethods = new HashMap<String, IWebAuthenticationMethod>();
    }

    public void authenticate(IAuthenticationProfile oSelectedAuthNProfile, HttpServletRequest oRequest, HttpServletResponse oResponse, ISession oSession) throws SSOException, OAException {
        try {
            if (oSelectedAuthNProfile == null) {
                throw new IllegalArgumentException("No selected authN profile supplied");
            }
            if (!oSelectedAuthNProfile.isEnabled()) {
                this._logger.error((Object)("Authentication profile is disabled: " + oSelectedAuthNProfile.getID()));
                throw new SSOException(1);
            }
            List listMethods = oSelectedAuthNProfile.getAuthenticationMethods();
            IAuthenticationMethod oAuthMethodBean = null;
            ISessionAttributes oAttributes = oSession.getAttributes();
            SessionState oState = oSession.getState();
            if (oState == SessionState.AUTHN_SELECTION_OK) {
                oAuthMethodBean = this.getAuthenticationMethod(listMethods, oAuthMethodBean, oSelectedAuthNProfile.getID());
                oAttributes.put(AuthenticationManager.class, ATTRIBUTE_CURRENT_METHOD, (Object)oAuthMethodBean);
                oSession.setState(SessionState.AUTHN_IN_PROGRESS);
            } else if (oState == SessionState.AUTHN_IN_PROGRESS) {
                oAuthMethodBean = (AuthenticationMethod)oAttributes.get(AuthenticationManager.class, ATTRIBUTE_CURRENT_METHOD);
            } else {
                this._logger.error((Object)("Session state invalid: " + oState));
                throw new SSOException(1);
            }
            IWebAuthenticationMethod oWebAuthMethod = this._mapAuthenticationMethods.get(oAuthMethodBean.getID());
            if (oWebAuthMethod == null) {
                this._logger.error((Object)("No authentication method found with id: " + oAuthMethodBean.getID()));
                throw new SSOException(1);
            }
            block11: while (oSession.getState() == SessionState.AUTHN_IN_PROGRESS) {
                if (!oWebAuthMethod.isEnabled()) {
                    this._logger.error((Object)("Authentication method is disabled: " + oWebAuthMethod.getID()));
                    throw new SSOException(1);
                }
                switch (oWebAuthMethod.authenticate(oRequest, oResponse, oSession)) {
                    case AUTHN_METHOD_SUCCESSFUL: {
                        oAuthMethodBean = this.getAuthenticationMethod(listMethods, oAuthMethodBean, oSelectedAuthNProfile.getID());
                        if (oAuthMethodBean != null) {
                            oAttributes.put(AuthenticationManager.class, ATTRIBUTE_CURRENT_METHOD, (Object)oAuthMethodBean);
                            if (!this._mapAuthenticationMethods.containsKey(oAuthMethodBean.getID())) {
                                this._logger.error((Object)("Authentication method not available: " + oAuthMethodBean.getID()));
                                throw new SSOException(1);
                            }
                            oWebAuthMethod = this._mapAuthenticationMethods.get(oAuthMethodBean.getID());
                            continue block11;
                        }
                        oSession.setState(SessionState.AUTHN_OK);
                        continue block11;
                    }
                    case AUTHN_METHOD_IN_PROGRESS: {
                        return;
                    }
                    case USER_UNKNOWN: {
                        oSession.setState(SessionState.USER_UNKNOWN);
                        continue block11;
                    }
                    case USER_DISABLED: {
                        oSession.setState(SessionState.USER_BLOCKED);
                        continue block11;
                    }
                    case USER_CANCELLED: {
                        oSession.setState(SessionState.USER_CANCELLED);
                        continue block11;
                    }
                    case AUTHN_METHOD_NOT_REGISTERED: 
                    case AUTHN_METHOD_NOT_SUPPORTED: {
                        oSession.setState(SessionState.AUTHN_NOT_SUPPORTED);
                        continue block11;
                    }
                }
                oSession.setState(SessionState.AUTHN_FAILED);
            }
        }
        catch (OAException e) {
            throw e;
        }
        catch (Exception e) {
            this._logger.error((Object)"Internal error during authentication", (Throwable)e);
            throw new SSOException(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart(Element eConfig) throws OAException {
        AuthenticationManager authenticationManager = this;
        synchronized (authenticationManager) {
            this.stop();
            this.start(this._configManager, eConfig);
        }
    }

    public void start(IConfigurationManager oConfigurationManager, Element eConfig) throws OAException {
        try {
            this._configManager = oConfigurationManager;
            Element eMethods = this._configManager.getSection(eConfig, "methods");
            if (eMethods == null) {
                this._logger.error((Object)"No 'methods' section found in configuration");
                throw new OAException(17);
            }
            Element eMethod = this._configManager.getSection(eMethods, "method");
            while (eMethod != null) {
                IWebAuthenticationMethod oAuthenticationMethod = this.createAuthenticationMethod(eMethod);
                if (!oAuthenticationMethod.isEnabled()) {
                    this._logger.debug((Object)("Authentication method is disabled: " + oAuthenticationMethod.getID()));
                } else {
                    if (this._mapAuthenticationMethods.containsKey(oAuthenticationMethod.getID())) {
                        this._logger.error((Object)("Authentication method is not unique: " + oAuthenticationMethod.getID()));
                        throw new OAException(17);
                    }
                    this._mapAuthenticationMethods.put(oAuthenticationMethod.getID(), oAuthenticationMethod);
                }
                eMethod = this._configManager.getNextSection(eMethod);
            }
        }
        catch (OAException e) {
            throw e;
        }
        catch (Exception e) {
            this._logger.fatal((Object)"Internal error during object creation", (Throwable)e);
            throw new OAException(1);
        }
    }

    public void stop() {
        if (this._mapAuthenticationMethods != null) {
            for (IWebAuthenticationMethod oMethod : this._mapAuthenticationMethods.values()) {
                oMethod.stop();
            }
            this._mapAuthenticationMethods.clear();
        }
    }

    public Map<String, IWebAuthenticationMethod> getAuthenticationMethods() {
        return Collections.unmodifiableMap(this._mapAuthenticationMethods);
    }

    private IWebAuthenticationMethod createAuthenticationMethod(Element eMethod) throws SSOException {
        IWebAuthenticationMethod oAuthenticationMethod = null;
        try {
            String sClass = this._configManager.getParam(eMethod, "class");
            if (sClass == null) {
                this._logger.error((Object)"No 'class' item found in 'methods' section found in configuration");
                throw new SSOException(17);
            }
            Class<?> cMethod = null;
            try {
                cMethod = Class.forName(sClass);
            }
            catch (Exception e) {
                this._logger.error((Object)("Class not found: " + sClass), (Throwable)e);
                throw new SSOException(17);
            }
            try {
                oAuthenticationMethod = (IWebAuthenticationMethod)cMethod.newInstance();
            }
            catch (Exception e) {
                this._logger.error((Object)("Could not create instance of " + sClass), (Throwable)e);
                throw new SSOException(17);
            }
            oAuthenticationMethod.start(this._configManager, eMethod);
        }
        catch (SSOException e) {
            throw e;
        }
        catch (Exception e) {
            this._logger.fatal((Object)"Internal error during object creation", (Throwable)e);
            throw new SSOException(1);
        }
        return oAuthenticationMethod;
    }

    private IAuthenticationMethod getAuthenticationMethod(List<IAuthenticationMethod> listMethods, IAuthenticationMethod currentMethod, String sAuthNProfile) throws SSOException {
        IAuthenticationMethod oMethod = null;
        int iCurrentMethod = 0;
        int iMax = listMethods.size();
        if (iMax == 0) {
            this._logger.error((Object)("No authentication methods available in pool: " + sAuthNProfile));
            throw new SSOException(1);
        }
        if (currentMethod != null) {
            iCurrentMethod = listMethods.indexOf(currentMethod);
            if (iCurrentMethod == -1) {
                this._logger.error((Object)("Current authentication method unavailable: " + currentMethod.getID()));
                throw new SSOException(1);
            }
            ++iCurrentMethod;
        }
        if (iCurrentMethod < iMax) {
            oMethod = listMethods.get(iCurrentMethod);
        }
        return oMethod;
    }
}

