/*
 * Decompiled with CFR 0.152.
 */
package com.alfaariss.oa.sso.web.profile.ssoquery.whitelist.jdbc;

import com.alfaariss.oa.OAException;
import com.alfaariss.oa.api.configuration.IConfigurationManager;
import com.alfaariss.oa.api.datastorage.IDataStorageFactory;
import com.alfaariss.oa.engine.core.Engine;
import com.alfaariss.oa.sso.web.profile.ssoquery.whitelist.IWhitelist;
import com.alfaariss.oa.util.database.DatabaseException;
import com.alfaariss.oa.util.database.jdbc.DataSourceFactory;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class JDBCWhitelist
implements IWhitelist {
    private static Log _logger;
    private static final String TABLE = "ssoquery_whitelist";
    private static final String COLUMN_ITEM = "item";
    private DataSource _dataSource;
    private String _querySelectItem;

    public JDBCWhitelist() {
        _logger = LogFactory.getLog(this.getClass());
        this._dataSource = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void start(IConfigurationManager configurationManager, Element config) throws OAException {
        Connection oConnection = null;
        try {
            Element eTable;
            Element eResource;
            block25: {
                eResource = configurationManager.getSection(config, "resource");
                if (eResource == null) {
                    IDataStorageFactory databaseFactory = Engine.getInstance().getStorageFactory();
                    if (databaseFactory != null && databaseFactory.isEnabled()) {
                        this._dataSource = databaseFactory.createModelDatasource();
                        if (this._dataSource == null) {
                            _logger.error((Object)"Could not create a valid datasource");
                            throw new DatabaseException(2);
                        }
                        _logger.info((Object)"Using datasource specified in engine");
                        break block25;
                    } else {
                        _logger.error((Object)"Could not create a valid datasource");
                        throw new DatabaseException(2);
                    }
                }
                try {
                    this._dataSource = DataSourceFactory.createDataSource((IConfigurationManager)configurationManager, (Element)eResource);
                    _logger.info((Object)"Using datasource specified in 'resource' section in configuration");
                }
                catch (DatabaseException e) {
                    IDataStorageFactory databaseFactory = Engine.getInstance().getStorageFactory();
                    if (databaseFactory != null && databaseFactory.isEnabled()) {
                        this._dataSource = databaseFactory.createModelDatasource();
                        if (this._dataSource == null) {
                            _logger.error((Object)"Could not create a valid datasource");
                            throw new DatabaseException(2);
                        }
                        _logger.info((Object)"Using datasource specified in engine");
                    }
                    _logger.error((Object)"Could not create a valid datasource", (Throwable)e);
                    throw new DatabaseException(2);
                }
            }
            try {
                oConnection = this._dataSource.getConnection();
            }
            catch (SQLException e) {
                _logger.error((Object)"Could not connect to resource", (Throwable)e);
                throw new DatabaseException(2);
            }
            String sTable = TABLE;
            if (eResource != null && (eTable = configurationManager.getSection(eResource, "table")) != null) {
                sTable = configurationManager.getParam(eTable, "name");
                if (sTable != null) {
                    _logger.error((Object)"No 'name' parameter found in 'table' section in configuration");
                    throw new DatabaseException(17);
                }
                _logger.info((Object)("Using configured whitelist table: " + sTable));
            }
            StringBuffer sbQuery = new StringBuffer("SELECT ");
            sbQuery.append(COLUMN_ITEM);
            sbQuery.append(" FROM ");
            sbQuery.append(sTable);
            sbQuery.append(" WHERE ");
            sbQuery.append(COLUMN_ITEM);
            String allowWildcard = configurationManager.getParam(config, "allowWildcard");
            if (allowWildcard != null) {
                _logger.info((Object)"Using wildcard tests for whitelist matches");
                sbQuery.append(" LIKE ?");
            } else {
                sbQuery.append("=?");
            }
            this._querySelectItem = sbQuery.toString();
            _logger.info((Object)("Using item selection query: " + this._querySelectItem));
            return;
        }
        catch (OAException e) {
            throw e;
        }
        catch (Exception e) {
            _logger.fatal((Object)"Internal error during start", (Throwable)e);
            throw new OAException(1);
        }
        finally {
            try {
                if (oConnection != null) {
                    oConnection.close();
                }
            }
            catch (Exception e) {
                _logger.error((Object)"Could not close connection", (Throwable)e);
            }
        }
    }

    @Override
    public boolean isWhitelisted(String item) throws OAException {
        Connection connection = null;
        Statement pSelect = null;
        ResultSet resultSet = null;
        try {
            connection = this._dataSource.getConnection();
            pSelect = connection.prepareStatement(this._querySelectItem);
            pSelect.setString(1, item);
            resultSet = pSelect.executeQuery();
            if (resultSet.next()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            _logger.fatal((Object)("Internal error during exist check for item: " + item), (Throwable)e);
            throw new OAException(1);
        }
        finally {
            try {
                if (pSelect != null) {
                    pSelect.close();
                }
            }
            catch (Exception e) {
                _logger.error((Object)"Could not close select statement", (Throwable)e);
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception e) {
                _logger.error((Object)"Could not close connection", (Throwable)e);
            }
        }
        return false;
    }

    @Override
    public void stop() {
    }
}

