/*
 * Decompiled with CFR 0.152.
 */
package com.alfaariss.oa.sso.web.profile.ssoquery.whitelist.config;

import com.alfaariss.oa.OAException;
import com.alfaariss.oa.api.configuration.IConfigurationManager;
import com.alfaariss.oa.sso.web.profile.ssoquery.whitelist.IWhitelist;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class ConfigWhitelist
implements IWhitelist {
    private static Log _logger;
    private List<String> _listItems;

    public ConfigWhitelist() {
        _logger = LogFactory.getLog(this.getClass());
        this._listItems = new Vector<String>();
    }

    @Override
    public void start(IConfigurationManager configurationManager, Element config) throws OAException {
        Element eItems = configurationManager.getSection(config, "items");
        if (eItems == null) {
            _logger.error((Object)"No 'items' section found in 'whitelist' section in configuration");
            throw new OAException(17);
        }
        Element eItem = configurationManager.getSection(eItems, "item");
        while (eItem != null) {
            String value = configurationManager.getParam(eItem, "value");
            if (value == null) {
                _logger.error((Object)"No 'value' section found in 'item' section in configuration");
                throw new OAException(17);
            }
            if (this._listItems.contains(value)) {
                _logger.error((Object)("Configured 'value' in 'item' section is not unique: " + value));
                throw new OAException(2);
            }
            this._listItems.add(value);
            eItem = configurationManager.getNextSection(eItem);
        }
    }

    @Override
    public boolean isWhitelisted(String item) throws OAException {
        return this._listItems.contains(item);
    }

    @Override
    public void stop() {
        if (this._listItems != null) {
            this._listItems.clear();
        }
    }
}

