/*
 * Decompiled with CFR 0.152.
 */
package com.alfaariss.oa.sso.web.profile.ssoquery;

import com.alfaariss.oa.OAException;
import com.alfaariss.oa.RequestorEvent;
import com.alfaariss.oa.UserEvent;
import com.alfaariss.oa.UserException;
import com.alfaariss.oa.api.IService;
import com.alfaariss.oa.api.configuration.IConfigurationManager;
import com.alfaariss.oa.api.logging.IAuthority;
import com.alfaariss.oa.api.sso.ISSOProfile;
import com.alfaariss.oa.api.tgt.ITGT;
import com.alfaariss.oa.engine.core.Engine;
import com.alfaariss.oa.engine.core.tgt.factory.ITGTFactory;
import com.alfaariss.oa.sso.web.profile.ssoquery.whitelist.IWhitelist;
import com.alfaariss.oa.util.logging.RequestorEventLogItem;
import com.alfaariss.oa.util.web.CookieTool;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class SSOQueryProfile
implements ISSOProfile,
IService,
IAuthority {
    public static final String PROFILE_ID = "ssoquery";
    private static final String PARAM_RESPONSE_URL = "response_url";
    private static final String PARAM_RESULT = "result";
    private static final String AUTHORITY_NAME = "SSOQuery";
    private static Log _logger;
    private static Log _eventLogger;
    private boolean _bEnabled;
    private CookieTool _cookieTool;
    private ITGTFactory<?> _tgtFactory;
    private String _sProfileID;
    private IWhitelist _whitelist;

    public SSOQueryProfile() {
        _logger = LogFactory.getLog(SSOQueryProfile.class);
        _eventLogger = LogFactory.getLog((String)"com.alfaariss.oa.EventLogger");
        this._bEnabled = false;
    }

    public void destroy() {
        this._bEnabled = false;
        this._cookieTool = null;
        if (this._whitelist != null) {
            this._whitelist.stop();
        }
    }

    public String getID() {
        return this._sProfileID;
    }

    public void init(ServletContext context, IConfigurationManager configurationManager, Element eParent, Element eSpecific) throws OAException {
        this._bEnabled = true;
        this._sProfileID = PROFILE_ID;
        if (eSpecific != null) {
            String sEnabled;
            this._sProfileID = configurationManager.getParam(eSpecific, "id");
            if (this._sProfileID == null) {
                this._sProfileID = PROFILE_ID;
                _logger.error((Object)("No 'id' item in 'profile' section in configuration, using default: " + this._sProfileID));
            }
            if ((sEnabled = configurationManager.getParam(eSpecific, "enabled")) != null) {
                if (sEnabled.equalsIgnoreCase("FALSE")) {
                    this._bEnabled = false;
                } else if (!sEnabled.equalsIgnoreCase("TRUE")) {
                    _logger.error((Object)("Unknown value in 'enabled' configuration item: " + sEnabled));
                    throw new OAException(17);
                }
            }
        }
        if (this._bEnabled) {
            this._tgtFactory = Engine.getInstance().getTGTFactory();
            this._cookieTool = new CookieTool(configurationManager, eParent);
            this.readWhitelistConfig(configurationManager, eSpecific);
        }
        _logger.info((Object)("Started SSO Query Request Profile: " + this._sProfileID));
    }

    public void service(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws OAException {
        try {
            ITGT tgt;
            if (!this._bEnabled) {
                _logger.debug((Object)"Component is disabled");
                throw new UserException(UserEvent.INTERNAL_ERROR);
            }
            _logger.debug((Object)("Performing 'sso query' request sent from IP: " + servletRequest.getRemoteAddr()));
            String responseUrl = servletRequest.getParameter(PARAM_RESPONSE_URL);
            if (responseUrl == null) {
                _logger.debug((Object)"No parameter 'response_url' available in request");
                throw new UserException(UserEvent.REQUEST_INVALID);
            }
            if (this._whitelist != null) {
                try {
                    URL urlResponse = new URL(responseUrl);
                    if (!this._whitelist.isWhitelisted(urlResponse.getHost())) {
                        _logger.debug((Object)("Hostname isn't whitelisted: " + urlResponse.getHost()));
                        throw new UserException(UserEvent.REQUEST_INVALID);
                    }
                }
                catch (MalformedURLException e) {
                    StringBuffer sbError = new StringBuffer("Invalid parameter '");
                    sbError.append(PARAM_RESPONSE_URL);
                    sbError.append("' available in request: ");
                    sbError.append(responseUrl);
                    _logger.debug((Object)sbError.toString());
                    throw new UserException(UserEvent.REQUEST_INVALID);
                }
            }
            String sResult = "false";
            String sTGTCookie = this._cookieTool.getCookieValue("oa_sso_id", servletRequest);
            if (sTGTCookie != null && (tgt = this._tgtFactory.retrieve((Object)sTGTCookie)) != null && !tgt.isExpired()) {
                sResult = "true";
            }
            StringBuffer sbRedirect = new StringBuffer(responseUrl);
            if (responseUrl.contains("?")) {
                sbRedirect.append("&");
            } else {
                sbRedirect.append("?");
            }
            sbRedirect.append(PARAM_RESULT);
            sbRedirect.append("=");
            sbRedirect.append(sResult);
            _eventLogger.info((Object)new RequestorEventLogItem(null, sTGTCookie, null, RequestorEvent.QUERY_SUCCESSFUL, null, servletRequest.getRemoteAddr(), null, (IAuthority)this, sResult));
            _logger.debug((Object)("Redirecting user to: " + sbRedirect.toString()));
            servletResponse.sendRedirect(sbRedirect.toString());
        }
        catch (UserException e) {
            try {
                if (!servletResponse.isCommitted()) {
                    servletResponse.sendError(400);
                }
            }
            catch (IOException e1) {
                _logger.debug((Object)"Could not respond", (Throwable)e1);
                throw new OAException(1);
            }
        }
        catch (Exception e) {
            _logger.fatal((Object)"Internal error during sso request", (Throwable)e);
            throw new OAException(1);
        }
    }

    public String getAuthority() {
        return AUTHORITY_NAME + this._sProfileID;
    }

    private void readWhitelistConfig(IConfigurationManager configurationManager, Element config) throws OAException {
        this._whitelist = null;
        Element eWhitelist = configurationManager.getSection(config, "whitelist");
        if (eWhitelist == null) {
            _logger.warn((Object)"No optional 'whitelist' section found in configuration");
            return;
        }
        String sClass = configurationManager.getParam(eWhitelist, "class");
        if (sClass == null) {
            _logger.error((Object)"No 'class' parameter found in 'whitelist' section");
            throw new OAException(17);
        }
        try {
            Class<?> cWhitelist = Class.forName(sClass);
            this._whitelist = (IWhitelist)cWhitelist.newInstance();
        }
        catch (ClassNotFoundException e) {
            _logger.error((Object)("Configured Whitelist class could not be found: " + sClass), (Throwable)e);
            throw new OAException(17);
        }
        catch (InstantiationException e) {
            _logger.error((Object)("Configured Whitelist class could not be instantiated: " + sClass), (Throwable)e);
            throw new OAException(17);
        }
        catch (IllegalAccessException e) {
            _logger.error((Object)("Configured Whitelist class could not be accessed: " + sClass), (Throwable)e);
            throw new OAException(17);
        }
        catch (ClassCastException e) {
            _logger.error((Object)("Configured Whitelist class isn't of type 'IWhitelist': " + sClass), (Throwable)e);
            throw new OAException(17);
        }
        this._whitelist.start(configurationManager, eWhitelist);
    }
}

