/*
 * Decompiled with CFR 0.152.
 */
package com.alfaariss.oa;

import com.alfaariss.oa.OAException;
import com.alfaariss.oa.SystemErrors;
import com.alfaariss.oa.api.IComponent;
import com.alfaariss.oa.api.IService;
import com.alfaariss.oa.api.configuration.IConfigurationManager;
import com.alfaariss.oa.api.helper.IHelper;
import com.alfaariss.oa.api.profile.IRequestorProfile;
import com.alfaariss.oa.engine.core.Engine;
import java.io.IOException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class OAServlet
extends HttpServlet
implements IComponent {
    private static final long serialVersionUID = 4028520551455105728L;
    private Map<String, IRequestorProfile> _profiles;
    private Map<String, IHelper> _helpers;
    private Log _logger = LogFactory.getLog(OAServlet.class);
    private ServletContext _context;
    private Engine _engine = Engine.getInstance();

    public OAServlet() {
        this._profiles = new Hashtable<String, IRequestorProfile>();
        this._helpers = new Hashtable<String, IHelper>();
    }

    public void init(ServletConfig oServletConfig) throws ServletException {
        try {
            this._context = oServletConfig.getServletContext();
            IConfigurationManager config = this._engine.getConfigurationManager();
            this.start(config, null);
            this._engine.addComponent((IComponent)this);
        }
        catch (OAException e) {
            this._logger.fatal((Object)"Error starting Asimba Server", (Throwable)e);
            this.stop();
            throw new ServletException(SystemErrors.toHexString((int)e.getCode()));
        }
        catch (Exception e) {
            this._logger.fatal((Object)"Error starting Asimba Server", (Throwable)e);
            this.stop();
            throw new ServletException(SystemErrors.toHexString((int)1));
        }
    }

    public void start(IConfigurationManager config, Element eConfig) throws OAException {
        Element eProfiles = config.getSection(null, "profiles");
        if (eProfiles == null) {
            this._logger.warn((Object)"No 'profiles' section found in configuration");
            throw new OAException(17);
        }
        this.loadProfiles(config, eProfiles);
        Element eHelpers = config.getSection(null, "helpers");
        if (eHelpers == null) {
            this._logger.warn((Object)"No 'helpers' section found in configuration");
            throw new OAException(17);
        }
        this.loadHelpers(config, eHelpers);
    }

    public void service(HttpServletRequest oRequest, HttpServletResponse oResponse) throws ServletException, IOException {
        block22: {
            try {
                String sRequestURI = oRequest.getRequestURI();
                if (this._profiles.isEmpty() && this._helpers.isEmpty()) {
                    oResponse.sendError(503, sRequestURI);
                }
                String sContextPath = oRequest.getContextPath();
                String sServletPath = oRequest.getServletPath();
                String sType = sRequestURI.substring(sContextPath.length());
                if (sType.length() <= 1) {
                    oResponse.sendError(400);
                } else {
                    int index = (sType = sType.substring(1, sType.length())).indexOf(47);
                    if (index <= 1) {
                        this._logger.debug((Object)("Bad request: no id in path: " + sServletPath));
                        oResponse.sendError(400);
                    } else {
                        String sId = sType.substring(index + 1, sType.length());
                        sType = sType.substring(0, index);
                        if (this._logger.isDebugEnabled()) {
                            this._logger.debug((Object)("Processing: " + sType + " request"));
                        }
                        if ((index = sId.indexOf(47)) > 0) {
                            sId = sId.substring(0, index);
                        }
                        try {
                            ServiceTypes type = ServiceTypes.valueOf(sType);
                            switch (type) {
                                case helpers: {
                                    IHelper helper = this._helpers.get(sId);
                                    if (helper == null || !(helper instanceof IService)) {
                                        oResponse.sendError(404, sRequestURI);
                                        break;
                                    }
                                    if (!helper.isEnabled()) {
                                        oResponse.sendError(503, sRequestURI);
                                        break;
                                    }
                                    ((IService)helper).service(oRequest, oResponse);
                                    break;
                                }
                                case profiles: {
                                    IRequestorProfile profile = this._profiles.get(sId);
                                    if (profile == null || !(profile instanceof IService)) {
                                        oResponse.sendError(404, sRequestURI);
                                        break;
                                    }
                                    ((IService)profile).service(oRequest, oResponse);
                                    break;
                                }
                            }
                        }
                        catch (IllegalArgumentException e) {
                            this._logger.debug((Object)"Bad request", (Throwable)e);
                            oResponse.sendError(400);
                        }
                        catch (NullPointerException e) {
                            this._logger.debug((Object)"Bad request", (Throwable)e);
                            oResponse.sendError(400);
                        }
                    }
                }
                if (!oResponse.isCommitted()) {
                    oResponse.sendError(200);
                }
            }
            catch (OAException e) {
                this._logger.error((Object)"Could not process request", (Throwable)e);
                if (!oResponse.isCommitted()) {
                    oResponse.sendError(500);
                }
            }
            catch (Exception e) {
                this._logger.fatal((Object)"Could not process request due to internal error", (Throwable)e);
                if (oResponse.isCommitted()) break block22;
                oResponse.sendError(500);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart(Element eConfig) throws OAException {
        OAServlet oAServlet = this;
        synchronized (oAServlet) {
            this._logger.info((Object)"Restarting profiles");
            this.stop();
            IConfigurationManager config = this._engine.getConfigurationManager();
            this.start(config, eConfig);
        }
    }

    public void destroy() {
        this.stop();
        this._engine.removeComponent((IComponent)this);
        this._logger.info((Object)"Stopped OA Servlet");
        super.destroy();
    }

    public synchronized void stop() {
        Collection<IRequestorProfile> profiles = this._profiles.values();
        for (IRequestorProfile profile : profiles) {
            profile.destroy();
        }
        this._profiles.clear();
        this._logger.info((Object)"Stopped profiles");
        Collection<IHelper> helpers = this._helpers.values();
        for (IHelper helper : helpers) {
            helper.destroy();
        }
        this._helpers.clear();
        this._logger.info((Object)"Stopped helpers");
    }

    private void loadProfiles(IConfigurationManager config, Element eProfiles) throws OAException {
        try {
            Element eProfile = config.getSection(eProfiles, "profile");
            while (eProfile != null) {
                String sClass = config.getParam(eProfile, "class");
                if (sClass == null) {
                    this._logger.error((Object)"No 'class' parameter found in 'profile' section");
                    throw new OAException(17);
                }
                IRequestorProfile profile = null;
                try {
                    Class<?> profileClass = Class.forName(sClass);
                    profile = (IRequestorProfile)profileClass.newInstance();
                }
                catch (ClassNotFoundException e) {
                    this._logger.error((Object)("Configured profile class could not be found: " + sClass), (Throwable)e);
                    throw new OAException(17);
                }
                catch (InstantiationException e) {
                    this._logger.error((Object)("Configured profile class could not be instantiated: " + sClass), (Throwable)e);
                    throw new OAException(17);
                }
                catch (IllegalAccessException e) {
                    this._logger.error((Object)("Configured profile class could not be accessed: " + sClass), (Throwable)e);
                    throw new OAException(17);
                }
                catch (ClassCastException e) {
                    this._logger.error((Object)("Configured profile class isn't of type 'IRequestorProfile': " + sClass), (Throwable)e);
                    throw new OAException(17);
                }
                profile.init(this._context, config, eProfile);
                this._profiles.put(profile.getID(), profile);
                this._logger.info((Object)("Started requestor profile: " + profile.getID()));
                eProfile = config.getNextSection(eProfile);
            }
            if (this._profiles.isEmpty()) {
                this._logger.info((Object)"No requestor profiles configured");
            } else {
                this._logger.info((Object)"Started Profiles");
            }
        }
        catch (OAException e) {
            throw e;
        }
        catch (Exception e) {
            this._logger.fatal((Object)"Could not load profiles", (Throwable)e);
            throw new OAException(1);
        }
    }

    private void loadHelpers(IConfigurationManager config, Element eHelpers) throws OAException {
        try {
            Element eHelper = config.getSection(eHelpers, "helper");
            while (eHelper != null) {
                String sId = config.getParam(eHelper, "id");
                if (sId == null) {
                    this._logger.error((Object)"No 'id' parameter found in 'helper' section");
                    throw new OAException(17);
                }
                String sClass = config.getParam(eHelper, "class");
                if (sClass == null) {
                    this._logger.error((Object)("No 'class' parameter found in 'helper' section: " + sId));
                    throw new OAException(17);
                }
                IHelper helper = null;
                try {
                    Class<?> helperClass = Class.forName(sClass);
                    helper = (IHelper)helperClass.newInstance();
                }
                catch (ClassNotFoundException e) {
                    this._logger.error((Object)("Configured helper class could not be found: " + sClass), (Throwable)e);
                    throw new OAException(17);
                }
                catch (InstantiationException e) {
                    this._logger.error((Object)("Configured helper class could not be instantiated: " + sClass), (Throwable)e);
                    throw new OAException(17);
                }
                catch (IllegalAccessException e) {
                    this._logger.error((Object)("Configured helper class could not be accessed: " + sClass), (Throwable)e);
                    throw new OAException(17);
                }
                catch (ClassCastException e) {
                    this._logger.error((Object)("Configured helper class isn't of type 'IHelper': " + sClass), (Throwable)e);
                    throw new OAException(17);
                }
                helper.init(this._context, config, eHelper);
                this._helpers.put(sId, helper);
                this._logger.info((Object)("Started helper: " + sId));
                eHelper = config.getNextSection(eHelper);
            }
            if (this._helpers.isEmpty()) {
                this._logger.info((Object)"No helpers configured");
            } else {
                this._logger.info((Object)"Started helpers");
            }
        }
        catch (OAException e) {
            throw e;
        }
        catch (Exception e) {
            this._logger.fatal((Object)"Could not load helpers", (Throwable)e);
            throw new OAException(1);
        }
    }

    private static enum ServiceTypes {
        helpers,
        profiles;

    }
}

